package com.bcxin.ins.coninsweb.preservation.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationDetailAPIService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.Auth;
import com.bcxin.ins.core.service.MyTposThrUserService;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.OSSFileUtil;
import com.bcxin.ins.vo.*;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.*;

/**
 * 自用保全申请单控制器
 * @author zxf
 *
 */
@Controller
@RequestMapping("/api/preservation")
public class InsPreservation_API_Controller extends BaseController {

	@Autowired
	private InsPreservationResultSetAPIService insPreservationResultSetAPIService;
	@Autowired
	private InsPreservationDetailAPIService insPreservationDetailAPIService;
	@Autowired
	private InsPreservationRecordAPIService insPreservationRecordAPIService;
	@Autowired
	private PolicyService policyService;
	@Autowired
	private ProductService productService;

	@Autowired
	private MyTposThrUserService myTposThrUserService;

	@Autowired
	private ClientUserService clientUserService;

	@Autowired
	private InsPreservationPayAPIService insPreservationPayAPIService;

	private static String PAYLIST = "payList";
	private static String PAY_STATUS = "pay_status";
	private static String PAYVO = "payVo";
	private static String RECORDVOLIST = "recordVoList";
	private static String PRESERVATIONID = "preservationId";
	private static String POLICYID = "policyId";
	private static String NOWDATE = "nowDate";
	private static String IPDVOLIST = "ipdVoList";
	private static String IPRSVOLIST = "iprsVoList";
	private static String IPRLIST = "iprList";
	private static String REVISE_STATUS = "revise_status";
	private static String START_TIME = "start_time";
	private static String END_TIME = "end_time";
	private static String KEYWORD = "keyword";
	private static String IPRVO = "iprVo";
	private static String DETAILLIST = "detailList";
	private static String ORDERVO = "orderVo";
	private static String RESULTSETLIST = "resultSetList";
	private static String MIN = "min";
	private static String MAX = "max";

	/**
	 * <b> 第三方token登录业务 </b>
	 * @author ZXF
	 * @create 2020/02/25 0025 14:31
	 * @version
	 * @注意事项 </b>
	 */
	private int partyLogin(String user_id, String login_name, String party, String token){
		int sgin = ConstProp.INT_NUMBER_ZERO;
		if(StringUtils.isBlank(user_id)||
				StringUtils.isBlank(login_name)||
				StringUtils.isBlank(party)||
				StringUtils.isBlank(token)){
			return ConstProp.INT_NUMBER_ONE;
		}
		Auth auth = myTposThrUserService.isAuth(party,token,getRequest());
		if(!auth.isSuccess()){
			return ConstProp.INT_NUMBER_ONE;
		}
		//白名单通过
		if(!clientUserService.saveClientUserVo(party,login_name,user_id)){
			return ConstProp.INT_NUMBER_ONE;
		}
		//是否有传省代码，如果有加入redis
		if(auth.getData()!=null&&auth.getData()!=""){
			ClientUserVo userdetail = UserSupportUtil.getSessionUser();
			if(userdetail == null){
				return sgin;
			}
			String key = ConstProp.ADDRESS_HEAD+userdetail.getOid();
			if(StringUtils.isEmpty(JedisUtils.get(key))){
				JedisUtils.set(key,String.valueOf(auth.getData()),ConstProp.ONE_HOURS_TIMEOUT_SECONDS);
			}
		}
		return sgin;
	}

	/**
	 * 百保盾做增员，减员调用的方法
	 * 调用百联保 保全页面数据展示的接口
	 * @author zxf
	 * @return
	 */
	@RequestMapping(value = "/resultSet/addPreservationView")
	public ModelAndView addPreservationView(String data, HttpServletRequest request) {
		ModelAndView view = new ModelAndView();

		Map<String, Object> map = new HashMap<String, Object>();
		List<InsPreservationDetailVo> list= null;
		try {
			list= MessageUtils.getList(data,InsPreservationDetailVo.class,"vo");
			String user_id = MessageUtils.getStringValueByKey(data,"user_id");
			String login_name = MessageUtils.getStringValueByKey(data,"login_name");
			String party = MessageUtils.getStringValueByKey(data,"party");
			String token = MessageUtils.getStringValueByKey(data,"token");

			int sgin = partyLogin(user_id, login_name, party, token);
			if(sgin == ConstProp.INT_NUMBER_ONE){
				view.setViewName("forward:/synopsis/loseView");
				return view;
			}
			String orderNo = MessageUtils.getStringValueByKey(data,"orderNo");//订单号
			String reviseType = MessageUtils.getStringValueByKey(data,"reviseType");//保全类型
			if(DictConst.REVISE_TYPE_Z.equals(reviseType)){
				OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(orderNo));
				view.addObject(ORDERVO,orderVo);
				view.setViewName("/coninsweb/api/preservation/resultSet/add_special_preservation_list");
			}else if(DictConst.REVISE_TYPE_J.equals(reviseType)){
				List<InsPreservationResultSet> resultSets = insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null,Long.parseLong(orderNo),ConstProp.BLANK_CHAR,ConstProp.DIGIT_ZERO,ConstProp.BLANK_CHAR,ConstProp.BLANK_CHAR);
				for(InsPreservationDetailVo ipdVo : list){
					for(InsPreservationResultSet iprs : resultSets){
						if(!ipdVo.getId_card().equals(iprs.getId_card())){
							continue;
						}
						if(iprs.getIns_preservation_result_set_id() != null){
							ipdVo.setBusiness_id(String.valueOf(iprs.getIns_preservation_result_set_id()));
							ipdVo.setBusiness_type(ConstProp.PRESERVE);
						}else{
							ipdVo.setBusiness_id(String.valueOf(iprs.getBelong_to_id()));
							ipdVo.setBusiness_type(iprs.getBelong_to_type());
						}
						break;
					}
				}
				view.setViewName("/coninsweb/api/preservation/resultSet/minus_special_preservation_list");
			}

			InsPreservationRecordVo iprVo = new InsPreservationRecordVo();
			iprVo.setIns_insurance_slip_id(orderNo);
			iprVo.setRevise_type(reviseType);
			iprVo.setInsPreservationDetailVoList(list);
			view.addObject(IPRVO,iprVo);
			view.addObject(IPDVOLIST,list);
			String resultDate = insPreservationRecordAPIService.getEffectiveByPolicyId(Long.parseLong(iprVo.getIns_insurance_slip_id()));
			view.addObject(MIN,resultDate.split(",")[0]);
			view.addObject(MAX,resultDate.split(",")[1]);
			setTokenByApi(view);
//			setValueSession(list);
		} catch (Exception e) {
			e.printStackTrace();
		}
		setTokenByApi(view);
		return view;
	}

	@RequestMapping(value = "/resultSet/test")
	public ModelAndView test() {
		ModelAndView view = new ModelAndView();
		view.setViewName("/coninsweb/api/preservation/resultSet/test");
		return view;
	}

	/**
	 * SASS做增员，减员调用的方法
	 * @author zxf
	 * @return
	 */
	@RequestMapping(value = "/resultSet/sassPreservationView")
	public ModelAndView sassPreservationView(String revise_type, String order_id, String cacheId) {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		logger.info("===========[sassPreservationView]：SAAS保全操作方法开始");
		ModelAndView view = new ModelAndView();
		List<InsPreservationDetailVo> list= policyService.getPreservationDetailVoByApi(cacheId,userdetail.getWeb_type());//获取第三方保全要操作人员
		try {
			logger.info("===========[sassPreservationView]（参数）：order_id="+order_id+"&revise_type="+revise_type+"&cacheId="+cacheId);
			List<InsPreservationResultSet> resultSets = insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null,Long.parseLong(order_id),ConstProp.BLANK_CHAR,ConstProp.DIGIT_ZERO,ConstProp.BLANK_CHAR,ConstProp.BLANK_CHAR);
			List<InsPreservationDetailVo> isIPDList = new ArrayList<InsPreservationDetailVo>();
			if(ConstProp.DIGIT_ONE.equals(revise_type)){
				for(InsPreservationDetailVo ipdVo : list){
					for(InsPreservationResultSet iprs : resultSets){
						if(ipdVo.getId_card().equals(iprs.getId_card())){
							isIPDList.add(ipdVo);
							list.remove(ipdVo);
						}
					}
				}
				OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
				view.addObject(ORDERVO,orderVo);
				view.setViewName("/coninsweb/api/preservation/resultSet/add_sass_preservation_list");
			}else if(ConstProp.DIGIT_TWO.equals(revise_type)){
				for(InsPreservationDetailVo ipdVo : list){
					for(InsPreservationResultSet iprs : resultSets){
						if(!ipdVo.getId_card().equals(iprs.getId_card())){
							continue;
						}
						if(iprs.getIns_preservation_result_set_id() != null){
							ipdVo.setBusiness_id(String.valueOf(iprs.getIns_preservation_result_set_id()));
							ipdVo.setBusiness_type(ConstProp.PRESERVE);
						}else{
							ipdVo.setBusiness_id(String.valueOf(iprs.getBelong_to_id()));
							ipdVo.setBusiness_type(iprs.getBelong_to_type());
						}
						break;
					}
				}
				view.setViewName("/coninsweb/api/preservation/resultSet/minus_sass_preservation_list");
			}
			logger.info("===========[sassPreservationView](页面地址)："+view.getViewName());
			InsPreservationRecordVo iprVo = new InsPreservationRecordVo();
			iprVo.setIns_insurance_slip_id(order_id);
			iprVo.setRevise_type(revise_type);
			iprVo.setInsPreservationDetailVoList(list);
			view.addObject(IPRVO,iprVo);
			view.addObject(IPDVOLIST,list);
			String resultDate = insPreservationRecordAPIService.getEffectiveByPolicyId(Long.parseLong(iprVo.getIns_insurance_slip_id()));
			view.addObject(MIN,resultDate.split(",")[0]);
			view.addObject(MAX,resultDate.split(",")[1]);
			setTokenByApi(view);
//			setValueSession(list);
		} catch (Exception e) {
			logger.info("===========[sassPreservationView](异常)："+e);
			e.printStackTrace();
		}
		logger.info("===========[sassPreservationView]：方法结束");
		return view;
	}

	@RequestMapping("/resultSet/openMessage")
	public ModelAndView openMessage() {
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/openMessage");
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b> 标记保单正在批改 </b>
	 * @author ZXF
	 * @create 2021/05/07 0007 11:14
	 * @version
	 * @注意事项 </b>
	 */
	private boolean setSignPD(String orderID){
		String key = ConstProp.REDIS_HEAD_POLICY_PD_SIGN+orderID;
		if(JedisUtils.exists(key)){
			return false;
		}
		JedisUtils.set(key,orderID, 50);
		return true;
	}

	/**
	 * <b> 删除保单批改标记 </b>
	 * @author ZXF
	 * @create 2021/05/07 0007 11:15
	 * @version
	 * @注意事项 </b>
	 */
	private void closeSignPD(String orderID){
		String key = ConstProp.REDIS_HEAD_POLICY_PD_SIGN+orderID;
		if(JedisUtils.exists(key)){
			JedisUtils.del(key);
		}
	}

	/**
	 * SASS做增员业务
	 * @author zxf
	 * @return
	 */
	@RequestMapping(value = "/resultSet/sassAddPreservationService")
	@ResponseBody
	public Result sassAddPreservationService(BLBAPIPreservationVo blbVo) {
		logger.info("===========[sassAddPreservationService]：SAAS保全操作方法开始");
		ClientUserVo userdetail = clientUserService.getClientUserVoForThir(blbVo.getUser_id(),blbVo.getParty());
		if(userdetail == null){
			return Result.fail("无用户信息");
		}
		if(StringUtils.isNotEmpty(blbVo.getListStr())){
			String str = blbVo.getListStr().replaceAll("&quot;","\"");
			blbVo.setListStr(str);
			blbVo.setList(JSONArray.parseArray(blbVo.getListStr(),InsPreservationDetailVo.class));
		}
		InsPreservationRecordVo vo = new InsPreservationRecordVo();
		vo.setComId(userdetail.getWeb_id());
		String payurl="";
		try {
			vo.setIns_insurance_slip_id(blbVo.getOrder_id());
			vo.setRevise_type(ConstProp.DIGIT_ONE);
			vo.setInception_date(blbVo.getInception_date());
			vo.setInsPreservationDetailVoList(blbVo.getList());
			vo.resetName();
			//人员校验
			String result = insPreservationDetailAPIService.detailSortAndValidator(vo);
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				return Result.fail(result.split(ConstProp.POUND_SIGN)[1]);
			}
//			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
//				String result1 = insPreservationDetailAPIService.personnelToCheck(ipdVo,vo.getRevise_type());
//				if(ConstProp.CODE_FAILURE.equals(result1.split(ConstProp.POUND_SIGN)[0])){
//					return Result.fail(result.split(ConstProp.POUND_SIGN)[1]);
//				}
//			}
			//过滤重复人员投保
			String str = insPreservationDetailAPIService.isDuplicateIdCardNoToPreservationDetail(vo.getIns_insurance_slip_id(),vo.getInsPreservationDetailVoList());
			if(ConstProp.CODE_FAILURE.equals(str.split(ConstProp.POUND_SIGN)[0])){
				return Result.fail(str.split(ConstProp.POUND_SIGN)[1]);
			}
			if(StringUtils.isNotEmpty(blbVo.getOrder_id())&&!setSignPD(blbVo.getOrder_id())){
				return Result.fail("保单存在进行中的批改任务，预计30秒后可重新发起操作");
			}
			logger.info("===========[sassAddPreservationService]：人员信息校验结束");
			Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, DictConst.RECORD_SIGN_TJ);
			logger.info("===========[sassAddPreservationService]：线上审核操作结束：map="+(map != null ? JSON.toJSONString(map):"null"));
			if(map != null){
				if("300".equals(map.get("ret"))){
					closeSignPD(blbVo.getOrder_id());
					if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
						insPreservationRecordAPIService.recordRestPAC(vo);
						new Thread(()-> { //异步
							//前海批改超时补偿
							insPreservationRecordAPIService.addFindPDTask(vo.getOid());
						}).start();
					}
					return Result.fail(map.get("msg"));
				}
				if(StringUtils.isNotEmpty(map.get("batchApplyNumber"))){
					vo.setRevise_serial_number(map.get("batchApplyNumber"));
					payurl=map.get("payurl");
				}
				vo.setRecordRest(map);
			}
		} catch (Exception e) {
			closeSignPD(blbVo.getOrder_id());
			logger.info("===========[sassAddPreservationService](异常)："+e);
			return Result.fail(e.getMessage());
		}
		//处理百联保保全申请单相关业务
		insPreservationRecordAPIService.recordRest(vo);
		closeSignPD(blbVo.getOrder_id());
//		if(StringUtils.isNotEmpty(payurl)){
//			payurl = GlobalResources.WEB_URL+"/synopsis/proxyCashierPage/"+ Base64.getEncoder().encodeToString(payurl.getBytes());
//		}
		return Result.success("批改信息已成功提交处理！",payurl);
	}

	/**
	 * SASS做减员业务
	 * @author zxf
	 * @return
	 */
	@RequestMapping(value = "/resultSet/sassMinusPreservationService")
	@ResponseBody
	public Result sassMinusPreservationService(BLBAPIPreservationVo blbVo) {
		logger.info("===========[sassMinusPreservationService]：SAAS保全操作方法开始");
		ClientUserVo userdetail = clientUserService.getClientUserVoForThir(blbVo.getUser_id(),blbVo.getParty());
		if(userdetail == null){
			return Result.fail("无用户信息");
		}
		if(StringUtils.isNotEmpty(blbVo.getListStr())){
			String str = blbVo.getListStr().replaceAll("&quot;","\"");
			blbVo.setListStr(str);
			blbVo.setList(JSONArray.parseArray(blbVo.getListStr(),InsPreservationDetailVo.class));
		}
		InsPreservationRecordVo vo = new InsPreservationRecordVo();
		vo.setComId(userdetail.getWeb_id());
		/**
		 * try {}内容用于处理人员信息校验，订单有效校验，保全单重复性校验，个别保险处理线上审核
		 */
		try {
			vo.setIns_insurance_slip_id(blbVo.getOrder_id());
			vo.setRevise_type(ConstProp.DIGIT_TWO);
			vo.setInception_date(blbVo.getInception_date());
			vo.setInsPreservationDetailVoList(blbVo.getList());
			vo.resetName();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				InsPreservationResultSet resultSet = insPreservationResultSetAPIService.getResultSetBypolicyIdAndCardNo(ipdVo.getId_card(), Long.parseLong(vo.getIns_insurance_slip_id()));
				if(resultSet != null){
					ipdVo.setBusiness_id(String.valueOf(resultSet.getIns_preservation_result_set_id()));
					ipdVo.setPrev_card(ipdVo.getId_card());
					ipdVo.setCareer(resultSet.getCareer());
					ipdVo.setName(resultSet.getName());
					ipdVo.setId_card(resultSet.getId_card());
				}else{
					return Result.fail("证件号码为："+ipdVo.getId_card()+"未找到人员信息！");
				}
//				Long resultSetId = insPreservationResultSetAPIService.getIdByIdCardAndOrderId(ipdVo.getId_card(), Long.parseLong(vo.getIns_insurance_slip_id()));
//				if(resultSetId != null){
//					ipdVo.setBusiness_id(String.valueOf(resultSetId));
//					ipdVo.setPrev_card(ipdVo.getId_card());
//				}else{
//					return Result.fail("证件号码为："+ipdVo.getId_card()+"未找到人员信息！");
//				}
//				String result1 = insPreservationDetailAPIService.personnelToCheck(ipdVo,vo.getRevise_type());
//				if(ConstProp.CODE_FAILURE.equals(result1.split(ConstProp.POUND_SIGN)[0])){
//					return Result.fail(result1.split(ConstProp.POUND_SIGN)[1]);
//				}
				ipdVo.setRevise_type(ConstProp.DIGIT_TWO);
			}
			String result = insPreservationDetailAPIService.detailSortAndValidator(vo);
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				return Result.fail(result.split(ConstProp.POUND_SIGN)[1]);
			}
			//过滤重复操作减员的人员
			String str = insPreservationDetailAPIService.notUnderWarrantyIdCardNo(vo.getIns_insurance_slip_id(),vo.getInsPreservationDetailVoList());
			if(ConstProp.CODE_FAILURE.equals(str.split(ConstProp.POUND_SIGN)[0])){
				return Result.fail(str.split(ConstProp.POUND_SIGN)[1]);
			}
			if(StringUtils.isNotEmpty(blbVo.getOrder_id())&&!setSignPD(blbVo.getOrder_id())){
				return Result.fail("保单存在进行中的批改任务，预计30秒后可重新发起操作");
			}
			logger.info("===========[sassMinusPreservationService]：人员信息校验结束");
			Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, DictConst.RECORD_SIGN_TJ);
			logger.info("===========[sassMinusPreservationService]：线上审核操作结束：map="+(map != null ? JSON.toJSONString(map):"null"));
			if(map != null){
				if("300".equals(map.get("ret"))){
					closeSignPD(blbVo.getOrder_id());
					if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
						insPreservationRecordAPIService.recordRestPAC(vo);
						new Thread(()-> { //异步
							//前海批改超时补偿
							insPreservationRecordAPIService.addFindPDTask(vo.getOid());
						}).start();
					}
					return Result.fail(map.get("msg"));
				}
				vo.setRecordRest(map);
			}
		} catch (Exception e) {
			closeSignPD(blbVo.getOrder_id());
			logger.info("===========[sassMinusPreservationService](异常)："+e);
			return Result.fail(e.getMessage());
		}
		//处理百联保保全申请单相关业务
		insPreservationRecordAPIService.recordRest(vo);
		closeSignPD(blbVo.getOrder_id());
		return Result.success("批改信息已成功提交处理！");
	}

	/**
	 * SASS在保未录入人员做减员业务
	 * @author zxf
	 * @return
	 */
	@RequestMapping(value = "/resultSet/sassSpecialMinusPreservationService")
	@ResponseBody
	public Result sassSpecialMinusPreservationService(BLBAPIPreservationVo blbVo) {
		logger.info("===========[sassMinusPreservationService]：SAAS保全操作方法开始");
		ClientUserVo userdetail = clientUserService.getClientUserVoForThir(blbVo.getUser_id(),blbVo.getParty());
		if(userdetail == null){
			return Result.fail("无用户信息");
		}
		InsPreservationRecordVo vo = new InsPreservationRecordVo();
		vo.setComId(userdetail.getWeb_id());
		/**
		 * try {}内容用于处理人员信息校验，订单有效校验，保全单重复性校验，个别保险处理线上审核
		 */
		try {
			if(StringUtils.isNotEmpty(blbVo.getListStr())&&StringUtils.isNotEmpty(blbVo.getOrder_id())){
				List<InsPreservationDetailVo> list = insPreservationResultSetAPIService.findInsPreservationDetailVoByIdCards(Long.parseLong(blbVo.getOrder_id()), blbVo.getListStr());
				if(list.size() == 0){
					return Result.fail("在保人员数据中未匹配到减员操作人员信息！");
				}
				blbVo.setList(list);
			}else{
				return Result.fail("未找到订单或人员信息！");
			}
			vo.setIns_insurance_slip_id(blbVo.getOrder_id());
			vo.setRevise_type(ConstProp.DIGIT_TWO);
			vo.setInception_date(blbVo.getInception_date());
			vo.setInsPreservationDetailVoList(blbVo.getList());
			vo.resetName();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				InsPreservationResultSet resultSet = insPreservationResultSetAPIService.getResultSetBypolicyIdAndCardNo(ipdVo.getId_card(), Long.parseLong(vo.getIns_insurance_slip_id()));
				if(resultSet != null){
					ipdVo.setBusiness_id(String.valueOf(resultSet.getIns_preservation_result_set_id()));
					ipdVo.setPrev_card(ipdVo.getId_card());
					ipdVo.setCareer(resultSet.getCareer());
					ipdVo.setName(resultSet.getName());
					ipdVo.setId_card(resultSet.getId_card());
				}else{
					return Result.fail("证件号码为："+ipdVo.getId_card()+"未找到人员信息！");
				}
//				Long resultSetId = insPreservationResultSetAPIService.getIdByIdCardAndOrderId(ipdVo.getId_card(), Long.parseLong(vo.getIns_insurance_slip_id()));
//				if(resultSetId != null){
//					ipdVo.setBusiness_id(String.valueOf(resultSetId));
//				}else{
//					return Result.fail("证件号码为："+ipdVo.getId_card()+"未找到人员信息！");
//				}
//				String result1 = insPreservationDetailAPIService.personnelToCheck(ipdVo,vo.getRevise_type());
//				if(ConstProp.CODE_FAILURE.equals(result1.split(ConstProp.POUND_SIGN)[0])){
//					return Result.fail(result1.split(ConstProp.POUND_SIGN)[1]);
//				}
				ipdVo.setRevise_type(ConstProp.DIGIT_TWO);
			}
			String result = insPreservationDetailAPIService.detailSortAndValidator(vo);
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				return Result.fail(result.split(ConstProp.POUND_SIGN)[1]);
			}
			if(StringUtils.isNotEmpty(blbVo.getOrder_id())&&!setSignPD(blbVo.getOrder_id())){
				return Result.fail("保单存在进行中的批改任务，预计30秒后可重新发起操作");
			}
			logger.info("===========[sassMinusPreservationService]：人员信息校验结束");
			Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, DictConst.RECORD_SIGN_TJ);
			logger.info("===========[sassMinusPreservationService]：线上审核操作结束：map="+(map != null ? JSON.toJSONString(map):"null"));
			if(map != null){
				if("300".equals(map.get("ret"))){
					closeSignPD(blbVo.getOrder_id());
					if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
						insPreservationRecordAPIService.recordRestPAC(vo);
						new Thread(()-> { //异步
							//前海批改超时补偿
							insPreservationRecordAPIService.addFindPDTask(vo.getOid());
						}).start();
					}
					return Result.fail(map.get("msg"));
				}
				vo.setRecordRest(map);
			}
		} catch (Exception e) {
			closeSignPD(blbVo.getOrder_id());
			logger.info("===========[sassMinusPreservationService](异常)："+e);
			return Result.fail(e.getMessage());
		}
		//处理百联保保全申请单相关业务
		insPreservationRecordAPIService.recordRest(vo);
		closeSignPD(blbVo.getOrder_id());
		return Result.success("批改信息已成功提交处理！");
	}

	/**
	 * saas身份证查询对应在保人员信息接口
	 * @author zxf
	 * @return
	 */
	@RequestMapping(value = "/resultSet/sassFindPerNameByIdCard")
	@ResponseBody
	public Result sassFindPerNameByIdCard(BLBAPIPreservationVo blbVo) {
		logger.info("===========[sassFindPerNameByIdCard]：saas身份证查询对应在保人员信息开始");
		String listStr = blbVo.getListStr();
		try {
			if(StringUtils.isNotBlank(listStr)){
				List<Map> list = insPreservationResultSetAPIService.sassFindPerNameByIdCard(listStr.split(ConstProp.COMMA));
				if(list.size()>0){
					logger.info("===========[sassFindPerNameByIdCard]：saas身份证查询对应在保人员信息结束");
					return Result.success(Result.SUCCESS_MSG,JSON.toJSONString(list));
				}
				return Result.fail("未查询到对应的在保人员！");
			}else{
				return Result.fail("数据缺失！");
			}

		} catch (Exception e) {
			logger.info("===========[sassFindPerNameByIdCard](异常)："+e);
			return Result.fail(e.getMessage());
		}
	}


	/**************************保全申请单业务*******************************/

	/**
	 * <b>保全申请单查询 </b>
	 *
	 * @param revise_status
	 * @param start_time
	 * @param end_time
	 * @param request
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("recordList")
	public ModelAndView recordList(String revise_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/recordList");
		page.setNumPerPage(5);
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		view.addObject(IPRLIST,insPreservationRecordAPIService.findInsPreservationRecordByKeyword( page, Long.parseLong(userdetail.getOid()), revise_status, start_time, et, keyword));
		view.addObject(REVISE_STATUS,revise_status);
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired
	@RequestMapping("getRecordListForPage")
	public ModelAndView ListForPage(String revise_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/recordList_table");
		view.addObject(IPRLIST,insPreservationRecordAPIService.findInsPreservationRecordByKeyword( page, Long.parseLong(userdetail.getOid()), revise_status, start_time, et, keyword));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>查看保全申请单详情 </b>
	 *
	 * @param preservationId
	 * @return
	 * @author ZXF
	 * @date 2017年1月12日 上午10:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("getRecordDetailByPreservationId/{preservationId}")
	public ModelAndView getRecordDetailByPreservationId(@PathVariable Long preservationId, HttpServletRequest request){
		ModelAndView view = new ModelAndView();
		InsPreservationRecordVo iprVo = insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
		if(DictConst.REVISE_TYPE_Z.equals(iprVo.getRevise_type())&&DictConst.REVISE_STATUS_ZC.equals(iprVo.getRevise_status())){
			view.setViewName("/coninsweb/api/preservation/addRecordDetail");
		}if(DictConst.REVISE_TYPE_T.equals(iprVo.getRevise_type())){
			view.setViewName("/coninsweb/api/preservation/recordRepDetail");
		}else{
			view.setViewName("/coninsweb/api/preservation/recordDetail");
		}
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
		view.addObject(ORDERVO,orderVo);
		view.addObject(IPRVO,iprVo);
		view.addObject(DETAILLIST,iprVo.getInsPreservationDetailVoList());
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>查看保全申请单详情中保全人员分页 </b>
	 *
	 * @param preservationId
	 * @param keyword
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2017年1月12日 上午10:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("recordDetailListForPage")
	public ModelAndView recordDetailListForPage(Long preservationId,String keyword, DwzPage page){
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/recordDetail_table");
		view.addObject(DETAILLIST,insPreservationDetailAPIService.findInsPreservationDetailByKeyword(page,preservationId,keyword));
		setTokenByApi(view);
		return view;
	}

	@RequestMapping("againRecord")
	@ResponseBody
	public JSONObject againRecord(long oid){
		JSONObject json = new JSONObject();
		String message;
		String status =ConstProp.CODE_FAILURE;
		try {
			if(insPreservationRecordAPIService.againRecord(oid)){
				message="再次提交审核成功！";
				status=ConstProp.CODE_SUCCESS;
			}else {
				message="提交审核失败！";
			}
		}catch (Exception e) {
			message=e.getMessage();
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}

	/**
	 * 增员再次提交审核的处理方法
	 * @param vo
	 * @return
	 */
	@RequestMapping("addAgainRecord")
	@ResponseBody
	public ResultDto addAgainRecord(InsPreservationRecordVo vo){
		//校验人员信息
		List<InsPreservationDetailVo> ipdVoList = vo.getInsPreservationDetailVoList();
		for(InsPreservationDetailVo ipdVo : ipdVoList){
			String result = insPreservationDetailAPIService.personnelToCheck(ipdVo,vo.getRevise_type());
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			ipdVo.setRevise_type(ConstProp.DIGIT_ONE);
		}
		if(insPreservationRecordAPIService.addAgainRecord(Long.parseLong(vo.getOid()), ipdVoList)){
			return new ResultDto("再次提交审核成功！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("提交审核失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	@RequestMapping("deleteInsPreservationRecord")
	@ResponseBody
	public JSONObject deleteInsPreservationRecord(long oid){
		JSONObject json = new JSONObject();
		String message="保全申请单删除失败！";
		String status =ConstProp.CODE_FAILURE;
		if(insPreservationRecordAPIService.deleteInsPreservationRecord(oid)){
			message="保全申请单删除成功！";
			status=ConstProp.CODE_SUCCESS;
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}

	@RequestMapping("revokeInsPreservationRecord")
	@ResponseBody
	public JSONObject revokeInsPreservationRecord(long oid){
		JSONObject json = new JSONObject();
		String message="保全申请单撤销失败！";
		String status =ConstProp.CODE_FAILURE;
		if(insPreservationRecordAPIService.revokeInsPreservationRecord(oid)) {
			message = "保全申请单撤销成功！";
			status = ConstProp.CODE_SUCCESS;
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}



	/**
	 * 跳转到人员修改界面
	 * @param operate 操作标识：add,minus,replace
	 * @param preservationId 保全申请单id（如果已存在id，且状态为待提交说明该单为暂存单页面需要可修改）
	 * @return
	 */
	@LoginRequired
	@RequestMapping("thr_preservation_view")
	public ModelAndView thr_preservation_view(String operate,Long preservationId){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ModelAndView view = new ModelAndView();
		if(preservationId == null){
			setTokenByApi(view);
			return view;
		}
		InsPreservationRecordVo iprVo = insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
		if("add".equals(operate)){
			view.setViewName("/coninsweb/api/preservation/update_detail_add");
		}else if("minus".equals(operate)){
			view.setViewName("/coninsweb/api/preservation/update_detail_minus");
			List<InsPreservationResultSet> rsaList = insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null,Long.parseLong(iprVo.getIns_insurance_slip_id()),ConstProp.BLANK_CHAR,ConstProp.DIGIT_ZERO,ConstProp.BLANK_CHAR,ConstProp.BLANK_CHAR);
			//当前在保的总人数
			view.addObject("rsaNum",rsaList!=null? rsaList.size() : 0);
			//当前需要提交减员的总人数
			view.addObject("ipdNum",iprVo.getInsPreservationDetailVoList()!=null? iprVo.getInsPreservationDetailVoList().size() : 0);
		}else{
			view.setViewName("/coninsweb/api/preservation/update_detail_replace");
		}
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
		view.addObject(ORDERVO,orderVo);
		view.addObject(IPRVO,iprVo);
		String resultDate = insPreservationRecordAPIService.getEffectiveByPolicyId(Long.parseLong(iprVo.getIns_insurance_slip_id()));
		view.addObject(MIN,resultDate.split(",")[0]);
		view.addObject(MAX,resultDate.split(",")[1]);
		setTokenByApi(view);
		return view;
	}

	/**
	 * 人员导入跳转到增员界面
	 * @param preservationId 保全申请单id（如果已存在id，且状态为待提交说明该单为暂存单页面需要可修改）
	 * @return
	 */
	@LoginRequired
	@RequestMapping("update_detail_add_upload")
	public ModelAndView update_detail_add_upload(Long preservationId){
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/update_detail_add_upload");
		if(preservationId != null){
			InsPreservationRecordVo iprVo = insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
			List<InsPreservationDetailVo> list = iprVo.getInsPreservationDetailVoList();
			for(InsPreservationDetailVo ipdVo : getValueSessionRecord()){
				list.add(ipdVo);
			}
			OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
			view.addObject(ORDERVO,orderVo);
			view.addObject(IPDVOLIST,list);
		}
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b> 导出所有保全信息 </b>
	 * @author ZXF
	 * @create 2020/01/19 0019 20:47
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/down_preservation_list")
	public void downPreservationList(HttpServletRequest req, HttpServletResponse resp) {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return;
		}
		String userId = userdetail.getOid();
		String keyword = req.getParameter("keyword");
		String start_time = req.getParameter("start_time");
		String end_time = req.getParameter("end_time");
		String name = req.getParameter("name");
		insPreservationDetailAPIService.downPreservationList(userId,keyword,name,start_time,end_time,resp);
	}

	/**
	 * excel文件上传并解析,批量导入人员，增员的导入功能
	 * @param request
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/uploadRoleFile")
	@ResponseBody
	public ResultDto uploadRoleFile(MultipartHttpServletRequest request) throws Exception {
		MultipartFile roleFile = request.getFile("role_record");
		List<InsPreservationDetailVo> list = null;
		String[] arrStr = {"name","id_type","id_card","tel","career","scheme","sex","birthday"};
		if(roleFile != null){
			com.alibaba.fastjson.JSONObject jo = insPreservationDetailAPIService.readIPDExcel(roleFile);
			if(ConstProp.CODE_SUCCESS.equals(jo.get("ret"))){
				list = (List<InsPreservationDetailVo>)jo.get("list");
			}else{
				return new ResultDto(String.valueOf(jo.get("msg")), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("文件上传失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(list!=null && !list.isEmpty()){
			if(setValueSessionRecord(list)){
				return new ResultDto("文件解析成功！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据缓存失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("未解析到可用数据！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}


	private boolean setValueSessionRecord(List<InsPreservationDetailVo> list) {
		JedisUtils.setObject(ConstProp.TB_IPD_LIST + getToken(),list,3 * 60);
		return true;
//		HttpServletRequest request = null;
//		if (RequestContextHolder.getRequestAttributes() != null) {
//			request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
//			HttpSession session = null;
//			String sessionId = JedisUtils.get(ConstProp.REDIS_HEAD_THR_TOKEN + getToken());
//			if(StringUtils.isNotEmpty(sessionId)){
//				//获取session
//				session = SessionContext.getInstance().getSession(sessionId);
//			}else{
//				session = request.getSession();
//			}
//			session.setAttribute(IPDVOLIST,list);
//			return true;
//		}else{
//			return false;
//		}
	}

	private List<InsPreservationDetailVo> getValueSessionRecord() {
		List<InsPreservationDetailVo> list = (List<InsPreservationDetailVo>)JedisUtils.getObject(ConstProp.TB_IPD_LIST + getToken());
		JedisUtils.delObject(ConstProp.TB_IPD_LIST + getToken());
//		HttpServletRequest request = null;
//		List<InsPreservationDetailVo> list = null;
//		if (RequestContextHolder.getRequestAttributes() != null) {
//			request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
//			HttpSession session = null;
//			String sessionId = JedisUtils.get(ConstProp.REDIS_HEAD_THR_TOKEN + getToken());
//			if(StringUtils.isNotEmpty(sessionId)){
//				//获取session
//				session = SessionContext.getInstance().getSession(sessionId);
//			}else{
//				session = request.getSession();
//			}
//			list = (List<InsPreservationDetailVo>)session.getAttribute(IPDVOLIST);
//			session.removeAttribute(IPDVOLIST);
//		}
		return list;
	}

	/**************************保全详情或结果集业务*******************************/

	/**
	 * 有效人员列表
	 * <b>从我的订单列表对已承保订单做保全，点击保全的按钮访问该控制器，获取人员列表，初始时加载订单的被保险人列表
	 * 如果已经做过保全且已审核就直接取最后一个有效保全申请单中获取有效人员结果集</b>
	 *
	 * @param request 关键字
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("/resultSet/resultSetList")
	public ModelAndView resultSetList(Long policyId, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/resultSetList");
		page.setNumPerPage(10);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		if(userdetail.getOid().equals(orderVo.getUser_oid())){
			view.addObject(RESULTSETLIST,insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page,policyId,keyword,ConstProp.DIGIT_ZERO,ConstProp.BLANK_CHAR,ConstProp.BLANK_CHAR));
			view.addObject(ORDERVO,orderVo);
		}
		view.addObject(KEYWORD,keyword);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired
	@RequestMapping("/resultSet/getResultSetListForPage")
	public ModelAndView ListForPage(Long policyId, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/resultSetList_table");
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		if(userdetail.getOid().equals(orderVo.getUser_oid())){
			view.addObject(RESULTSETLIST,insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page,policyId,keyword,ConstProp.DIGIT_ZERO,ConstProp.BLANK_CHAR,ConstProp.BLANK_CHAR));
		}
		setTokenByApi(view);
		return view;
	}

	/**
	 * 失效人员列表
	 * <b>从我的订单列表对已承保订单做保全，点击保全的按钮访问该控制器，获取人员列表，初始时加载订单的被保险人列表
	 * 如果已经做过保全且已审核就直接取最后一个有效保全申请单中获取有效人员结果集</b>
	 *
	 * @param start_time 批改时间开始
	 * @param end_time 批改时间截止
	 * @param request 关键字
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("/resultSet/noResultSetList")
	public ModelAndView noResultSetList(Long policyId, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/noResultSetList");
		page.setNumPerPage(10);
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		view.addObject(ConstProp.USERDETAIL,userdetail);
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		if(userdetail.getOid().equals(orderVo.getUser_oid())){
			view.addObject(RESULTSETLIST,insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page,policyId,keyword,ConstProp.DIGIT_ONE,start_time,et));
			view.addObject(ORDERVO,orderVo);
		}
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired
	@RequestMapping("/resultSet/getNoResultSetListForPage")
	public ModelAndView getNoResultSetListForPage(Long policyId, String start_time, String end_time, String keyword, DwzPage page){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/noResultSetList_table");
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		if(userdetail.getOid().equals(orderVo.getUser_oid())){
			view.addObject(RESULTSETLIST,insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page,policyId,keyword,ConstProp.DIGIT_ONE,start_time,et));
		}
		setTokenByApi(view);
		return view;
	}

	/**
	 * 查询保障服务内容
	 * @param policyId 订单id
	 * @return
	 */
	@LoginRequired
	@RequestMapping("/resultSet/schemeDetail")
	public ModelAndView schemeDetail(Long policyId){
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/scheme_detail");
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		view.addObject(ORDERVO,orderVo);
		setTokenByApi(view);
		return view;
	}
	/**
	 * 跳转到增员界面
	 * @param policyId 订单id
	 * @return
	 */
	@LoginRequired
	@RequestMapping("/resultSet/add_preservation_view")
	public ModelAndView add_preservation_view(Long policyId){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/add_preservation_list");
		InsPreservationRecordVo iprVo = new InsPreservationRecordVo();
		iprVo.setIns_insurance_slip_id(String.valueOf(policyId));
		/*if(!userdetail.getWeb_type().contains("BLB")){
			List<InsPreservationResultSetVo> iprsVoList = policyService.getPersonByUserID_BBDAPI(String.valueOf(userdetail.getWeb_id()),userdetail.getWeb_type(),ConstProp.DIGIT_ONE);
			iprVo.setInsPreservationResultSetVoList(iprsVoList);
		}*/
		String resultDate = insPreservationRecordAPIService.getEffectiveByPolicyId(policyId);
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		view.addObject(ORDERVO,orderVo);
		view.addObject(MIN,resultDate.split(",")[0]);
		view.addObject(MAX,resultDate.split(",")[1]);
		view.addObject("preservationVo", iprVo);
		view.addObject(NOWDATE, DateUtil.getCurrentDateTime());
		setTokenByApi(view);
		return view;
	}

	/**
	 * 人员导入跳转到增员界面
	 * @param preservationId 保全申请单id（如果已存在id，且状态为待提交说明该单为暂存单页面需要可修改）
	 * @return
	 */
	@LoginRequired
	@RequestMapping("/resultSet/add_upload_view")
	public ModelAndView add_upload_view(Long preservationId,HttpServletRequest request){
		String product_code = request.getParameter("product_code");
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/resultSet/add_upload_list");
		if(preservationId != null){
			view.addObject(IPRSVOLIST,insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId));
		}
		view.addObject("product_code",product_code);
		view.addObject(IPRSVOLIST,getValueSession());
		setTokenByApi(view);
		return view;
	}

	/**
	 * 增员业务做校验及数据更新
	 * @param vo 保全申请单辅助类，其中包含保全人员信息列表
	 * @param sign 标识数据是否暂存，0直接提交，1暂存
	 * @return
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_RECORD,title ="【请求】个人中心-增员")
	@LoginRequired
	@RequestMapping("/resultSet/add_preservation_service")
	@ResponseBody
	public ResultDto add_preservation_service(InsPreservationRecordVo vo,String sign) {
		if(ConstProp.DIGIT_ONE.equals(sign)){
			vo.resetName();
			String result = insPreservationDetailAPIService.detailSortAndValidator(vo);
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
//			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
//				String result1 = insPreservationDetailAPIService.personnelToCheck(ipdVo,vo.getRevise_type());
//				if(ConstProp.CODE_FAILURE.equals(result1.split(ConstProp.POUND_SIGN)[0])){
//					return new ResultDto(result1.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
//				}
//			}
		}else{
			List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				if(StringUtils.isNotEmpty(ipdVo.getName())
						||StringUtils.isNotEmpty(ipdVo.getId_card())
						||StringUtils.isNotEmpty(ipdVo.getTel())
						||StringUtils.isNotEmpty(ipdVo.getBirthday())){
					ipdVoSortList.add(ipdVo);
				}
			}
			if(ipdVoSortList.size() == 0){
				return new ResultDto("暂存人员信息不能为空！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			vo.setInsPreservationDetailVoList(ipdVoSortList);
		}
		//过滤重复人员投保
		String str = insPreservationDetailAPIService.isDuplicateIdCardNoToPreservationDetail(vo.getIns_insurance_slip_id(),vo.getInsPreservationDetailVoList());
		if(ConstProp.CODE_FAILURE.equals(str.split(ConstProp.POUND_SIGN)[0])){
			return new ResultDto(str.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, sign);
		if(map != null){
			if("300".equals(map.get("ret"))){
				if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
					insPreservationRecordAPIService.recordRestPAC(vo);
					new Thread(()-> { //异步
						//前海批改超时补偿
						insPreservationRecordAPIService.addFindPDTask(vo.getOid());
					}).start();
				}
				return new ResultDto(map.get("msg"), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(StringUtils.isNotEmpty(map.get("batchApplyNumber"))){
				vo.setRevise_serial_number(map.get("batchApplyNumber"));
			}
		}
		//数据更新创建保全申请单
		if(insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign),vo,vo.getInsPreservationDetailVoList())){
			if(!ConstProp.DIGIT_ONE.equals(sign)){
				//暂存
				return new ResultDto("保存成功，请进入“批改申请记录”中查看保存的批改申请！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
			String m = "批改信息成功提交审核！";
			if(map != null && !map.containsKey("isPendingApproval")){
				m = "批改信息已通过审核！";
			}
			String payurl = map.get("payurl");
//			if(StringUtils.isNotEmpty(payurl)){
//				payurl = GlobalResources.WEB_URL+"/synopsis/proxyCashierPage/"+ Base64.getEncoder().encodeToString(payurl.getBytes());
//			}
			return new ResultDto(m, ConstProp.CODE_SUCCESS, vo.getOid(), ConstProp.BLANK_CHAR, payurl);
		}else{
			return new ResultDto("数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * 跳转到减员或者替换界面
	 * @param policyId 订单id
	 * @param preservationId 保全申请单id（如果已存在id，且状态为待提交说明该单为暂存单页面需要可修改）
	 * @param check_some 页面勾选的条目数组字符串（格式：123123;ROLE#345345;THIS）
	 * @param operate 跳转减员或替换界面的标识
	 * @return
	 */
	@LoginRequired
	@RequestMapping("/resultSet/minus_or_replace_view")
	public ModelAndView minus_preservation_view(Long policyId,Long preservationId,String check_some,String operate){
		ModelAndView view = new ModelAndView();
		if("minus".equals(operate)){
			view.setViewName("/coninsweb/api/preservation/resultSet/minus_preservation_list");
		}else if("replace".equals(operate)){
			view.setViewName("/coninsweb/api/preservation/resultSet/replace_preservation_list");
		}
		InsPreservationRecordVo iprVo = null;
		if(preservationId != null){
			iprVo = insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
		}else{
			iprVo = new InsPreservationRecordVo();
			iprVo.setIns_insurance_slip_id(String.valueOf(policyId));
			List<InsPreservationResultSetVo> iprsVoList = new ArrayList<InsPreservationResultSetVo>();
			InsPreservationResultSetVo iprsVo = null;
			String[] arr = check_some.split(ConstProp.POUND_SIGN);
			for(String str : arr){
				if(StringUtils.isEmpty(str)){
					continue;
				}
				String oid = str.split(ConstProp.SEMICOLON)[0],sign = str.split(ConstProp.SEMICOLON)[1];
				iprsVo = insPreservationResultSetAPIService.getInsPreservationResultSetVoByOidAndSign(oid,sign);
				iprsVoList.add(iprsVo);
				iprsVo = null;
			}
			iprVo.setInsPreservationResultSetVoList(iprsVoList);
		}
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		view.addObject(ORDERVO,orderVo);
		String resultDate = insPreservationRecordAPIService.getEffectiveByPolicyId(policyId);
		view.addObject(MIN,resultDate.split(",")[0]);
		view.addObject(MAX,resultDate.split(",")[1]);
		view.addObject(POLICYID,policyId);
		view.addObject("preservationVo",iprVo);
		view.addObject(NOWDATE, DateUtil.getCurrentDateTime());
		setTokenByApi(view);
		return view;
	}

	/**
	 * 减员业务做校验及数据更新
	 * @param vo 保全申请单辅助类
	 * @param sign 标识数据是否暂存，0直接提交，1暂存
	 * @return
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_RECORD,title ="【请求】个人中心-减员")
	@LoginRequired
	@RequestMapping("/resultSet/minus_preservation_service")
	@ResponseBody
	public ResultDto minus_preservation_service(InsPreservationRecordVo vo,String sign) throws Exception {
		//校验人员信息,低于或等于3人时不可进行减员暂存或提交
//		String msg = insPreservationDetailAPIService.empConfine(vo);
//		if(ConstProp.CODE_FAILURE.equals(msg.split(ConstProp.POUND_SIGN)[0])){
//			return new ResultDto(msg.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
//		}
		if(ConstProp.DIGIT_ONE.equals(sign)){
			vo.resetName();
			//校验人员信息
			String result = insPreservationDetailAPIService.detailSortAndValidator(vo);
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
//			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
//				String result1 = insPreservationDetailAPIService.personnelToCheck(ipdVo,vo.getRevise_type());
//				if(ConstProp.CODE_FAILURE.equals(result1.split(ConstProp.POUND_SIGN)[0])){
//					return new ResultDto(result1.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
//				}
//			}
		}else{
			List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				if(StringUtils.isNotEmpty(vo.getIns_insurance_slip_id())){
					InsPreservationResultSet resultSet = insPreservationResultSetAPIService.getResultSetBypolicyIdAndCardNo(ipdVo.getId_card(), Long.parseLong(vo.getIns_insurance_slip_id()));
					if(resultSet != null){
						ipdVo.setBusiness_id(String.valueOf(resultSet.getIns_preservation_result_set_id()));
						ipdVo.setPrev_card(ipdVo.getId_card());
						ipdVo.setCareer(resultSet.getCareer());
						ipdVo.setName(resultSet.getName());
						ipdVo.setId_card(resultSet.getId_card());
					}
				}
				if(StringUtils.isNotEmpty(ipdVo.getBusiness_id())
						||StringUtils.isNotEmpty(ipdVo.getBusiness_type())){
					ipdVoSortList.add(ipdVo);
				}
			}
			vo.setInsPreservationDetailVoList(ipdVoSortList);
		}
		Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, sign);
		if(map != null){
			if("300".equals(map.get("ret"))){
				if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
					insPreservationRecordAPIService.recordRestPAC(vo);
					new Thread(()-> { //异步
						//前海批改超时补偿
						insPreservationRecordAPIService.addFindPDTask(vo.getOid());
					}).start();
				}
				return new ResultDto(map.get("msg"), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}
		//数据更新创建保全申请单
		if(insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign),vo,vo.getInsPreservationDetailVoList())){
			if(!ConstProp.DIGIT_ONE.equals(sign)){
				//暂存
				return new ResultDto("保存成功，请进入“批改申请记录”中查看保存的批改申请！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
			String m = "批改信息成功提交审核！";
			if(map != null && !map.containsKey("isPendingApproval")){
				m = "批改信息已通过审核！";
			}
			return new ResultDto(m, ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * 保全申请单的详情页中如果该单状态为待提交减员业务就调用该控制器
	 * @param vo 保全申请单辅助类
	 * @param sign 标识数据是否暂存，0直接提交，1暂存
	 * @return
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_RECORD,title ="【请求】个人中心-减员")
	@LoginRequired
	@RequestMapping("/resultSet/update_detail_minus_service")
	@ResponseBody
	public ResultDto update_detail_minus_service(InsPreservationRecordVo vo,String sign) throws Exception {
		//校验人员信息
		List<InsPreservationDetailVo> ipdVoList = vo.getInsPreservationDetailVoList();
		if(ipdVoList == null){
			return new ResultDto("当前保全无有效人员信息请手动删除该单", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
//		for(InsPreservationDetailVo ipdVo : ipdVoList){
//			String result1 = insPreservationDetailAPIService.personnelToCheck(ipdVo,vo.getRevise_type());
//			if(ConstProp.CODE_FAILURE.equals(result1.split(ConstProp.POUND_SIGN)[0])){
//				return new ResultDto(result1.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
//			}
//		}
		//校验人员信息
//		String msg = insPreservationDetailAPIService.empConfine(vo);
//		if(ConstProp.CODE_FAILURE.equals(msg.split(ConstProp.POUND_SIGN)[0])){
//			return new ResultDto(msg.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
//		}

		if(ConstProp.DIGIT_ONE.equals(sign)){
			vo.resetName();
			//校验人员信息
			String result = insPreservationDetailAPIService.detailSortAndValidator(vo);
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				if(StringUtils.isNotEmpty(ipdVo.getOid())){
					ipdVoSortList.add(ipdVo);
				}
			}
			vo.setInsPreservationDetailVoList(ipdVoSortList);
		}
		Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, sign);
		if(map != null){
			if("300".equals(map.get("ret"))){
				if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
					insPreservationRecordAPIService.recordRestPAC(vo);
					new Thread(()-> { //异步
						//前海批改超时补偿
						insPreservationRecordAPIService.addFindPDTask(vo.getOid());
					}).start();
				}
				return new ResultDto(map.get("msg"), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}
		//数据更新创建保全申请单
		if(insPreservationRecordAPIService.minusInsPreservationRecord(Integer.parseInt(sign),vo,vo.getInsPreservationDetailVoList())){
			if(!ConstProp.DIGIT_ONE.equals(sign)) {
				//暂存
				return new ResultDto("保存成功，请进入“批改申请记录”中查看保存的批改申请！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
			String m = "批改信息成功提交审核！";
			if(map != null && !map.containsKey("isPendingApproval")){
				m = "批改信息已通过审核！";
			}
			return new ResultDto(m, ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * 增员业务做校验及数据更新
	 * @param vo 保全申请单辅助类，其中包含保全人员信息列表
	 * @param sign 标识数据是否暂存，0直接提交，1暂存
	 * @return
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_RECORD,title ="【请求】个人中心-替换")
	@LoginRequired
	@RequestMapping("/resultSet/replace_preservation_service")
	@ResponseBody
	public ResultDto replace_preservation_service(InsPreservationRecordVo vo,String sign) {
		if(ConstProp.DIGIT_ONE.equals(sign)){
			vo.resetName();
			String result = insPreservationDetailAPIService.detailSortAndValidator(vo);
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
//			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
//				String result1 = insPreservationDetailAPIService.personnelToCheck(ipdVo,vo.getRevise_type());
//				if(ConstProp.CODE_FAILURE.equals(result1.split(ConstProp.POUND_SIGN)[0])){
//					return new ResultDto(result1.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
//				}
//			}
		}else{
			List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				if(StringUtils.isNotEmpty(ipdVo.getBusiness_id())
						||StringUtils.isNotEmpty(ipdVo.getBusiness_type())){
					ipdVoSortList.add(ipdVo);
				}
			}
			vo.setInsPreservationDetailVoList(ipdVoSortList);
		}
		//过滤重复人员投保
		String str = insPreservationDetailAPIService.isDuplicateIdCardNoToPreservationDetail(vo.getIns_insurance_slip_id(),vo.getInsPreservationDetailVoList());
		if(ConstProp.CODE_FAILURE.equals(str.split(ConstProp.POUND_SIGN)[0])){
			return new ResultDto(str.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, sign);
		if(map != null){
			if("300".equals(map.get("ret"))){
				if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
					insPreservationRecordAPIService.recordRestPAC(vo);
					new Thread(()-> { //异步
						//前海批改超时补偿
						insPreservationRecordAPIService.addFindPDTask(vo.getOid());
					}).start();
				}
				return new ResultDto(map.get("msg"), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}
		//数据更新创建保全申请单
		if(insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign),vo,vo.getInsPreservationDetailVoList())){
			if(!ConstProp.DIGIT_ONE.equals(sign)){
				//暂存
				return new ResultDto("保存成功，请进入“批改申请记录”中查看保存的批改申请！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
			String m = "批改信息成功提交审核！";
			if(map != null && !map.containsKey("isPendingApproval")){
				m = "批改信息已通过审核！";
			}
			return new ResultDto(m, ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	@RequestMapping("/resultSet/deleteRecordDetail")
	@ResponseBody
	public JSONObject deleteRecordDetail(long oid){
		JSONObject json = new JSONObject();
		String message="人员信息删除失败！";
		String status =ConstProp.CODE_FAILURE;
		if(insPreservationDetailAPIService.deleteInsPreservationDetail(oid)){
			message="人员信息删除成功！";
			status=ConstProp.CODE_SUCCESS;
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}

	/**
	 * excel文件上传并解析,批量导入人员，增员的导入功能
	 * @param request
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/resultSet/uploadRoleFile")
	@ResponseBody
	public ResultDto resultUploadRoleFile(MultipartHttpServletRequest request) throws Exception {
		MultipartFile roleFile = request.getFile("role_record");
		List<InsPreservationResultSetVo> list = null;
		if(roleFile != null){
			JSONObject jo = insPreservationResultSetAPIService.readIPRSExcel(roleFile);
			if(ConstProp.CODE_SUCCESS.equals(jo.get("ret"))){
				list = (List<InsPreservationResultSetVo>)jo.get("list");
				if(list.size()<1){
					return new ResultDto("Excel中无人员数据或存在空白行！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}else{
				return new ResultDto(String.valueOf(jo.get("msg")), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("文件上传失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(list!=null && !list.isEmpty()){
			if(setValueSession(list)){
				return new ResultDto("文件解析成功！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据缓存失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("未解析到可用数据！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	private boolean setValueSession(List<InsPreservationResultSetVo> list) {
		JedisUtils.setObject(ConstProp.TB_IPRS_LIST + getToken(),list,3 * 60);
		return true;
//		HttpServletRequest request = null;
//		if (RequestContextHolder.getRequestAttributes() != null) {
//			request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
//			HttpSession session = null;
//			String sessionId = JedisUtils.get(ConstProp.REDIS_HEAD_THR_TOKEN + getToken());
//			if(StringUtils.isNotEmpty(sessionId)){
//				//获取session
//				session = SessionContext.getInstance().getSession(sessionId);
//			}else{
//				session = request.getSession();
//			}
//			session.setAttribute(IPRSVOLIST,list);
//			return true;
//		}else{
//			return false;
//		}
	}

	private List<InsPreservationResultSetVo> getValueSession() {
		List<InsPreservationResultSetVo> list = (List<InsPreservationResultSetVo>)JedisUtils.getObject(ConstProp.TB_IPRS_LIST + getToken());
		JedisUtils.delObject(ConstProp.TB_IPRS_LIST + getToken());
//		HttpServletRequest request = null;
//		List<InsPreservationResultSetVo> list = null;
//		if (RequestContextHolder.getRequestAttributes() != null) {
//			request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
//			HttpSession session = null;
//			String sessionId = JedisUtils.get(ConstProp.REDIS_HEAD_THR_TOKEN + getToken());
//			if(StringUtils.isNotEmpty(sessionId)){
//				//获取session
//				session = SessionContext.getInstance().getSession(sessionId);
//			}else{
//				session = request.getSession();
//			}
//			list = (List<InsPreservationResultSetVo>)session.getAttribute(IPRSVOLIST);
//			session.removeAttribute(IPRSVOLIST);
//		}
		return list;
	}


	/**************************保全缴费单业务*******************************/

	/**
	 * <b>我的订单-出口险 页面初始化 </b>
	 *
	 * @param pay_status
	 * @param start_time
	 * @param end_time
	 * @param request
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("/pay/payList")
	public ModelAndView payList(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/payList");
		page.setNumPerPage(5);
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationBillVoByKeyword( page, Long.parseLong(userdetail.getOid()), pay_status, start_time, et, keyword));
		view.addObject(PAY_STATUS,pay_status);
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired
	@RequestMapping("/pay/getPayListForPage")
	public ModelAndView getPayListForPage(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/payList_table");
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationBillVoByKeyword( page, Long.parseLong(userdetail.getOid()), pay_status, start_time, et, keyword));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>汇总账单下级账单列表 </b>
	 *
	 * @param pay_status
	 * @param start_time
	 * @param end_time
	 * @param request
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("/pay/billList")
	public ModelAndView billList(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		String parentPayId = request.getParameter("parentPayId");
		String isPart = request.getParameter("isPart");
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/billList");
		page.setNumPerPage(5);
		String et = ConstProp.BLANK_CHAR;
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		InsPreservationPayVo payVo = insPreservationPayAPIService.findInsPreservationPayVoById(Long.parseLong(parentPayId));
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationChildBillVoByKeyword( page, Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), pay_status, start_time, et, keyword));
		view.addObject(PAY_STATUS,pay_status);
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		view.addObject("insPreservationPayVo",payVo);
		view.addObject("parentPayId",parentPayId);
		view.addObject("isPart",isPart);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired
	@RequestMapping("/pay/getBillListForPage")
	public ModelAndView getBillListForPage(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		String parentPayId = request.getParameter("parentPayId");
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/billList_table");
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationChildBillVoByKeyword( page, Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), pay_status, start_time, et, keyword));
		setTokenByApi(view);
		return view;
	}

	@LoginRequired
	@RequestMapping("/pay/settlementList")
	public ModelAndView settlementList(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/settlementList");
		page.setNumPerPage(5);
		String et = ConstProp.BLANK_CHAR;
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationSettlementVoByKeyword( page, Long.parseLong(userdetail.getOid()), start_time, et, keyword));
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired
	@RequestMapping("/pay/getSettlementListForPage")
	public ModelAndView getSettlementListForPage(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/settlementList_table");
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationSettlementVoByKeyword( page, Long.parseLong(userdetail.getOid()), start_time, et, keyword));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>汇总账单下级账单列表 </b>
	 *
	 * @param start_time
	 * @param end_time
	 * @param request
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("/pay/settlementBillList")
	public ModelAndView settlementBillList(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		String parentPayId = request.getParameter("parentPayId");
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/settlementBillList");
		page.setNumPerPage(5);
		String et = ConstProp.BLANK_CHAR;
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationChildSettlementVoByKeyword( page, Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), start_time, et, keyword));
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		view.addObject("parentPayId",parentPayId);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired
	@RequestMapping("/pay/getSettlementBillListForPage")
	public ModelAndView getSettlementBillListForPage(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		String parentPayId = request.getParameter("parentPayId");
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/settlementBillList_table");
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationChildSettlementVoByKeyword( page, Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), start_time, et, keyword));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>查看保全缴费详情 </b>
	 *
	 * @param payId
	 * @return
	 * @author ZXF
	 * @date 2017年1月12日 上午10:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("/pay/getInsPreservationPayByPayId/{payId}")
	public ModelAndView getInsPreservationPayByPayId(@PathVariable Long payId, HttpServletRequest request){
		ModelAndView view = new ModelAndView();
		InsPreservationPayVo payVo = insPreservationPayAPIService.findInsPreservationPayVoById(payId);
		List<ProductVo> list = productService.getProductsByOnLine(payVo.getProduct_code());
		view.setViewName("/coninsweb/personalCenter/preservation/pay/payDetail");
		view.addObject(PAYVO,payVo);
		view.addObject("productDto",list.get(0));
		view.addObject(RECORDVOLIST,payVo.getInsPreservationRecordVoList());
		setTokenByApi(view);
		return view;
	}

	/**
	 * 保全缴费详情中保全申请单列表分页
	 * @param payId 保全缴费id
	 * @param keyword 关键字
	 * @param page
	 * @return
	 */
	@LoginRequired
	@RequestMapping("/pay/getRecordVoListForPage")
	public ModelAndView getRecordVoListForPage(Long payId, String keyword, DwzPage page){
		ModelAndView view = new ModelAndView("/coninsweb/api/preservation/pay/recordVoList_table");
		view.addObject(RECORDVOLIST,insPreservationRecordAPIService.findInsPreservationRecordVoByPayId( page, payId, keyword));
		setTokenByApi(view);
		return view;
	}

	/**
	 * excel文件上传并解析,批量导入人员，增员的导入功能
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/pay/uploadFilePay")
	@ResponseBody
	public ResultDto uploadFilePay(MultipartHttpServletRequest request) throws Exception {
		MultipartFile pay_file = request.getFile("pay_file");
		String payId = request.getParameter("payId");
		if(pay_file == null || StringUtils.isEmpty(payId)){
			return new ResultDto("上传数据丢失！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
//		String path = insPreservationPayAPIService.uploadFile(pay_file,"/record/");
		String path = OSSFileUtil.huaweiOBSFileUpload(pay_file,"/record/");
		if(StringUtils.isNotEmpty(path)){
			if(insPreservationPayAPIService.savePayPath(Long.parseLong(payId),path)){
				return new ResultDto("保全缴费数据更新成功！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("保全缴费数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("文件保存失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}


	/**
	 * <b>根据页面勾选条目生成部分账单 </b>
	 * @param isSummaryBill 是否为汇总账单
	 * @param payIds 勾选数据列的id集合
	 * @author ZXF
	 * @create 2024/04/26 0026 11:04
	 * @version
	 * @注意事项 </b>
	 */
	@LoginRequired
	@RequestMapping("/pay/createPartBill")
	public @ResponseBody String createPartBill(String isSummaryBill, String payIds){
		JSONObject json = insPreservationPayAPIService.createPartBill(isSummaryBill,payIds.split(","));
		return json.toJSONString();
	}

	@LoginRequired
	@RequestMapping("/pay/createPartBillByNo")
	public @ResponseBody String createPartBillByNo(String isSummaryBill, String payNos){
		JSONObject json = insPreservationPayAPIService.createPartBillByNo(isSummaryBill,payNos.split(","));
		return json.toJSONString();
	}

	@RequestMapping("/pay/downBillPay")
	public void downBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
		String keyword = req.getParameter("keyword");
		String start_time = req.getParameter("start_time");
		String end_time = req.getParameter("end_time");
		String pay_status = req.getParameter("pay_status");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		insPreservationPayAPIService.downBillPay( Long.parseLong(userdetail.getOid()), pay_status, start_time, et, keyword, resp);

	}

	@RequestMapping("/pay/downChildBillPay")
	public void downChildBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
		String keyword = req.getParameter("keyword");
		String start_time = req.getParameter("start_time");
		String end_time = req.getParameter("end_time");
		String pay_status = req.getParameter("pay_status");
		String parentPayId = req.getParameter("parentPayId");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		insPreservationPayAPIService.downChildBillPay( Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), pay_status, start_time, et, keyword, resp);

	}

	@RequestMapping("/pay/downSettlementPay")
	public void downSettlementPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
		String keyword = req.getParameter("keyword");
		String start_time = req.getParameter("start_time");
		String end_time = req.getParameter("end_time");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		insPreservationPayAPIService.downSettlementPay( Long.parseLong(userdetail.getOid()), start_time, et, keyword, resp);

	}

	@RequestMapping("/pay/downChildSettlementBillPay")
	public void downChildSettlementBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
		String keyword = req.getParameter("keyword");
		String start_time = req.getParameter("start_time");
		String end_time = req.getParameter("end_time");
		String parentPayId = req.getParameter("parentPayId");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		insPreservationPayAPIService.downChildSettlementBillPay( Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), start_time, et, keyword, resp);

	}


	/**
	 * <b> 导出在保人员清单 </b>
	 * @author ZXF
	 * @create 2020/01/19 0019 20:48
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/down_result_set/{oid}")
	public void downResultSet(@PathVariable Long oid, HttpServletResponse resp) {
		insPreservationResultSetAPIService.downResultSet(oid, resp);
	}

	/**
	 * <b> 导出批改人员清单 </b>
	 * @author ZXF
	 * @create 2020/01/19 0019 20:47
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/down_preservation_detail/{preservationId}")
	public void downPreservationDetail(@PathVariable Long preservationId, HttpServletResponse resp) {
		insPreservationDetailAPIService.downPreservationDetail(preservationId, resp);
	}


}
