package com.bcxin.ins.coninsweb.order.controller.export;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.InsProductRuleXWCKAPIService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.*;
import com.xiaoleilu.hutool.thread.ThreadUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.Map;

/**
 * 负责前台海关类投保流程的业务逻辑处理
 * @author zxf
 *
 */
@Controller
@RequestMapping("/insurance/customs")
@SessionAttributes({"favorite","app_com_organizingPath","app_com_businessPath","app_com_taxPath","ins_com_organizingPath","ins_com_businessPath","ins_com_taxPath"
	,"tax_cert","tax_prove","bank_licence","business_license","auth_cert"}) //此处通过session，保存用户填写的保单对象
public class XYX_Policy_Controller extends BaseController {

	@Autowired
	private InsProductAPIService insProductAPIService;
	@Autowired
	private InsProductRuleXWCKAPIService insProductRuleXWCKAPIService;
	@Autowired
	private InsInsuranceSlipAPIService insInsuranceSlipService;
	@Autowired
	private PolicyService policyService;
	@Autowired
	private MyAsyncExecutor myAsyncExecutor;

	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】产品-访问投保页")
	@LoginRequired(methodParamKey={"1#product_id"}, redirectUrl = "insurance/customs/policyInit/{product_id}")
	@RequestMapping("/policyInit/{product_id}")
	public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) throws Exception {
		ModelAndView view = new ModelAndView();
		view.addObject(ConstProp.RECOMMEND_CODE,UserSupportUtil.getRecommendCode());
		orderAllotInit(product_id, view);
		setTokenByApi(view);
		return view;

	}

	private String createOrderAndGetOrderIDByProductID(Long product_id, Long user_id, String recommendCode,String trade_serial_number){
		Map<String, Object> map = policyService.createOrderFormByProductOid(product_id, user_id, recommendCode, trade_serial_number);
		if(map.get(ConstProp.ORDER_ID) != null){
			return (String)map.get(ConstProp.ORDER_ID);
		}
		return "";
	}

	/**
	 * <b>通过订单ID跳转到投保界面 </b>
	 *
	 * @param request
	 * @param order_id
	 * @param status
	 * @param model
	 * @return
	 * @author ZXF
	 * @date 2016年12月21日 下午1:46:44
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"1#order_id"}, redirectUrl = "insurance/customs/policy/{order_id}")
	@RequestMapping("/policy/{order_id}")
	public ModelAndView enterInfo(HttpServletRequest request, @PathVariable Long order_id, SessionStatus status, ModelMap model) {
		ModelAndView view = new ModelAndView();
		orderAllot(order_id, view);
		setTokenByApi(view);
		return view;
	}

	private void orderAllotInit(Long product_id, ModelAndView view) {
		ProductVo pd = insProductAPIService.accordingToInsProductIDToGetInsProductInProductVo(product_id);
		OrderFormVo dto = new OrderFormVo();
		dto.setProduct_oid(pd.getOid());
		dto.setProduct_code(pd.getProduct_code());
		dto.setGross_premium(pd.getPremium_min());
		view.addObject(ConstProp.PD,pd);
		view.addObject(ConstProp.DTO,dto);
		view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
		if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(pd.getProduct_code())){
            //小薇
			view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_mi");
			MicroExportVo vo = new MicroExportVo();
			setDay(vo);
			view.addObject(ConstProp.VO,vo);
			initEnumList(view);
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.XYX_DQCK.equals(pd.getProduct_code())){
			//出口险
            view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_1");
			initEnumList_qy(view);
		}
	}

	private void orderAllot(Long order_id, ModelAndView view) {
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		ProductVo pd = insProductAPIService.accordingToInsProductIDToGetInsProductInProductVo(Long.parseLong(dto.getProduct_oid()));
		view.addObject(ConstProp.PD,pd);
		view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
		if(StringUtils.isEmpty(dto.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(dto.getProduct_code())){
			MicroExportVo vo = policyService.accordingToOrderIDToGetMicroExportVo(order_id);
			//投保人地址
			if(vo.getRoleSubjectList().size()>0&&StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
				view.addObject(ConstProp.REG_CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
			}
			if(vo.getRoleSubjectList().size()>0&&StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
				view.addObject(ConstProp.REG_AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
			}
			view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_mi");
			setDay(vo);
			view.addObject(ConstProp.VO,vo);
			initEnumList(view);
		}else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : ConstProp.XYX_DQCK.equals(dto.getProduct_code())){
			CommonExportVo_1 vo = policyService.accordingToOrderIDToGetCommonExportVo_1(order_id);
			view.addObject(ConstProp.VO,vo);
			//投保人地址
			if(vo.getRoleSubjectList().size()>0&&StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
				view.addObject(ConstProp.REG_CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
			}
			if(vo.getRoleSubjectList().size()>0&&StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
				view.addObject(ConstProp.REG_AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
			}
			view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_1");
			initEnumList_qy(view);
		}
		view.addObject(ConstProp.DTO,dto);
	}

	private void setDay(MicroExportVo vo){
		String tom = DateUtil.getTomorrow();
		String nextOne = ConstProp.BLANK_CHAR;
		try {
			nextOne = DateUtil.dateAdd(1,tom,1);
			nextOne = DateUtil.dateAdd(3,nextOne,-1);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setInception_date(tom);
		vo.setPlanned_end_date(nextOne);
	}

	/**
	 * <b>企业短期出口险投保单向下3页操作到确认投保界面 </b>
	 *
	 * @param reqeust 页码投保单数据
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月28日 下午4:20:11
	 * @注意事项 </b>
	 * http://localhost:8080/insurance/customs/policy/qy_policy/870453817941381120/2
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#order_id", "1#page"}, redirectUrl = "insurance/customs/policy/qy_policy/{order_id}/{page}")
	@RequestMapping("/policy/qy_policy/{order_id}/{page}")
	public ModelAndView qy_policy(@PathVariable Long order_id, @PathVariable int page, HttpServletRequest reqeust) throws Exception{
		ModelAndView view = new ModelAndView();
		try {
			if(page <= 0){
				return view;
			}
			view.addObject(ConstProp.DTO,policyService.accordingToOrderIDToGetPolicyDto(order_id));
			if(page == 1){
				view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_1");
				//第一页内容存储
				CommonExportVo_1 vo = policyService.accordingToOrderIDToGetCommonExportVo_1(order_id);
				view.addObject(ConstProp.VO,vo);
				view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
				//投保人地址
				if(vo.getRoleSubjectList().size()>0&&StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
					view.addObject(ConstProp.REG_CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
				}
				if(vo.getRoleSubjectList().size()>0&&StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
					view.addObject(ConstProp.REG_AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
				}
			}else if(page == 2){
				view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_2");
				//第二页内容存储
				view.addObject(ConstProp.VO,policyService.accordingToOrderIDToGetCommonExportVo_2(order_id));
			}else if(page == 3){
				view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_3");
				//第三页内容存储
				view.addObject(ConstProp.VO,policyService.accordingToOrderIDToGetCommonExportVo_3(order_id));
			}
			initEnumList_qy(view);
		}catch (Exception ex){

		}
		setTokenByApi(view);

		return view;

	}

	/**
	 * <b>小微短期出口险投保界面跳转到确认页面中间的业务 </b>
	 *
	 * @param order_id
	 * @param reqeust
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月28日 下午4:21:44
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#order_id"}, redirectUrl = "insurance/customs/policy/confirmPage/{order_id}")
	@RequestMapping("/policy/confirmPage/{order_id}")
	public ModelAndView confirmPage(@PathVariable Long order_id, HttpServletRequest reqeust) throws Exception{

		try{
			ModelAndView view = new ModelAndView();
			OrderFormVo dto =policyService.accordingToOrderIDToGetPolicyDto(order_id);
			view.addObject(ConstProp.DTO,dto);
			if(StringUtils.isEmpty(dto.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(dto.getProduct_code())){
				view.setViewName("/coninsweb/insurance/customs/policy/policyConfirm_mi");
				MicroExportVo vo = policyService.accordingToOrderIDToGetMicroExportVo(order_id);
				view.addObject(ConstProp.VO,vo);
				view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
				view.addObject(ConstProp.REG_RULE, RegionUtils.getRegionNameByALLCode(vo.getLawsuit_province(),vo.getLawsuit_city(),vo.getLawsuit_area())+vo.getLawsuit_address());
			}else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : ConstProp.XYX_DQCK.equals(dto.getProduct_code())){
				view.setViewName("/coninsweb/insurance/customs/policy/policyConfirm_my");
				CommonExportVo_1 vo1 = policyService.accordingToOrderIDToGetCommonExportVo_1(order_id);
				CommonExportVo_2 vo2 = policyService.accordingToOrderIDToGetCommonExportVo_2(order_id);
				CommonExportVo_3 vo3 = policyService.accordingToOrderIDToGetCommonExportVo_3(order_id);
				view.addObject(ConstProp.VO1,vo1);
				view.addObject(ConstProp.VO2,vo2);
				view.addObject(ConstProp.VO3,vo3);
				view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo1.getRoleSubjectList().get(0).getReg_province(),vo1.getRoleSubjectList().get(0).getReg_city(),vo1.getRoleSubjectList().get(0).getReg_district()));
			}
			setTokenByApi(view);
			return view;
		}catch (Exception ex){
			ex.printStackTrace();
		}
		return null;


	}

	/**
	 * <b>加载小微企业投保界面时带到页面的枚举列 </b>
	 *
	 * @param view
	 * @author ZXF
	 * @date 2016年12月28日 上午10:18:00
	 * @注意事项 </b>
	 * <b>
	 */
	private void initEnumList(ModelAndView view){

		try {
			view.addObject("listComType", SysDictUtils.getDictList("comType"));
			view.addObject("listComNature", SysDictUtils.getDictList("comNature"));
			view.addObject("listIndustry", SysDictUtils.getDictList("industry"));
			view.addObject("listPayLimit", SysDictUtils.getDictList("payLimit"));
			view.addObject("listProRata", SysDictUtils.getDictList("proRata"));
			view.addObject("listAnnualCurrency", SysDictUtils.getDictList("annualCurrency"));
			view.addObject("listDisputes", SysDictUtils.getDictList("disputes"));
		}catch (Exception ex){
			  ex.printStackTrace();
		}

	}

	/**
	 * <b>加载企业短期出口险投保界面时带到页面的枚举列 </b>
	 *
	 * @param view
	 * @author ZXF
	 * @date 2016年12月28日 上午10:18:00
	 * @注意事项 </b>
	 * <b>
	 */
	private void initEnumList_qy(ModelAndView view){
		view.addObject("listType", SysDictUtils.getDictList("organizationType"));
		view.addObject("listCurrency", SysDictUtils.getDictList("currencyRequired"));
		view.addObject("listPaymentTerms", SysDictUtils.getDictList("paymentTerms"));


	}

	/**
	 * <b>企业短期第一页投保单客户填一半暂存，方法 </b>
	 *
	 * @param reqeust
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_ORDER,title ="【请求】产品-订单投保")
	@RequestMapping("/policy/pendingCommonExportVo_1Policy")
	@ResponseBody
	public ResultDto pendingCommonExportVo_1Policy(CommonExportVo_1 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception{
		String recommendCode = reqeust.getParameter(ConstProp.RECOMMEND_CODE);
		return policyService.pendingCommonExportVo_1Policy(vo,recommendCode);
	}

	/**
	 * <b>企业短期第二页投保单客户填一半暂存，方法 </b>
	 *
	 * @param reqeust
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/policy/pendingCommonExportVo_2Policy")
	@ResponseBody
	public ResultDto pendingCommonExportVo_2Policy(CommonExportVo_2 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception{
		return policyService.pendingCommonExportVo_2Policy(vo);
	}

	/**
	 * <b>企业短期第三页投保单客户填一半暂存，方法 </b>
	 *
	 * @param reqeust
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/policy/pendingCommonExportVo_3Policy")
	@ResponseBody
	public ResultDto pendingCommonExportVo_3Policy(CommonExportVo_3 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception{
		return policyService.pendingCommonExportVo_3Policy(vo);
	}

	/**
	 * <b>小微投保单客户填一半暂存，方法 </b>
	 *
	 * @param reqeust
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_ORDER,title ="【请求】产品-订单投保")
	@RequestMapping("/policy/pendingMicroExportPolicy")
	@ResponseBody
	public ResultDto pendingMicroExportPolicy(MicroExportVo vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception{
		String recommendCode = reqeust.getParameter(ConstProp.RECOMMEND_CODE);
		return policyService.pendingMicroExportPolicy(vo, recommendCode);
	}


	/**
	 * <b>修改订单状态</b>
	 *
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("/policy/updateOrderFormStatus")
	@ResponseBody
	public ResultDto updateOrderFormStatus( HttpServletRequest reqeust) throws Exception{
		String order_id = reqeust.getParameter(ConstProp.ORDER_ID);
		String status = reqeust.getParameter("status");
		if(StringUtils.isEmpty(order_id) || StringUtils.isEmpty(status)){
			return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		OrderFormVo vo = new OrderFormVo();
		vo.setOid(String.valueOf(order_id));
		vo.setPolicy_status(status);
		try {
			String orderID =policyService.updateOrderFormStatus(vo);
			if(StringUtils.isNotEmpty(orderID)){
				return new ResultDto("订单录入成功。", ConstProp.CODE_SUCCESS, orderID, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}catch (Exception ex){
			ex.printStackTrace();
		}
		return null;

	}

	@RequestMapping("/policy/requestEPolicy/{product_code}/{oid}")
	@ResponseBody
	public ResultDto requestEPolicy(@PathVariable String product_code, @PathVariable Long oid) throws Exception {
		if(product_code.indexOf(ConstProp.XYX_XWCK)!=-1){
			String path = policyService.HTTP_TPC_XYX_DZBD(oid);
			if(StringUtils.isNotEmpty(path)){
				return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, path, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			return new ResultDto("获取电子保单失败，请联系客服人员", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return new ResultDto("电子保单下载异常，请联系客服人员", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
	}

	/**
	 * <b>业务逻辑处理，保存保单信息
	 * 页面流转：点击保单保存，跳转支付页面 </b>
	 *
	 * @param order_id 保单id
	 * @return
	 * @author ZXF
	 * @date 2016年12月21日 下午1:48:20
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#order_id"}, redirectUrl = "insurance/customs/policy/policyPayment/{order_id}")
	@RequestMapping("/policy/policyPayment/{order_id}")
	public ModelAndView savePolicy(@PathVariable long order_id) {
		try {
			OrderFormVo vo = policyService.accordingToOrderIDToGetPolicyDto(order_id);
			ModelAndView view = new ModelAndView();
			if(vo.getPolicy_status().equals(ConstProp.DIGIT_TWO)){
				//待核保
				view.setViewName("/coninsweb/insurance/customs/transaction/waitOffer");
			}else if(vo.getPolicy_status().equals(ConstProp.DIGIT_SIX)){
				//核保通过
				view.setViewName("/coninsweb/insurance/customs/transaction/passUnderwriting");
			}else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIFTEEN)){
				//拒保
				view.setViewName("/coninsweb/insurance/customs/transaction/declinature");
			}else if(vo.getPolicy_status().equals(ConstProp.DIGIT_THREE)){
				//已报价
				UnderwriteVo underwriteVo = policyService.accordingToOrderIDGainInsUnderwrite(order_id);
				view.setViewName("/coninsweb/insurance/customs/transaction/offer");
				view.addObject("underwriteVo", underwriteVo);
			}else if(vo.getPolicy_status().equals("16")){
				//待支付
				//TODO 最低保险费,保费缴纳方式 值未确定
				AdviceNoteVo anVo = policyService.accordingToOrderIDToGetAdviceNoteVo(order_id);
				String path_sign = policyService.accordingToOrderIDGainPathSign(order_id);
				view.setViewName("/coninsweb/insurance/customs/transaction/paymentNotice");
				view.addObject(ConstProp.PATH_SIGN, path_sign);
				view.addObject(ConstProp.ANVO, anVo);
			}else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIVE)){
				//待承保
				if(StringUtils.isEmpty(vo.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(vo.getProduct_code())){
					ThreadUtil.excAsync(()->{
						policyService.yxTimer(order_id);
					},false);
					view.setViewName("/coninsweb/insurance/customs/transaction/finishPay_xw");
				}else{
					view.setViewName("/coninsweb/insurance/customs/transaction/finishPay");
				}
			}
			view.addObject(ConstProp.NOWTIME,new Date());
			view.addObject(ConstProp.DTO,vo);
			setTokenByApi(view);
			return view;
		}catch (Exception ex){
		   ex.printStackTrace();
		}
		return null;
	}

	/**
	 * <b>完成每笔支付跳转支付完成页面 </b>
	 *
	 * @param product_id
	 * @param city_code
	 * @return
	 * @author zxf
	 * @date 2016年12月21日 下午1:51:30
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/policy/getRuleXWCKVo/{product_id}/{city_code}")
	@ResponseBody
	public String getRuleXWCKVo(@PathVariable String product_id,@PathVariable String city_code){
		RuleXWCKVo vo = insProductRuleXWCKAPIService.getRuleXWCKVoByProductIDAndCity(product_id, city_code);
		if(vo != null){
			//转String类型的map
			try {
				return JSONObject.toJSONString(vo);
			} catch (Exception e) {
				return ConstProp.BLANK_CHAR;
			}
		}
		return ConstProp.BLANK_CHAR;
	}
		
		/**
		 * <b>待支付界面提交上传信息及订单号，标识 </b> 
		 * 
		 * @param request
		 * @return
		 * @author ZXF 
		 * @date 2017年1月17日 下午4:22:10
		 * @注意事项 </b>
		 * <b>
		 */
		@RequestMapping("/policy/uploadPayMentFile")
		@ResponseBody
		public ResultDto uploadPayMentFile(HttpServletRequest request){
			String doPayments = request.getParameter("doPayments");
			String payAmount = request.getParameter("payAmount");
			String policyOid = request.getParameter("policyOid");
			String paymentPath = request.getParameter("payment_path");
			if(StringUtils.isEmpty(doPayments) || StringUtils.isEmpty(payAmount) || StringUtils.isEmpty(policyOid)|| StringUtils.isEmpty(paymentPath)){
				return new ResultDto("数据丢失，操作失败！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				String orderID = policyService.uploadPayMentFileToTranction(paymentPath, policyOid, doPayments, payAmount);
				if(StringUtils.isNotEmpty(orderID)){
					//完成上传后异步发送邮件
					new Thread(()->{
						policyService.JFPZ_SendEmail(Long.parseLong(policyOid),paymentPath);
					}).start();
					return new ResultDto("上传成功！", ConstProp.CODE_SUCCESS, "true", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}else{
					return new ResultDto("数据存储失败！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}
		}
		
		/**
		 * <b>完成每笔支付跳转支付完成页面 </b> 
		 * 
		 * @param oid
		 * @return
		 * @author zxf 
		 * @date 2016年12月21日 下午1:51:30
		 * @注意事项 </b>
		 * <b>
		 */
		@LoginRequired(methodParamKey={"0#oid"}, redirectUrl = "insurance/customs/policy/finishPay/{oid}")
		@RequestMapping("/policy/finishPay/{oid}")
		public ModelAndView finishPay(@PathVariable long oid){
			ModelAndView view = new ModelAndView("/coninsweb/insurance/customs/transaction/finishPay");
			OrderFormVo vo = policyService.accordingToOrderIDToGetPolicyDto(oid);
			view.addObject(ConstProp.DTO,vo);
			setTokenByApi(view);
			return view;
		}
		
		@RequestMapping("/sessionInfo")
		public ResultDto sessionInfo(HttpServletRequest reqeust, ModelMap model) {
			String name = reqeust.getParameter("name");
			String base64 = reqeust.getParameter("base64");
			model.addAttribute(name, base64);
			return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}

	}
