package com.bcxin.ins.coninsweb.order.controller.api.gyx.changan;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.third.gyx.changan.GYX_CARequestService;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DictConst;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Map;

/**
 * <b> 长安-个人意外险接口Controller控制器，用于回调 </b>
 * @author ZXF
 * @create 2021/03/01 0001 10:03
 * @version
 * @注意事项 </b>
 */
@Controller
public class GYX_CA_API_Controller extends BaseController {


	@Autowired
	private PolicyService policyService;
	@Autowired
	private InsPreservationRecordAPIService insPreservationRecordAPIService;
	@Autowired
	private GYX_CARequestService gYX_CARequestService;

	/**
	 * 长安个人意外险回调地址（在用）
	 * //		支付成功后渠道平台会使用http + post方式调用该链接，并且支付相关信息通过URL参数形式返回
	 * //		订单号：orderNo
	 * //		支付方式：payType
	 * //		刷卡流水号：cardSerialNo
	 * //		支付时间：payTime
	 * //		请求方：parterId
	 * //		订单类型：orderType
	 * //		校验码：passWord
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/CA-API/GYX/Policy-Opinion")
	@ResponseBody
	public Result PolicyOpinion() {
		logger.info("长安个人意外险承保完成后页面展示-star");
		String orderNo = getRequest().getParameter("orderNo");
		String payType = getRequest().getParameter("payType");
		String tradeNo = getRequest().getParameter("tradeNo");
		String payTime = getRequest().getParameter("payTime");
		String parterId = getRequest().getParameter("parterId");
		String orderType = getRequest().getParameter("orderType");
		String passWord = getRequest().getParameter("passWord");
		Map<String,String> map = Maps.newHashMap();
		map.put("payType",payType);
		map.put("tradeNo",tradeNo);
		map.put("payTime",payTime);
		map.put("orderNo",orderNo);
		map.put("parterId",parterId);
		map.put("orderType",orderType);
		map.put("passWord",passWord);
		logger.info("====长安个人意外险,param:"+map.toString());
		policyService.CA_GZZRX_SAVE_PAY_MSG(map);
		logger.info("长安个人意外险承保完成后页面展示-ca-pay-service：orderNo:"+orderNo);
		OrderFormVo dto = policyService.getPolicyDtoByRcptNo(orderNo);
		if(DictConst.ORDER_STATUS_YCB.equals(dto.getPolicy_status())){
			return Result.success("数据接收成功");
		}
		return Result.fail("数据处理失败");
	}

	@RequestMapping(value = "/CA-API/GYX/BU-Policy-Opinion")
	@ResponseBody
	public Result BUPolicyOpinion() {
		logger.info("长安个人意外险承保完成后页面展示-star");
		String orderNo = getRequest().getParameter("orderNo");
		String payType = getRequest().getParameter("payType");
		String tradeNo = getRequest().getParameter("tradeNo");
		String payTime = getRequest().getParameter("payTime");
		String parterId = getRequest().getParameter("parterId");
		String orderType = getRequest().getParameter("orderType");
		String passWord = getRequest().getParameter("passWord");
		String policyNo = getRequest().getParameter("policyNo");
		String eUrl = getRequest().getParameter("eUrl");
		Map<String,String> map = Maps.newHashMap();
		map.put("payType",payType);
		map.put("tradeNo",tradeNo);
		map.put("payTime",payTime);
		map.put("orderNo",orderNo);
		map.put("parterId",parterId);
		map.put("orderType",orderType);
		map.put("passWord",passWord);
		map.put("policyNo",policyNo);
		map.put("eUrl",eUrl);
		logger.info("====长安个人意外险,param:"+map.toString());
		policyService.BU_CA_GZZRX_SAVE_PAY_MSG(map);
		logger.info("长安个人意外险承保完成后页面展示-ca-pay-service：orderNo:"+orderNo);
		OrderFormVo dto = policyService.getPolicyDtoByRcptNo(orderNo);
		if(DictConst.ORDER_STATUS_YCB.equals(dto.getPolicy_status())){
			return Result.success("数据接收成功");
		}
		return Result.fail("数据处理失败");
	}

	/**
	 * <b> 申请电子发票 </b>
	 * @author ZXF
	 * @create 2019/11/01 0001 10:38
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/CA-API/GYX/PRINT_INVOICE/{oid}")
	@ResponseBody
	public ResultDto printInvoice(@PathVariable long oid) throws Exception {
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(oid);
		if(dto == null || !DictConst.ORDER_STATUS_YCB.equals(dto.getPolicy_status())){
			return new ResultDto("无法获取发票！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		String result = gYX_CARequestService.request_ca_dzfp(oid, TransTypeEnum.DZFP.getValue(),"","","");
		if(StringUtils.isEmpty(result)){
			return new ResultDto("获取电子发票接口异常！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		String[] strs = result.split(ConstProp.POUND_SIGN);
		if(!ConstProp.CODE_SUCCESS.equals(strs[0])){
			return new ResultDto(strs[1], ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(StringUtils.isEmpty(strs[1])){
			return new ResultDto("（APP-GYX-009）数据丢失！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(StringUtils.isNotEmpty(dto.getExternal_reference())){
			policyService.updateUrlByExternalreference(strs[1],dto.getExternal_reference());
			return new ResultDto(strs[1], ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("未获取到保单号！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	public static void main(String[] args) {
		String xml = "ResultDesc=成功" +
				"&UnderwriteOpinion=通过" +
				"&ResultFlag=1" +
				"&EndorNo=41516202143510000002501" +
				"&PolicyNo=615162021435100000025" +
				"&CertiNo=315162021Y43000000007" +
				"&UnderwriteFlag=1" +
				"&RequestType=EdorseNotice" +
				"&Timestamp=20210817175118";

//		String[] arr = xml.split("&");
//		String[] mArr;
//		Map<String,String> reqMap = Maps.newHashMap();
//		for(int i=0;i<arr.length;i++){
//			mArr=arr[i].split("=");
//			if(mArr.length==1){
//				reqMap.put(mArr[0],"");
//			}else{
//				reqMap.put(mArr[0],mArr[1]);
//			}
//
//		}
//		System.out.println(reqMap);
//		String url = "http://www.bailianbao.cn/CA-API/GZZRX/Endorsement-Opinion";
//		Map map = Maps.newHashMap();
//		map.put("xml",xml);
//		String ret = HttpUtil.post(url,xml);
//		System.out.println(ret);
	}

	/**
	 * <b> 返回结果处理 </b>
	 * @ChannelTradeSerialNo 渠道交易流水号（一次交易标识）
	 * @ResponseCode 错误编码：0失败，1成功
	 * @ErrorMessage 错误信息
	 * @proposalNo 渠道交易流水号（一次交易标识）
	 * @type 回调类型：0核保结果回调，1保单结果回调，2批单结果回调
	 *
	 * @author ZXF
	 * @create 2021/03/01 0001 17:25
	 * @version
	 * @注意事项 </b>
	 */
	private static String xmlResult(String ChannelTradeSerialNo, String ResponseCode, String ErrorMessage, int type) {
		String xmlResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
				xmlResult += "<HEAD>";
				if(type == 0) {
					xmlResult += "<ChannelTradeSerialNo>" + ChannelTradeSerialNo + "</ChannelTradeSerialNo>";
				}
				if(type == 1) {
					xmlResult += "<proposalNo>" + ChannelTradeSerialNo + "</proposalNo>";
				}
				xmlResult += "<ResponseCode>"+ResponseCode+"</ResponseCode>";
				xmlResult += "<ErrorMessage>"+ErrorMessage+"</ErrorMessage>";
				xmlResult += "</HEAD>";
		return xmlResult;
	}

	/**
	 * <b> 批单确认返回结果处理 </b>
	 * @ChannelTradeSerialNo 渠道交易流水号（一次交易标识）
	 * @ResponseCode 错误编码：0失败，1成功
	 * @ErrorMessage 错误信息
	 *
	 * @author ZXF
	 * @create 2021/03/01 0001 17:25
	 * @version
	 * @注意事项 </b>
	 */
	private static String xmlPDQRResult(String ResponseCode, String ErrorMessage) {
		String xmlResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
				xmlResult += "<response>";
				xmlResult += "<responseHead>";
				xmlResult += "<appCode>"+ResponseCode+"</ResponseCode>";
				xmlResult += "<appMessage>"+ErrorMessage+"</ErrorMessage>";
				xmlResult += "</responseHead>";
				xmlResult += "</response>";
		return xmlResult;
	}

	/**
	 * <b> 线下支付回调接收结果 </b>
	 * @ResponseCode 错误编码：0失败，1成功
	 * @ErrorMessage 错误信息
	 *
	 * @author ZXF
	 * @create 2021/03/01 0001 17:25
	 * @version
	 * @注意事项 </b>
	 */
	private static String xmlXXZFResult(String ResponseCode, String ErrorMessage, String sign) {
		String xmlResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
		xmlResult += "<Root>";
		xmlResult += "<ResponseHead>";
		xmlResult += "<Sign>"+sign+"</Sign>";
		xmlResult += "</ResponseHead>";
		xmlResult += "<ResponseBody>";
		xmlResult += "<ResultFlag>"+ResponseCode+"</ResultFlag>";
		xmlResult += "<Message>"+ErrorMessage+"</Message>";
		xmlResult += "<TimeStamp>"+System.currentTimeMillis()+"</TimeStamp>";
		xmlResult += "</ResponseBody>";
		xmlResult += "</Root>";
		return xmlResult;
	}

}

