/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50523
Source Host           : localhost:3306
Source Database       : bcx_discern

Target Server Type    : MYSQL
Target Server Version : 50523
File Encoding         : 65001

Date: 2021-01-28 16:35:00
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for app_version
-- ----------------------------
DROP TABLE IF EXISTS `app_version`;
CREATE TABLE `app_version` (
    `oid` bigint(20) NOT NULL,
    `createOn` datetime DEFAULT NULL,
    `updateOn` datetime DEFAULT NULL,
    `androidVerName` varchar(30) DEFAULT NULL COMMENT 'Android端版本号，版本号示例1.0.1，如果修复bug下一版为1.0.2，如果小版本增加功能下一版为1.1.1，如果大版本改动下一版为2.1.1',
    `iOSVerName` varchar(30) DEFAULT NULL COMMENT 'IOS端版本号，IOS版本号同上',
    `apkSize` varchar(255) DEFAULT NULL COMMENT 'App更新提示，￥为换行分隔符',
    `isWgt` varchar(10) DEFAULT NULL COMMENT '0：代表整包更新，1：代表热更新，注意：如果升级了HX版本就需要使用整包更新，热更新无效，其他时候如果代码有少量改的可以使用热更新；2代表强制更新，页面上只出现更新按钮，没有取消按钮',
    `appWgtURL` varchar(200) DEFAULT NULL COMMENT '如果IsWgt为1时，会通过此地址下载热更新包',
    `apkWebURL` varchar(200) DEFAULT NULL COMMENT 'Android端App包下载地址，如果IsWgt为0时且当AndroidVerName大于当前版本时，需要使用此地址下载安装包执行更新',
    `iOSLinkURL` varchar(200) DEFAULT NULL COMMENT 'IOS端AppStore唤起地址，如果IsWgt为0时且当IOSVerName大于当前版本时，自动吊起应用的AppStore页面进行更新',
    `version` varchar(30) DEFAULT NULL COMMENT '热更新版本号',
    PRIMARY KEY (`oid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for com_video_room
-- ----------------------------
DROP TABLE IF EXISTS `com_video_room`;
CREATE TABLE `com_video_room` (
    `comVideoRoomId` bigint(20) NOT NULL COMMENT '记录ID',
    `comId` varchar(32) NOT NULL COMMENT '企业ID',
    `startTime` datetime NOT NULL COMMENT '视频调度开始时间',
    `endTime` datetime DEFAULT NULL COMMENT '视频调度结束时间（指最后一个人离开房间的时间）',
    `roomNo` varchar(20) DEFAULT NULL COMMENT '房间号',
    `yardmanName` varchar(20) DEFAULT NULL COMMENT '调度者名称',
    `yardmanTaskName` varchar(100) DEFAULT NULL COMMENT '调度任务名称',
    `yardmanTaskExplain` varchar(200) DEFAULT NULL COMMENT '调度任务说明',
    `createOn` datetime DEFAULT NULL,
    `updateOn` datetime DEFAULT NULL,
    `yardmanType` varchar(10) DEFAULT '1' COMMENT '调度类型',
    PRIMARY KEY (`comVideoRoomId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='视频调度记录表';

-- ----------------------------
-- Table structure for `hibernate_unique_key`
-- ----------------------------
DROP TABLE IF EXISTS `hibernate_unique_key`;
CREATE TABLE `hibernate_unique_key` (
  `next_hi` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of hibernate_unique_key
-- ----------------------------
INSERT INTO `hibernate_unique_key` VALUES ('57');

-- ----------------------------
-- Table structure for im_roammsg_temp
-- ----------------------------
DROP TABLE IF EXISTS `im_roammsg_temp`;
CREATE TABLE `im_roammsg_temp` (
    `oid` bigint(20) NOT NULL,
    `fromAccount` varchar(255) DEFAULT NULL,
    `toAccount` varchar(255) DEFAULT NULL,
    `textMsg` text,
    `content` text,
    `pcNo` int(20) DEFAULT NULL,
    PRIMARY KEY (`oid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for log_businessrequest
-- ----------------------------
DROP TABLE IF EXISTS `log_businessrequest`;
CREATE TABLE `log_businessrequest` (
    `oid` bigint(20) NOT NULL,
    `createOn` datetime DEFAULT NULL,
    `updateOn` datetime DEFAULT NULL,
    `businessType` varchar(255) DEFAULT NULL,
    `requestStatus` varchar(255) DEFAULT NULL,
    `requestMessage` text,
    `responseMessage` text,
    PRIMARY KEY (`oid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for ly_trajectory
-- ----------------------------
DROP TABLE IF EXISTS `ly_trajectory`;
CREATE TABLE `ly_trajectory` (
    `lyTrajectoryId` bigint(20) NOT NULL COMMENT '配置ID',
    `tKey` varchar(100) NOT NULL COMMENT '猎鹰应用key',
    `name` varchar(100) DEFAULT NULL COMMENT 'service的name',
    `serviceId` varchar(100) NOT NULL COMMENT '应用key下属sid',
    `province` varchar(30) DEFAULT NULL COMMENT '省编码',
    `maxTerminalNum` int(8) DEFAULT NULL COMMENT '最大终端数',
    `isFull` int(4) DEFAULT NULL COMMENT '终端是否已满（0/1）',
    `seq` int(4) DEFAULT NULL COMMENT '顺序',
    `createOn` datetime DEFAULT NULL,
    `updateOn` datetime DEFAULT NULL COMMENT '正常标识为满才有这个时间',
    PRIMARY KEY (`lyTrajectoryId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='猎鹰轨迹区域配置表';

-- ----------------------------
-- Table structure for ly_trajectory_terminal
-- ----------------------------
DROP TABLE IF EXISTS `ly_trajectory_terminal`;
CREATE TABLE `ly_trajectory_terminal` (
    `lyTrajectoryTerminalId` bigint(20) NOT NULL COMMENT 'ID',
    `lyTrajectoryId` bigint(20) NOT NULL COMMENT '配置ID',
    `userid` varchar(100) NOT NULL COMMENT '创建终端的用户id',
    `tid` varchar(100) NOT NULL COMMENT '终端id',
    `createOn` datetime DEFAULT NULL,
    PRIMARY KEY (`lyTrajectoryTerminalId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='猎鹰轨迹终端关系表';

-- ----------------------------
-- Table structure for per_video_room
-- ----------------------------
DROP TABLE IF EXISTS `per_video_room`;
CREATE TABLE `per_video_room` (
    `perVideoRoomId` bigint(20) NOT NULL COMMENT '邀请ID',
    `comVideoRoomId` bigint(20) NOT NULL COMMENT '记录ID',
    `cid` varchar(100) DEFAULT NULL COMMENT '个推设备ID',
    `useid` varchar(100) DEFAULT NULL COMMENT '接收人标识（一般为人员id）',
    `attendExpoStatus` varchar(10) DEFAULT '9' COMMENT '参会状态：0.拒绝；1.接受；2.录制；9.未响应 ，默认（未响应）',
    `startTime` datetime DEFAULT NULL COMMENT '视频开始录制时间',
    `endTime` datetime DEFAULT NULL COMMENT '视频结束录制时间',
    `streamId` varchar(200) DEFAULT NULL COMMENT '视频流ID（腾讯）',
    `fileId` varchar(200) DEFAULT NULL COMMENT '视频文件ID（腾讯）',
    `videoPath` varchar(200) DEFAULT NULL COMMENT '视频地址',
    `isSponsor` varchar(10) DEFAULT '0' COMMENT '是否是发起人',
    `createOn` datetime DEFAULT NULL,
    `updateOn` datetime DEFAULT NULL,
    `personId` varchar(200) DEFAULT NULL COMMENT '用户id',
    `domainId` varchar(200) DEFAULT NULL COMMENT '企业id',
    PRIMARY KEY (`perVideoRoomId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='视频调度记录表';

-- ----------------------------
-- Table structure for `sys_config`
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config` (
  `oid` bigint(20) NOT NULL,
  `createOn` datetime DEFAULT NULL,
  `updateOn` datetime DEFAULT NULL,
  `sysKey` varchar(255) DEFAULT NULL,
  `sysValue` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Records of sys_config
-- ----------------------------
INSERT INTO `sys_config` VALUES ('1', '2020-10-20 11:03:11', '2020-10-20 11:03:16', 'BAIDU_FACE_THAN_VPT', '80', '百度人脸比对阈值');
INSERT INTO `sys_config` VALUES ('2', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'BAIDU_FACE_MATCH_URL', 'https://aip.baidubce.com/rest/2.0/face/v3/match', '百度人像比对地址');
INSERT INTO `sys_config` VALUES ('3', '2020-12-03 20:39:38', '2020-12-03 20:39:40', 'BAIDU_FACE_ACCOUNT', '85DdDN1vZ3LOmcB5i30cLFaI,jSL2BSZbj5g1lDrSD9GZT6GagHLGwbAc;aMHCMSx9OWnTbTjjzeAxk6Tm,xF7AySBlI0cOgQLN44oLWClmHxCDnEVP', '百度人像比对账号');
INSERT INTO `sys_config` VALUES ('4', '2021-01-06 20:39:38', '2021-01-06 20:39:40', 'BAIDU_ORC_ACCOUNT', 'ytjZgnIlDwUW8VhPxD3MrFjj,FcwWpiPsB5capVZSFtBH5ATd3UKaO906', '百度身份证识别应用KEY');
INSERT INTO `sys_config` VALUES ('5', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'BAIDU_ACCESS_TOKEN', 'https://aip.baidubce.com/oauth/2.0/token', '百度登录accessToken');
INSERT INTO `sys_config` VALUES ('6', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'BAIDU_GRANT_TYPE', 'client_credentials', '百度客户端凭证标识');
INSERT INTO `sys_config` VALUES ('7', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'BAIDU_IDCARD_AI_URL', 'https://aip.baidubce.com/rest/2.0/ocr/v1/idcard', '百度身份证正反面比对地址');
INSERT INTO `sys_config` VALUES ('8', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'JWT_SECRET', 'sdoDFyzfieqMrisd4H5o5t9weOl6GmSr', '对接鉴权秘钥');
INSERT INTO `sys_config` VALUES ('9', '2019-01-02 11:06:17', '2019-01-02 11:06:18', 'TENCENT_SDKAPPID', '1400526063', '腾讯云SDKAPPID');
INSERT INTO `sys_config` VALUES ('10', '2019-01-02 11:06:17', '2019-01-02 11:06:18', 'TENCENT_LIBPATH', '/data/upload/saas/tls/tls_sig_api/src/jnisigcheck_mt_x64.so', '腾讯云动态库的地址');
INSERT INTO `sys_config` VALUES ('11', '2019-01-02 11:06:17', '2019-01-02 11:06:18', 'TENCENT_EC_KEY', '2a804fa3841a60fbeb1470b6d19f044bbbb0e8fd6a578210854c4553089fc981', '腾讯云私钥地址-- 旧：/data/upload/saas/tls/tls_sig_api/src/ec_key.pem');
INSERT INTO `sys_config` VALUES ('12', '2019-01-02 11:06:17', '2019-01-02 11:06:18', 'TENCENT_PUBLIC_KEY', '/data/upload/saas/tls/tls_sig_api/src/public.pem', '腾讯云公钥地址');
INSERT INTO `sys_config` VALUES ('13', '2019-01-02 13:32:41', '2019-01-02 13:32:38', 'TENCENT_IM_URL', 'https://console.tim.qq.com', '腾讯云服务器地址');
INSERT INTO `sys_config` VALUES ('14', '2019-01-02 13:32:41', '2019-01-02 13:32:38', 'TENCENT_ADMIN', 'administrator', '腾讯云管理员账号');
INSERT INTO `sys_config` VALUES ('15', '2019-09-19 11:06:17', '2019-09-19 11:06:18', 'TENCENT_SECRETID', 'AKID1rRjlW0C8nBI9j23nGSO3ez3qOggPq2x', '腾讯云secretId');
INSERT INTO `sys_config` VALUES ('16', '2019-09-19 11:06:17', '2019-09-19 11:06:18', 'TENCENT_SECRETKEY', 'g5E5fy2pLaXFfogIdhU1IHzPZT7UcS1K', '腾讯云secretKey');
INSERT INTO `sys_config` VALUES ('17', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'BAIDU_GET_PHOTO_IMAGE_INFO', 'https://aip.baidubce.com/rest/2.0/image-classify/v1/body_seg_photo', '获取头像照片信息');
INSERT INTO `sys_config` VALUES ('18', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'BAIDU_GET_HAED_IMAGE_EFFECT', 'https://aip.baidubce.com/rest/2.0/image-classify/v1/body_seg', '生成分割后的人像前景抠图');
INSERT INTO `sys_config` VALUES ('19', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'HUAWEI_OSS_SERVERADDRESSS', 'oss-cn-beijing.aliyuncs.com', '华为obs服务地址');
INSERT INTO `sys_config` VALUES ('20', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'HUAWEI_OSS_SERVERADDRESSS_INTRANET', 'oss-cn-beijing-internal.aliyuncs.com', '华为obs服务地址');
INSERT INTO `sys_config` VALUES ('21', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'HUAWEI_OSS_ACCESSID', 'KWT3e5KD4At6hqmR', '华为ACCESSID');
INSERT INTO `sys_config` VALUES ('22', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'HUAWEI_OSS_ACCESSKEY', 'XGtu3oy2WgR6myRh7Yi6uSjXV5cjoo', '华为ACCESSKEY');
INSERT INTO `sys_config` VALUES ('23', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'HUAWEI_OSS_BUCKETNAME_TEST', 'bcxin-saas-test', '华为obs环境名测试');
INSERT INTO `sys_config` VALUES ('24', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'HUAWEI_OSS_BUCKETNAME_PROD', 'bcxin-saas-prod', '华为obs环境名生产');
INSERT INTO `sys_config` VALUES ('25', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'ENVI_PROD', 'ENVI_PROD', '公共服务标识（IDENTIFY-PROD）');
INSERT INTO `sys_config` VALUES ('26', '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'SYS_PIC_PATH', '/data/upload/identify/', '系统全局图片操作系统保存的路径');
INSERT INTO `sys_config` VALUES ('27', '2021-01-06 20:39:38', '2021-01-06 20:39:40', 'BAIDU_KT_ACCOUNT', 'TYsrT8LWUwc741Ie1CHplej5,jBEKfyd6uaIn9sZkyywGlbzreEyIWr2l', '百度头像前景抠图应用KEY');
INSERT INTO `sys_config` VALUES ('28', '2020-12-03 20:39:38', '2020-12-03 20:39:40', 'BAIDU_FACE_ACCOUNT_UNIAPP', 'aMHCMSx9OWnTbTjjzeAxk6Tm,xF7AySBlI0cOgQLN44oLWClmHxCDnEVP', '百度人像比对账号(湖南渠道)');
INSERT INTO `sys_config` VALUES ('29', '2021-05-13 11:03:11', '2021-05-13 11:03:16', 'GETUI_APP_ID', 'vnWSA0YJjc8EZM41aXGb2A', '个推appid');
INSERT INTO `sys_config` VALUES ('30', '2021-05-13 11:03:11', '2021-05-13 11:03:16', 'GETUI_APP_KEY', 'Q4Aah9Ztvk8OtKTzGqi5i1', '个推appkey');
INSERT INTO `sys_config` VALUES ('31', '2021-05-13 11:03:11', '2021-05-13 11:03:16', 'GETUI_APP_SECRET', 'tGYyd345bu9XX8OHTejVE5', '个推appsecret');
INSERT INTO `sys_config` VALUES ('32', '2021-05-13 11:03:11', '2021-05-13 11:03:16', 'GETUI_MASTER_SECRET', 'hOlaW7vkUj8gyboOMw88G8', '个推appmaster_secret');
INSERT INTO `sys_config` VALUES ('36', '2021-08-06 11:03:11', '2021-08-06 11:03:16', 'DEFAULT_UPLOAD_LINUX', '/data/upload/identify/temp/', '文件存储地址');
INSERT INTO `sys_config` VALUES ('37', '2021-08-06 11:03:11', '2021-08-06 11:03:16', 'DEFAULT_FFMPEG_LINUX', '/usr/local/bin/ffmpeg', 'mpeg转码编译器');
