# @turf/shortest-path

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## shortestPath

Returns the shortest [path][1] from [start][2] to [end][2] without colliding with
any [Feature][3] in [ obstacles][4]

**Parameters**

-   `start` **[Coord][5]** point
-   `end` **[Coord][5]** point
-   `options` **[Object][6]** optional parameters (optional, default `{}`)
    -   `options.obstacles` **([Geometry][7] \| [Feature][8] \| [FeatureCollection][9]&lt;[Polygon][10]>)?** areas which path cannot travel
    -   `options.minDistance` **[number][11]?** minimum distance between shortest path and obstacles
    -   `options.units` **[string][12]** unit in which resolution & minimum distance will be expressed in; it can be degrees, radians, miles, kilometers, ... (optional, default `'kilometers'`)
    -   `options.resolution` **[number][11]** distance between matrix points on which the path will be calculated (optional, default `100`)

**Examples**

```javascript
var start = [-5, -6];
var end = [9, -6];
var options = {
  obstacles: turf.polygon([[[0, -7], [5, -7], [5, -3], [0, -3], [0, -7]]])
};

var path = turf.shortestPath(start, end, options);

//addToMap
var addToMap = [start, end, options.obstacles, path];
```

Returns **[Feature][8]&lt;[LineString][13]>** shortest path between start and end

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.4

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[3]: https://tools.ietf.org/html/rfc7946#section-3.2

[4]: FeatureCollection<Polygon>

[5]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[7]: https://tools.ietf.org/html/rfc7946#section-3.1

[8]: https://tools.ietf.org/html/rfc7946#section-3.2

[9]: https://tools.ietf.org/html/rfc7946#section-3.3

[10]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[11]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[12]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[13]: https://tools.ietf.org/html/rfc7946#section-3.1.4

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/shortest-path
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
