# @turf/center

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## center

Takes a [Feature][1] or [FeatureCollection][2] and returns the absolute center point of all features.

**Parameters**

-   `geojson` **[GeoJSON][3]** GeoJSON to be centered
-   `options` **[Object][4]** Optional parameters (optional, default `{}`)
    -   `options.properties` **[Object][4]** Translate GeoJSON Properties to Point (optional, default `{}`)
    -   `options.bbox` **[Object][4]** Translate GeoJSON BBox to Point (optional, default `{}`)
    -   `options.id` **[Object][4]** Translate GeoJSON Id to Point (optional, default `{}`)

**Examples**

```javascript
var features = turf.points([
  [-97.522259, 35.4691],
  [-97.502754, 35.463455],
  [-97.508269, 35.463245]
]);

var center = turf.center(features);

//addToMap
var addToMap = [features, center]
center.properties['marker-size'] = 'large';
center.properties['marker-color'] = '#000';
```

Returns **[Feature][5]&lt;[Point][6]>** a Point feature at the absolute center point of all input features

[1]: https://tools.ietf.org/html/rfc7946#section-3.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.3

[3]: https://tools.ietf.org/html/rfc7946#section-3

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[5]: https://tools.ietf.org/html/rfc7946#section-3.2

[6]: https://tools.ietf.org/html/rfc7946#section-3.1.2

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/center
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
