// h5 监听 app， 截取对应信息， 发送对应信息
// JsBridge://%method%方法名%method%?%params%参数%params%
export class JsBridge {
    constructor(callbacks) {
      this.init(callbacks);
    }
    init(callbacks) {
      // 初始化注入内置方法
      callbacks.forEach((cbItem) => {
        this.registeMethod(`%${cbItem.name}%`, cbItem.cb);
      });
    }
    // 注入方法 // 这里会全局污染 定义变量要慎重 就加%方法% 特定标识   接收在回调触发
    registeMethod(methodName, callback) {
      window[methodName] = callback;
    }
    // 设置协议的执行器
    postToApp(method, params) {
      console.log("postToApp");
      let result = `JsBridge://%method%${method}%method%%params%%param%time=${new Date().getTime()}%param%`;
      if (params) {
        Object.keys(params).forEach((key, index) => {
          result += `%${key}%=${params[key]}%param%`;
        });
      }
      result += "%params%";
      document.title = result;
      console.log("postToApp", result);
      return result;
    }
  }
  