import Vue from 'vue'
import Router from 'vue-router'
import Main from './views/Main.vue'
import Launch from './views/Launch.vue'
import Menu from "./views/Menu.vue"
import Opener from './views/Opener.vue'
import report from './components/report.vue'
import chart from './components/chart.vue'
import authority from './components/authority.vue'
import qrcodeCallback from './views/qrcode_callback.vue'
import mainCarboncopy from './components/main_carboncopy.vue'
// import config from './../public/js/obpm.config.js'

// const originalPush = Router.prototype.push
// Router.prototype.push = function push(location) {
//    return originalPush.call(this, location).catch(err => err)
// }

Vue.use(Router)
const statiContextPath = obpmConfig.statiContextPath;
const signonContextPath = obpmConfig.signonContextPath;
const router = new Router({
  routes: [
    {
      path: '/',
      name: 'Menu',
      component: Menu, 
      meta: {
        keepAlive: true,//此组件需要被缓存
        title: "....",
      }
    },
    {
      path: '/board',//看板
      name: 'Main',
      component: Main,
      meta: {
        keepAlive: true,//此组件需要被缓存
        title: "....",
      }
    },
    // {
    //   path: '/',
    //   name: 'main',
    //   component: Main,
    //   redirect:'/menu',
    //   meta: {
    //     keepAlive: true,//此组件需要被缓存
    //     title: "....",
    //   }
    // },
    {
      path: '/authority',
      name: 'authority',
      component: authority
    },

    {
      path: '/report',
      name: 'report',
      component: report
    },
    {
      path: '/chart',
      name: 'chart',
      component: chart
    },
    {
      path: '/mainCarboncopy',
      name: 'mainCarboncopy',
      component: mainCarboncopy
    },
    {
      path: '/favoritesfunc',
      name: 'favoritesfunc',
      component: () => import(/* webpackChunkName: "about" */ './views/FavoritesFunc.vue')
    },
    {
      path: '/flowcenter',
      name: 'flowcenter',
      component: () => import(/* webpackChunkName: "about" */ './views/FlowCenter.vue')
    },
    {
      path: '/form/:formid/doc/:docid',
      name: 'form',
      component: () => import(/* webpackChunkName: "about" */ './views/Form.vue'),

    },
    {
      path: '/form',//测试用，打开一个固定表单--Jarod
      name: 'form2',
      component: () => import(/* webpackChunkName: "about" */ './views/Form.vue'),
      
    },
    {
      path: '/view',//测试用，打开一个固定视图--Jarod
      name: 'view',
      component: () => import(/* webpackChunkName: "about" */ './views/View.vue')
    },
    {
      path: '/open',//测试用，打开一个固定视图--Jarod
      name: 'open',
      component: Opener,
      meta: {
        keepAlive: true,//此组件需要被缓存
        title: ''
      }
    },
    // {
    //   path: '/open2',//测试用，打开一个固定视图--Jarod
    //   name: 'open2',
    //   component: () => import(/* webpackChunkName: "about" */ './views/Opener2.vue'),
    // },
    {
      path: '/launch',
      name: 'launch',
      component: Launch,
      meta: {
        keepAlive: true,//此组件需要被缓存
        title: 'hhhh'
      }
    },
    {
      path: '/menu',
      name: 'menu',
      component: Menu,
      meta: {
        keepAlive: true,//此组件需要被缓存
        title: 'ffff'
      }
    },
    {
      path: '/about',
      name: 'about',
      // route level code-splitting
      // this generates a separate chunk (about.[hash].js) for this route
      // which is lazy-loaded when the route is visited.
      component: () => import(/* webpackChunkName: "about" */ './views/About.vue')
    },
    {
      path: '/qrcodeCallback',
      name: 'qrcodeCallback',
      component: qrcodeCallback
    },
    {
      path: '/test',
      name: 'test',
      component: () => import('./components/test.vue')
    }
  ],
})

router.beforeEach((to, from, next) => {
  if(!localStorage.getItem('accessToken')) {
    let url;
    if(statiContextPath){
      url = window.location.origin + statiContextPath + signonContextPath +"/mobilelogin.html"
    }else{
      url = window.location.origin + signonContextPath + "/mobilelogin.html"
    }
    return window.location.href = url;
  }
  next();
});

export default router;
