import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'
import API from "@/api.js";
import COMMON from "@/common.js";
import Constant from "@/Constant.js";
// import obpmConfig from "../public/js/obpm.config.js"
// Vue.prototype.obpmConfig = obpmConfig; //自定义接口路径名比如obpm;
Vue.config.productionTip = false

import './assets/style/mobile.scss'

//挂载 h5 app 通信机制
import { JsBridge } from "@/utils/JsBridge.js";
Vue.prototype.$JsBridge = new JsBridge([]);

import Mint from 'mint-ui'
// import 'mint-ui/lib/style.css'
Vue.use(Mint);

import VueAppend from 'vue-append'
Vue.use(VueAppend)

// import ElementUI from 'element-ui';
//import 'element-ui/lib/theme-chalk/index.css';

import i18n from './i18n'

import Toastr from 'vue-toastr';
// import 'vue-toastr/dist/vue-toastr.css';
import Print from 'vue-print-nb';

import BaiduMap from 'vue-baidu-map'
//import QRCode from 'qrcodejs2'
import echarts from 'echarts'
import 'vant/lib/index.css';
Vue.prototype.$echarts = echarts;

Vue.prototype.$api= API;
Vue.prototype.$common= COMMON;
Vue.prototype.$Constant = Constant;
import VueWechatTitle from 'vue-wechat-title';  
Vue.use(VueWechatTitle)

Vue.use(BaiduMap, {
  // ak 是在百度地图开发者平台申请的密钥 详见 http://lbsyun.baidu.com/apiconsole/key */
  ak: '35f23767ebad2b65905c0352b331762d'
})

Vue.use(Print);
Vue.use(Toastr);


import {
  Cell, 
  CellGroup,
  ActionSheet,
  Icon,
  Popup,
  Field,
  Swipe,
  SwipeItem,
  Lazyload,
  ImagePreview,
  DatetimePicker,
  Button,
  Picker,
  RadioGroup, 
  Radio
} from "vant";
Vue.use(ActionSheet)
  .use(Cell)
  .use(CellGroup)
  .use(Icon)
  .use(Popup)
  .use(Field)
  .use(Swipe)
  .use(SwipeItem)
  .use(Lazyload)
  .use(ImagePreview)
  .use(DatetimePicker)
  .use(Button)
  .use(Picker)
  .use(RadioGroup)
  .use(Radio)
  ;

// Vue.use(ElementUI);
//Vue.use(QRCode);
// import Vue from "vue";
import o_input from "@/components/o_input.vue"
import o_select from "@/components/o_select.vue"
import o_textarea from "@/components/o_textarea.vue"
import o_radio from "@/components/o_radio.vue"
import o_checkbox from "@/components/o_checkbox.vue"
import o_date_picker from "@/components/o_date_picker.vue"
import o_department from "@/components/o_department.vue"
import o_calctext from "@/components/o_calctext.vue"
import o_button from "@/components/o_button.vue"
import o_select_about from "@/components/o_select_about.vue"
import o_suggest from "@/components/o_suggest.vue"
import o_user_select from "@/components/o_user_select.vue"
import o_dept_tree_select from "@/components/o_dept_tree_select.vue"
import o_include from "@/components/o_include.vue"
import o_dept_select from "@/components/o_dept_select.vue"
import o_tab from "@/components/o_tab.vue"
import o_photo from "@/components/o_photo.vue"
import o_file_upload from "@/components/o_file_upload.vue"
import o_image_upload from "@/components/o_image_upload.vue"
import o_view_dialog from "@/components/o_view_dialog.vue"
import o_survey from "@/components/o_survey.vue"
import o_qrcode from "@/components/o_qrcode.vue"
import o_map from "@/components/o_map.vue"
import o_flow_history from "@/components/o_flow_history.vue"
import o_gps from "@/components/o_gps.vue"
import o_record from "@/components/o_record.vue"
import o_word from "@/components/o_word.vue"
import o_flow_reminder_history from "@/components/o_flow_reminder_history.vue"
import view_mapview from "@/components/view_mapview.vue"
import view_treeview from "@/components/view_treeview.vue"
import view_delegate from "@/components/view_delegate.vue"
import comm_tree from "@/components/comm_tree.vue"
import o_action from "@/components/o_action.vue"
import o_split from "@/components/o_split.vue"
import o_coding from "@/components/o_coding.vue";
import o_file_kms from "@/components/o_file_kms.vue"
// import Vue from 'vue'


import o_html from "@/components/o_html.vue";

import comm_dialog from "@/components/comm_dialog.vue";
import { Promise } from 'core-js';


Vue.component("comm-dialog", comm_dialog);

Vue.component("o-input", o_input);
Vue.component("o-select", o_select);
Vue.component("o-textarea", o_textarea);
Vue.component("o-radio", o_radio);
Vue.component("o-checkbox", o_checkbox);
Vue.component("o-date-picker", o_date_picker);
Vue.component("o-department", o_department);
Vue.component("o-html", o_html);
Vue.component("o-calctext", o_calctext);
Vue.component("o-button", o_button);
Vue.component("o-select-about", o_select_about);
Vue.component("o-suggest", o_suggest);
Vue.component("o-user-select", o_user_select);
Vue.component("o-dept-tree-select", o_dept_tree_select);
Vue.component("o-include", o_include);
Vue.component("o-dept-select", o_dept_select);
Vue.component("o-tab", o_tab);
Vue.component("o-photo", o_photo);
Vue.component("o-file-upload", o_file_upload);
Vue.component("o-image-upload", o_image_upload);
Vue.component("o-view-dialog", o_view_dialog);
Vue.component("o-survey", o_survey);
Vue.component("o-qrcode", o_qrcode);
Vue.component("o-map", o_map);
Vue.component("o-flow-history", o_flow_history);
Vue.component("o-gps", o_gps);
Vue.component("o-record", o_record);
Vue.component("o-word", o_word);
Vue.component("o-flow-reminder-history",o_flow_reminder_history);
Vue.component("view-mapview", view_mapview);
Vue.component("view-treeview", view_treeview);
Vue.component("view-delegate",view_delegate);
Vue.component("comm-tree",comm_tree);
Vue.component("o-action",o_action);
Vue.component("o-split",o_split);
Vue.component("o-no",o_coding);
Vue.component("o-file-kms",o_file_kms);

import { Indicator } from "mint-ui";


//获取并设置appid到根组件
let params = window.location.href;
let query = params.split("?")[1];
if(query) {
  query = query.replace(/(\s|#\/)+$/g, '');
} 
let obj = {};
if(query) {
  let qArray = query.split("&");
  qArray.forEach(items => {
    let item = items.split("=");
    obj[item[0]] = item[1];
  });
}

let p1 = new Promise(
  resolve => {
    API.getMaibApplications({}, {
      onSucess: response => {
        if (response.data && response.data.errmsg == "ok") {
          let urls = window.location.href;
          let appid;
          let appId;
          let application;
          if(urls.split("?")[1]) {
            let arr = urls.split("?")[1];
            if(arr.split("&")[0]) {
              let arr2 = arr.split("&")[0];
              if(arr2.split("=")[1]) {
                application = arr2.split("=")[0];
                appid = arr2.split("=")[1];
              }
            }
          }
          if(appid && application == "application") {
            if(appid && appid.indexOf("#/") > -1) {
              appId = appid.split("#/")[0];
              // appid = appid.replace(/(\s|#\/)+$/g, '');
            } else {
              appId = appid;
            }
            let obj = {};
            obj.appid = appId;
            obj.name = "";
            response.data.data.applications.forEach(app => {
              if(app.id == appId) {
                obj.name = app.name;
              }
            });
            resolve(obj);
            //resolve(appid);
          }else {
            response.data.data.applications.forEach(app => {
              if (app.id != "km" && app.id != "pm" && app.id != "qm") {
                let obj = {};
                obj.appid = app.id;
                obj.name = app.name;
                //resolve(app.id);
                resolve(obj);
              }
            });
          }
        }
      }
    });
  }
);

let p2 =  new Promise(resolve => {
  API.getMainMyProfile(
    {},
    {
      onSucess: resp => {
        store.state.myProfile = resp.data.data;
        resolve(resp.data.data);
      } 
    }
  )
});

Promise.all([p1, p2]).then(function (result) {

  
  new Vue({
    data: { appid: result[0].appid, user: result[1], name: result[0].name },
    i18n,
    router,
    store,
    render: h => h(App)
  }).$mount('#app')

  
  
});







