export default {
    convertTemplate: function (fields) {
        //手机端逻辑，不能根据模板，而只能根据field模拟一个模板
        let mobileTmpl = "";
        fields.forEach(field => {
            //console.log("field", field);
            let fieldTag = "";
            if (field) {
                switch (field.formField) {
                    case "InputField":
                        fieldTag = "o-input";
                        break;
                    case "TextareaField":
                        fieldTag = "o-textarea";
                        break;
                    case "RadioField":
                        fieldTag = "o-radio";
                        break;
                    case "SelectField":
                        fieldTag = "o-select";
                        break;
                    case "ImageUploadField":
                        fieldTag = "o-image-upload";
                        break;
                    case "AttachmentUploadField":
                        fieldTag = "o-file-upload";
                        break;
                    case "DateField":
                        fieldTag = "o-date-picker";
                        break;
                    case "IncludeField":
                        fieldTag = "o-include";
                        break;
                    case "CheckboxField":
                        fieldTag = "o-checkbox";
                        break;
                    case "MapField":
                        fieldTag = "o-map";
                        break;
                    case "QRCodeField":
                        fieldTag = "o-qrcode";
                        break;
                    case "SuggestField":
                        fieldTag = "o-suggest";
                        break;
                    case "DepartmentField":
                        fieldTag = "o-dept-select";
                        break;
                    case "TreeDepartmentField":
                        fieldTag = "o-dept-tree-select"
                        break;
                    case "SelectAboutField":
                        fieldTag = "o-select-about";
                        break;
                    case "HTMLEditorField":
                        fieldTag = "o-html";
                        break;
                    case "SurveyField":
                        fieldTag = "o-survey";
                        break;
                    case "FlowHistoryField":
                        fieldTag = "o-flow-history";
                        break;
                    case "ButtonField":
                        fieldTag = "o-button";
                        break;
                    case "ViewDialogField":
                        fieldTag = "o-view-dialog";
                        break;
                    case "TabField":
                        fieldTag = "o-tab";
                        break;
                    case "GenericWordField":
                        fieldTag = "o-word";
                        break;
                    case "UserField":
                        fieldTag = "o-user-select";
                        break;
                    case "WeixinGpsField":
                        fieldTag = "o-gps";
                        break;
                    case "OnLineTakePhotoField":
                        fieldTag = "o-photo";
                        break;
                    case "WeixinRecordField":
                        fieldTag = "o-record";
                        break;
                    case "CalctextField":
                        fieldTag = "o-calctext";
                        break;
                    case "FlowReminderHistoryField":
                        fieldTag = "o-flow-reminder-history";
                        break;
                    case "SplitField":
                        fieldTag = "o-split";
                        break;
                    case "NoField":
                        fieldTag = "o-no";
                        break;
                    case "KmsDataField":
                        fieldTag = "o-file-kms";
                        break;
                    default:
                        if (field.type == "tabfield" || field.scope == "tabField") {
                            fieldTag = "o-tab";
                        }
                        break;
                }
            }

            if (fieldTag != "")
                mobileTmpl += `<${fieldTag} v-bind="$attrs"
                v-on="$listeners" id='${field.id}'></${fieldTag}>`;
        });
        return mobileTmpl;
    },

    /**
     * 获取cookie的值
     */
    getCookie: function(cname){
        let name = cname + "=";
        let ca = document.cookie.split(';');
        for(let i=0; i<ca.length; i++) 
        {
            let c = ca[i].trim();
            if (c.indexOf(name)==0) return c.substring(name.length,c.length).toLocaleLowerCase()
        }
        return "";
    },

    messagecomp: undefined,
    message: {
        info(msg) {
            console.log("msg", msg, this.messagecomp);
        }
    },
    getAllUrlParamsAndRedirect:function(newPageUrl){
        // 获取当前页面的查询参数
        const currentSearchParams = new URLSearchParams(window.location.search);

        // 创建一个空对象来保存所有的参数键值对
        let paramsObject = {};
        
        // 遍历所有的参数并存入对象
        for (let [key, value] of currentSearchParams.entries()) {
            paramsObject[key] = value;
        }

        // 创建一个新的URL对象，指向目标页面
        let newUrl = new URL(newPageUrl);

        console.log("getAllUrlParamsAndRedirect...",newPageUrl,paramsObject,newUrl);
        
        // 将获取到的参数添加到新的URL中
        Object.keys(paramsObject).forEach(key => {
            newUrl.searchParams.append(key, paramsObject[key]);
        });

        return newUrl.toString();
    }
}