// 引入 axios
import axios from 'axios';
import Constant from "@/Constant.js"
import common from '@/common.js';
// import config from "../public/js/obpm.config.js"
// const contextPath = Constant.contextPath;
const contextPath = obpmConfig.contextPath;//config.contextPath;

let token = "eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTcyNzc3MTM3MiwidXNlcm5hbWUiOiJfX2lVZ3JSWGNKUzF4eFgyQ0gxUksifQ.ljrLSOnvjgSfr1DLzviZVa19ulNnPvH5u8s6--Ge19Q"
let accessToken = ""
if (process.env.NODE_ENV == "development") {
    accessToken = token;
    localStorage.setItem('accessToken', token)
} else {
    accessToken = Constant.accessToken;
}

const signonPath = Constant.signonPath;
const statiContextPath = obpmConfig.statiContextPath;//config.statiContextPath;
const kmsPath = Constant.kmsPath;
//http response 拦截器
axios.interceptors.response.use(
    response => {
        return response;
    },
    error => {
        //未登录
        if (!localStorage.getItem('accessToken') || error.response.status == 401) {
            let ua = window.navigator.userAgent;
            if (ua.indexOf("myApps") >= 0) {
                let u = navigator.userAgent;
                let isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
                let isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                if (isiOS) {
                    window.webkit.messageHandlers.backToHome.postMessage(null);
                } else if (isAndroid) {
                    let _native = top.nativeAPI ? top.nativeAPI : nativeAPI;
                    _native.backToHome()
                }
            } else {
                let url;
                if (statiContextPath) {
                    url = window.location.origin + statiContextPath + signonPath + "/mobilelogin.html"
                } else {
                    url = window.location.origin + signonPath + "/mobilelogin.html"
                }
                window.location.href = url;
            }

        }
        else {
            return Promise.reject(error)
        }
    }
);

export default {
    getMyProfile: function ({ onSucess, onError }) {
        axios.get(contextPath + '/runtime/users/myprofile?accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    getMainMyProfile: function (params, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/users/myprofile?accessToken=' + accessToken,
            method: 'get',
            params: params,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    /**
     * 添加常用发起菜单
     */
    addMenuToFavorites: function (appid, menuid, { onSucess, onError }) {
        axios.post(contextPath + '/runtime/' + appid + '/flowcenters/startMenus/' + menuid + '/usual?isMobile=true' + "&accessToken=" + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 移除常用发起菜单
     * @param {*} parentId 
     * @param {*} param1 
     */
    removeMenuFromFavorites: function (appid, menuid, { onSucess, onError }) {
        axios.delete(contextPath + '/runtime/' + appid + '/flowcenters/startMenus/' + menuid + '/usual?isMobile=true' + "&accessToken=" + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 部门选择
     * http://localhost:8080/obpm/portal/component/user/getDepartmentsByParentId.action?parentId=Z42xU8LmniRouZ93E7s
     */
    getDepartmentsByParentId: function (appid, parentId, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/' + appid + '/departments/selectbox/childs?parentId=' + parentId + "&accessToken=" + accessToken)
            .then(function (response) {
                if (onSucess) onSucess(response);
            }).catch(
                function (error) {
                    if (onError) onError(error);
                }
            );
    },

    /**
     * 5.13挂起流程
     * 保存文档并挂起流程。
     * 请求方式：PUT
     * 请求地址：/runtime/{applicationId}/documents/{docId}/workflows/suspend
     */
    suspendWorkflow: function (appId, docId, { onSucess, onError }) {
        axios.put(contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/suspend?accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    /**
     * 5.14恢复流程
     * 请求方式：PUT
     * 请求地址：/runtime/{applicationId}/documents/{docId}/workflows/recovery
     */
    recoveryWorkflow: function (appId, docId, { onSucess, onError }) {
        axios.put(contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/recovery?accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    /**
     * 5.11撤回流程
     * 请求方式：PUT
     * 请求地址：/runtime/{applicationId}/documents/{docId}/workflows/retracement
     */
    retracementWorkflow: function (appId, docId, { onSucess, onError }) {
        axios.put(contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/retracement?accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    /**
     * 5.12终止流程
     * 请求方式：PUT
     * 请求地址：/runtime/{applicationId}/documents/{docId}/workflows/termination
     */
    terminationWorkflow: function (appId, docId, attitude, { onSucess, onError }) {
        axios.put(contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/termination?attitude=' + attitude + "&accessToken=" + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    getApplications: function ({ onSucess, onError }) {
        axios.get(contextPath + '/runtime/applications?accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    getMaibApplications: function (params, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/applications?accessToken=' + accessToken,
            method: 'get',
            params: params,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
        // axios.get(contextPath + '/runtime/applications?accessToken=' + accessToken).then(function (response) {
        //     if (onSucess) onSucess(response);
        // }).catch(
        //     function (error) {
        //         if (onError) onError(error);
        //     }
        // );
    },

    getMenus: function (appId, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/' + appId + '/menus?isMobile=true' + '&accessToken=' + accessToken).then(function (response) {
            console.log('___________________________');

            console.log(response);

            const data = response.data.data || {}
            console.log(data, "____________data");
            let bool = false
            if (Array.isArray(data) && data.length === 1) {//特殊情况 临时改的
                console.log(data);

                let tdata = data.find((item) =>
                    item.linkType === '07'


                )

                if (tdata && tdata.actionContent) {
                    console.log(333333333333);
                    console.log(' tdata.actionContent---xxx', tdata.actionContent);
                    bool = true

                    if (onSucess) onSucess(response, bool);

                    let newUrl = common.getAllUrlParamsAndRedirect(tdata.actionContent);
                    console.log(' tdata.actionContent---expected url', newUrl,tdata.actionContent);
                    window.location.href = newUrl;
                    return
                }

            }


            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    getHomePageConfig: function ({ onSucess, onError }) {
        axios.get(contextPath + '/runtime/homepage/config?isMobile=true' + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    getHomePageConfigWithPhone: function (appId, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/' + appId + '/homepage/phoneConfig?accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    getStartMenus: function (appId, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/' + appId + '/flowcenters/startmenus?isMobile=true' + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    getPendings: function (appId, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/flowcenters/navs/pendings?applicationId=' + (appId ? appId : '') + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    getFilterPendings: function (appId, domainId, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/flowcenters/navs/pendings?applicationId=' + appId + "&domainId=" + domainId + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },


    ///runtime/{applicationId}/flowcenters/pendings?title={title}&flowId={flowId}&initiatorId={initiatorId}&pageNo={pageNo}&linesPerPage={linesPerPage}
    getPendingSortList: function (appId, title, flowId, initiatorId, pageNo, linesPerPage, isMobile, { onSucess, onError }) {
        axios.get(contextPath + "/runtime/" + appId + "/flowcenters/pendings?title=" + title + "&flowId=" + flowId + "&initiatorId=" + initiatorId + "&pageNo=" + pageNo + "&linesPerPage=" + linesPerPage + "&isMobile=" + isMobile + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    getProcessedsSortList: function (appId, title, flowId, initiatorId, status, isMyWorkFlow, pageNo, linesPerPage, { onSucess, onError }) {
        axios.get(contextPath + "/runtime/" + appId + "/flowcenters/processeds?title=" + title + "&flowId=" + flowId + "&initiatorId=" + initiatorId + "&status=" + status + "&isMyWorkFlow=" + isMyWorkFlow + "&pageNo=" + pageNo + "&linesPerPage=" + linesPerPage + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    getPendingList: function (appId, params, { onSucess, onError }) {
        var urlParams = '';
        for (var key in params) {
            if (urlParams == '') {
                urlParams += '?';
            } else {
                urlParams += '&';
            }
            urlParams += key + '=' + params[key];
        }
        if (urlParams) {
            urlParams = urlParams + '&accessToken=' + accessToken;
        }
        axios.get(contextPath + '/runtime/' + (appId ? appId : '') + '/flowcenters/pendings' + urlParams).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    getProcesseds: function (appId, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/flowcenters/navs/processeds?applicationId=' + (appId ? appId : '') + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    getProcessedList: function (appId, params, { onSucess, onError }) {
        var urlParams = '';
        for (var key in params) {
            if (urlParams == '') {
                urlParams += '?';
            } else {
                urlParams += '&';
            }
            urlParams += key + '=' + params[key];
        }
        if (urlParams) {
            urlParams = urlParams + '&accessToken=' + accessToken;
        }
        axios.get(contextPath + '/runtime/' + (appId ? appId : '') + '/flowcenters/processeds' + urlParams).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    getViewTemplate: function (appId, viewId, exparams, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/views/' + viewId + '/template?accessToken=' + accessToken,
            method: 'get',
            params: exparams ? exparams : ''
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //树形视图
    getViewTemplateP: function (appId, viewId, parentId, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/' + appId + '/views/' + viewId + '/template?parentId=' + parentId + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    //包含元素或选项卡时
    getViewTemplateInclude: function (appId, viewId, parentId, isRelate, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/' + appId + '/views/' + viewId + '/template?parentId=' + parentId + '&isRelate=' + isRelate + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    getSearchFormTemplate: function (appId, viewId, exparams, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/views/' + viewId + '/searchformtemplate?accessToken=' + accessToken,
            method: 'get',
            params: exparams ? exparams : ''
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })


        // axios.get(contextPath + '/runtime/' + appId + '/views/' + viewId + '/searchformtemplate?accessToken=' + accessToken).then(function (response) {
        //     if (onSucess) onSucess(response);
        // }).catch(
        //     function (error) {
        //         if (onError) onError(error);
        //     }
        // );
    },

    /**
     * 获取视图数据
     */
    getViewData: function (appId, viewId, params, data, { onSucess, onError }) {
        var urlParams = '';
        var parentId = params.parentId ? params.parentId : '';
        var sortCol = params.sortCol ? params.sortCol : '';
        var sortStatus = params.sortStatus ? params.sortStatus : '';
        var currpage = params.currpage ? params.currpage : '1';
        var lines = params.lines ? params.lines : '';
        var treedocid = params.treedocid ? params.treedocid : '';
        var parentNodeId = params.parentNodeId ? params.parentNodeId : '';
        var docid = params.docid ? params.docid : '';
        var fieldid = params.fieldid ? params.fieldid : '';
        var isRelate = params.isRelate ? params.isRelate : '';
        var startDate = params.startDate ? params.startDate : '';
        var endDate = params.endDate ? params.endDate : '';
        var exparams = params.exparams ? params.exparams : '';
        // var isMobile = params.isMobile? params.isMobile : '';
        var searchWord = params.searchWord ? params.searchWord : '';
        urlParams += '?parentId=' + parentId + '&sortCol=' + sortCol +
            '&sortStatus=' + sortStatus + '&_currpage=' + currpage +
            '&lines=' + lines + '&treedocid=' + treedocid +
            '&searchWord=' + searchWord +
            '&parentNodeId=' + parentNodeId + '&_docid=' + docid +
            '&_fieldid=' + fieldid + '&isRelate=' + isRelate +
            '&startDate=' + startDate + '&endDate=' + endDate +
            '&isMobile=true' +
            '&accessToken=' + accessToken;
        if (params.formParams) {
            urlParams = urlParams + params.formParams;
        }
        if (data && exparams) {
            data = Object.assign(data, exparams);
        }

        axios.post(contextPath + '/runtime/' + appId + '/views/' + viewId + '/documents' + urlParams, data ? data : {}).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 获取树形视图数据
     */
    getTreeViewData: function (appId, viewId, params, data, name, { onSucess, onError }) {
        let urlParams = '';
        let sortCol = params.sortCol ? params.sortCol : '';
        let sortStatus = params.sortStatus ? params.sortStatus : '';
        let parentId = params.parentId ? params.parentId : '';
        urlParams += '?sortCol=' + sortCol +
            '&sortStatus=' + sortStatus +
            '&parentId=' + parentId +
            '&name=' + name;
        if (params.parentDocId) {
            urlParams += '&parentDocId=' + params.parentDocId;
        }
        urlParams += '&accessToken=' + accessToken;
        axios.post(contextPath + '/runtime/' + appId + '/treeviews/' + viewId + '/documents' + urlParams, data ? data : {}).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 获取表单
     */
    getForm: function (appId, formId, docId, exparams, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/forms/' + formId + '/documents/' + docId + '?accessToken=' + accessToken,
            method: 'get',
            params: exparams ? exparams : {}
        }).then((response) => {
            if (onSucess) onSucess(response);
        }).catch((error) => {
            if (onError) onError(error);
        })
    },

    /**
     * 获取表单
     */
    getDocument: function (appId, docId, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/' + appId + '/documents/' + docId + '?accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 获取空文档
     */
    getDocumentEmpty: function (appId, formId, exparams, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/' + appId + '/forms/' + formId + '/empty?accessToken=' + accessToken, { params: exparams ? exparams : {} }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 2.6	更新文档（带校验）
     *  请求方式：PUT
     *  请求地址：/runtime/{applicationId}/documents/{id}
     */
    saveDocument: function (appId, formId, docId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '?accessToken=' + accessToken,
            method: 'put',
            data: docJson,
            //发送格式为json
            // data: JSON.stringify(docJson),
            //                 headers:
            //                        {
            //                          'Content-Type': 'application/json'
            //                        }
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    //创建文档（保存草稿不进行校验）
    saveWithoutValidDocument: function (appId, formId, docId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/withoutValid?accessToken=' + accessToken,
            method: 'post',
            //发送格式为json
            data: docJson,
            //data: JSON.stringify(docJson),
            //                 headers:
            //                        {
            //                          'Content-Type': 'application/json'
            //                        }
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    //更新文档（保存草稿不进行校验）
    editWithoutValidDocument: function (appId, formId, docId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/withoutValid?accessToken=' + accessToken,
            method: 'PUT',
            //发送格式为json
            data: docJson,
            //data: JSON.stringify(docJson),
            //                 headers:
            //                        {
            //                          'Content-Type': 'application/json'
            //                        }
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 复制文档v
     */
    copeDocument: function (appId, docId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/activities/copy?accessToken=' + accessToken,
            method: 'post',
            //发送格式为json
            //data: JSON.stringify(docJson),
            data: docJson,
            //                 headers:
            //                        {
            //                          'Content-Type': 'application/json'
            //                        }
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    /**
     *创建文档
     */
    createDocument: function (appId, formId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents?accessToken=' + accessToken,
            method: 'post',
            //发送格式为json
            data: JSON.stringify(docJson),
            //                 headers:
            //                        {
            //                          'Content-Type': 'application/json'
            //                        }
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 2.10	批量删除文档
     * 请求方式：DELETE
     * 请求地址：/runtime/{applicationId}/documents
     */
    batchRemoveDocuments: function (appId, idsArray, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents?accessToken=' + accessToken,
            method: 'delete',
            //发送格式为json
            data: JSON.stringify(idsArray),
            //                 headers:
            //                        {
            //                          'Content-Type': 'application/json'
            //                        }
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     *5.4	获取文档的流程提交面板
     *服务器返回当前文档流程面板所需要的全部信息，包含当前节点信息，下一步节点的相信配置信息。
     *请求方式：post
     *请求地址：/runtime/{applicationId}/documents/{docId}/panels/submission
     */
    getFlowPanel: function (appId, docId, flowData, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/panels/submission?accessToken=' + accessToken,
            method: 'post',
            data: flowData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     *5.5获取文档的流程回退面板
     *  服务器返回当前文档流程面板所需要的全部信息，包含当前节点信息，下一步节点的相关配置信息。
     *  请求方式：GET
     *  请求地址：/runtime/{applicationId}/document/{docId}/panels/back
     */
    getBackPanel: function (appId, docId, flowData, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/panels/back?accessToken=' + accessToken,
            method: 'POST',
            data: flowData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     *5.8	提交流程
     *保存文档并提交流程。
     *请求方式：PUT
     *请求地址：/runtime/{applicationId}/documents/{docId}/workflows/submit
     */
    /**
     *   {
            "flowId":"14e7dwq091134ct9635fG",
            "flowType":"80",
            "currentNodeId":"1470911349635",
            "nextNodeIds":["1470911349645","1470911349644"],---计算得出
            "attitude":"",
            "signature":"",
            "submitTo": "",
            "circulatorInfo":"",
            "subFlowApproverInfo":"",
            "subFlowApproverInfoAll":""
            "document":{
                "id": "value",
                "formId": "value",
                "applicationid": "value",
                "stateid": "value",
                "versions": 0,
                "parentid": "value",
                …//其他系统字段
                "sign": "value",
                "items": [
                    {
                        "name": "demo",
                        "age": 18,
                        "date": "2017-6-23"
                    }
                ]
            }
        }

     *
     */
    submitFlow: function (appId, docId, flowData, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/submit?accessToken=' + accessToken,
            method: 'put',
            data: flowData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 5.10回退流程
     * 保存文档并回退流程。
     * 请求方式：PUT
     * 请求地址：/runtime/{applicationId}/documents/{docId}/workflows/back
     {
        "flowId":"14e7dwq091134ct9635fG",
        "flowType":"81",
        "currentNodeId":"1470911349635",
        "nextNodeIds":["1470911349645"],
        "attitude":"",
        "signature":"",
        "document":{
            "id": "value",
            "formId": "value",
            "applicationid": "value",
            "stateid": "value",
            "versions": 0,
            "parentid": "value",
            …//其他系统字段
            "sign": "value",
            "items": [
                {
                    "name": "demo",
                    "age": 18,
                    "date": "2017-6-23"
                }
            ]
        }
    }
     */
    backFlow: function (appId, docId, flowData, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/back?accessToken=' + accessToken,
            method: 'put',
            data: flowData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 5.9催办流程
     保存文档并流程催办。
     请求方式：PUT
     请求地址：/runtime/{applicationId}/documents/{docId}/workflows/remind

     {
        "reminderContent":"zz",
        "nodertIds":["1470911349645","1470911349644"]
        }
     */
    remindFlow: function (appId, docId, flowData, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/remind?accessToken=' + accessToken,
            method: 'put',
            data: flowData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     *  自由流程-提交
     请求方式：PUT
     请求地址：/runtime/{applicationId}/documents/{docId}/freeflows/submit

     {
            "flowType":"80",
            "nextUserId":"sf34sdsfKJg342",
            "attitude":"",
            "document":{
                "id": "value",
                "formId": "value",
                "applicationid": "value",
                "stateid": "value",
                "versions": 0,
                "parentid": "value",
                …//其他系统字段
                "sign": "value",
                "items": [
                    {
                        "name": "demo",
                        "age": 18,
                        "date": "2017-6-23"
                    }
                ]
            }
        }
     */
    submitFreeFlow: function (appId, docId, flowData, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/freeflows/submit?accessToken=' + accessToken,
            method: 'put',
            data: flowData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     *  自由流程-回退
     请求方式：PUT
     请求地址：/runtime/{applicationId}/documents/{docId}/freeflows/back

     {
            "flowType":"80",
            "nextUserId":"sf34sdsfKJg342",
            "attitude":"",
            "document":{
                "id": "value",
                "formId": "value",
                "applicationid": "value",
                "stateid": "value",
                "versions": 0,
                "parentid": "value",
                …//其他系统字段
                "sign": "value",
                "items": [
                    {
                        "name": "demo",
                        "age": 18,
                        "date": "2017-6-23"
                    }
                ]
            }
        }
     */
    backFreeFlow: function (appId, docId, flowData, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/freeflows/back?accessToken=' + accessToken,
            method: 'put',
            data: flowData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     *  自由流程-结束
     请求方式：PUT
     请求地址：/runtime/{applicationId}/documents/{docId}/freeflows/complete

     {
            "flowType":"7",
            "nextUserId":"sf34sdsfKJg342",
            "attitude":"",
            "document":{
                "id": "value",
                "formId": "value",
                "applicationid": "value",
                "stateid": "value",
                "versions": 0,
                "parentid": "value",
                …//其他系统字段
                "sign": "value",
                "items": [
                    {
                        "name": "demo",
                        "age": 18,
                        "date": "2017-6-23"
                    }
                ]
            }
        }
     */
    completeFreeFlow: function (appId, docId, flowData, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/freeflows/complete?accessToken=' + accessToken,
            method: 'put',
            data: flowData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },


    /**
     * 3.7刷新表单
     *   表单某控件触发全局刷新表单的动作，服务器根据最新的文档状态重新运算开启重计算功能的全部控件的值脚本，返回状态发生变更的控件内容。
     *   请求方式：POST
     *   请求地址：/runtime/{applicationId}/forms/{formId}/documents/{docId}/refresh
     */
    refreshForm: function (actField, docJson, { onSucess, onError }) {
        var appId = docJson.applicationId;
        var formId = docJson.formId;
        var docId = docJson.id;
        var refreshData = {
            actField: actField,
            tabId: '',
            document: docJson.document
        };

        axios({
            url: contextPath + '/runtime/' + appId + '/forms/' + formId + '/documents/' + docId + '/refresh?accessToken=' + accessToken,
            method: 'post',
            // data: JSON.stringify(refreshData),
            data: refreshData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 获取文档的流程历史
     */
    getFlowHistorys: function (appId, docId, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/flowhistorys?content=' + '' + '&accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    /**
     * 获取文档的催办记录
     */
    getRemindHistorys: function (appId, docId, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/remind-historys?accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 运算自定义动作脚本
     */
    executeCustom: function (applicationId, id, data, params, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/activities/" + id + "/execute?accessToken=" + accessToken,
            method: 'put',
            data: data,
            params,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 保存并启动流程
     */
    saveStartWorkFlow: function (applicationId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/documents/activities/saveStartWorkFlow?accessToken=" + accessToken,
            method: 'post',
            data: docJson,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    /**
     * 签章
     */
    saveSign: function (applicationId, docId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/documents/" + docId + "/activities/sign?accessToken=" + accessToken,
            method: 'post',
            data: JSON.stringify(docJson),
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 归档
     */
    Archive: function (applicationId, docId, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/documents/" + docId + "/activities/archive?accessToken=" + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 清除所有数据
     */
    deleteAllData: function (applicationId, formId, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/forms/" + formId + "/activities/clear?accessToken=" + accessToken,
            method: 'delete',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 批量审批
     */
    batchApprove: function (applicationId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/forms/activities/batchApprove?accessToken=" + accessToken,
            method: 'post',
            data: docJson,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 流程协办（点评）
     */
    review: function (appId, instanceId, comments, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/workflows/' + instanceId + '/assist?attitude=' + comments + '&accessToken=' + accessToken,
            method: 'put',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    /**
     * 添加/补签意见
     */
    supplement: function (appId, instanceId, comments, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/workflows/' + instanceId + '/supplement?comments=' + comments + '&accessToken=' + accessToken,
            method: 'put',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    /**
     * 加签（主办）
     */
    processHosting: function (appId, docId, data, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/approver/addition?accessToken=' + accessToken,
            method: 'put',
            data: data,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    /**
     * 加签（协办）
     */
    processCoHosting: function (appId, docId, data, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/assist/addition?accessToken=' + accessToken,
            method: 'put',
            data: data,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     *  视图选择框确认执行脚本
     */
    runViewDialogCallbackScript: function (docJson, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/views/selectbox/runViewDialogCallbackScript?accessToken=" + accessToken,
            method: 'post',
            data: docJson,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     *  是否有打开表单的权限
     *  /runtime/{applicationId}/forms/{formId}/documents/{docId}/openable
     */
    hasPermissionToForm(appId, formId, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/forms/' + formId + '/openable?accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     *  是否有打开视图的权限
     *  
     */
    hasPermissionToView(appId, viewId, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/views/' + viewId + '/openable?accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },


    runScript: function (appId, actId, docId, fieldName, _, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/activities/' + actId + '/runScript?docId=' + docId + '&fieldName=' + fieldName + "&_" + _ + '&accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    deleteUpload: function (appId, formId, docId, path, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/files/delete?applicationId=' + appId + '&formId=' + formId + '&docId=' + docId + '&path=' + path + '&accessToken=' + accessToken,
            method: 'delete',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    // 更新流程节点审批人
    approversWorkflow: function (appId, docId, data, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/workflows/approvers?accessToken=' + accessToken,
            method: 'put',
            data: data,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    //智能提示搜索框
    intellectTip: function (applicationId, formId, docId, data, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/forms/" + formId + "/documents/" + docId + "/querySuggest?accessToken=" + accessToken,
            method: 'post',
            data: data,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    //获取部门树
    getDepartments: function (parentId, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/users/selectbox/dept-tree?parentId=" + parentId + '&accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        )
    },

    //查询
    getSearch: function (keyWord, pageNum, pageSize, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/users/selectbox/search?keyWord=" + keyWord + "&pageNum=" + pageNum + "&pageSize=" + pageSize + '&accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        )
    },

    //部门用户**/runtime/{applicationId}/users/selectbox/department?deptId={deptId}
    getDeptUser: function (application, deptId, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + application + "/users/selectbox/department?deptId=" + deptId + '&accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        )
    },

    //部门树分页
    ///runtime/HdPeBqYwJyFyjHkhZu3/users/selectbox/department?deptId=Z42xU8LmniRouZ93E7s&pageNum=3&pageSize=10
    departmentPage: function (application, deptId, pageNum, pageSize, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + application + "/users/selectbox/department?deptId=" + deptId + "&pageNum=" + pageNum + "&pageSize=" + pageSize + '&accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        )
    },

    //上传图片
    ///runtime/upload?applicationId={applicationId}&allowedTypes={allowedTypes}&fieldId={fieldId}&fileSaveMode={fileSaveMode}&path={path}&actionType={actionType}
    uploadFile: function (files, appId, allowedTypes, fieldId, fileSaveMode, path, actionType, { onSucess, onError }, callback1, uid) {
        axios({
            headers: {
                "content-type": "multipart/form-data;boundary=" + Math.random()
            },
            data: files,
            url: contextPath + "/runtime/upload?applicationId=" +
                appId +
                "&allowedTypes=" +
                allowedTypes +
                "&fieldId=" +
                fieldId +
                "&fileSaveMode=" +
                fileSaveMode +
                "&path=" +
                path +
                "&actionType=" +
                actionType +
                "&accessToken=" + accessToken,

            method: "post",
            onUploadProgress: (progressEvent) => {
                let complete = (progressEvent.loaded / progressEvent.total * 100 | 0) + '%';
                let num = (progressEvent.loaded / progressEvent.total * 100 | 0);
                let obj = {
                    complete: complete,
                    num: num,
                    uid: uid,
                }
                callback1(obj);
            }
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        )
    },

    /**
     *  视图选择框确认执行脚本
     */
    runViewDialogConfirmScript: function (docJson, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/views/selectbox/runViewDialogConfirmScript?accessToken=" + accessToken,
            method: 'post',
            data: docJson,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    /*
        获取个人设置页面的软件列表
    */
    GetsoFtwareList: function ({ onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/applications?accessToken=" + accessToken,
            method: 'get'
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    /**
     * 个人信息设置
     * 请求地址/runtime/usersetups/detail
     */
    PersonalInformationSettings: function (data, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/usersetups/detail?accessToken=' + accessToken,
            method: 'post',
            data: data
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    /**
     * 皮肤设置
     * 请求地址:/runtime/users/skin
     */
    SkinSetting: function (data, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/users/skin?accessToken=' + accessToken,
            method: 'post',
            data
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //提交面板的执行前
    submitRunBeforeActionScript: function (applicationId, id, data, docId, viewId, formId, _templateForm, parentId, isRelate, _flowType, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/activities/" + id + "/runbeforeactionscript?docId=" + docId + "&viewId=" + viewId + "&formId=" + formId + "&_templateForm=" + _templateForm + "&parentId=" + parentId + "&isRelate=" + isRelate + "&_flowType=" + _flowType + '&accessToken=' + accessToken,
            method: 'post',
            data,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //提交面板的执行后
    submitRrunAfterActionScript: function (applicationId, id, data, docId, viewId, formId, _templateForm, parentId, isRelate, _flowType, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/activities/" + id + "/runafteractionscript?docId=" + docId + "&viewId=" + viewId + "&formId=" + formId + "&_templateForm=" + _templateForm + "&parentId=" + parentId + "&isRelate=" + isRelate + "&_flowType=" + _flowType + '&accessToken=' + accessToken,
            method: 'post',
            data,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //执行前脚本
    runBeforeActionScript: function (applicationId, id, data, { onSucess, onError }) {
        let docId = data.docId ? data.docId : '';
        let viewId = data.viewId ? data.viewId : '';
        let formId = data.formId ? data.formId : '';
        let templateForm = data.templateForm ? data.templateForm : '';
        let parentId = data.parentId ? data.parentId : '';
        let isRelate = data.isRelate ? data.isRelate : '';
        axios({
            url: contextPath + "/runtime/" + applicationId + "/activities/" + id + "/runbeforeactionscript?docId=" + docId + "&viewId=" + viewId + "&formId=" + formId + "&_templateForm=" + templateForm + "&parentId=" + parentId + "&isRelate=" + isRelate + "&accessToken=" + accessToken,
            method: 'post',
            data,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //执行后脚本
    ///runtime/HdPeBqYwJyFyjHkhZu3/activities/zLjmORGWoZmG7wXf8LF/runafteractionscript?docId=jPF4VGFTnIrk4wMwonl&viewId=&formId=IfoHRC8Rs6njW75HqiE&_templateForm=&parentId=&_=1566437405210
    runAfterActionScript: function (applicationId, id, docId, viewId, formId, _templateForm, parentId, _, data, actType, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/activities/" + id + "/runafteractionscript?docId=" + docId + "&viewId=" + viewId + "&formId=" + formId + "&_templateForm=" + _templateForm + "&parentId=" + parentId + "&isRelate=" + _ + '&actType=' + actType + '&accessToken=' + accessToken,
            method: 'post',
            data,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //文件下载
    ///runtime/{applicationId}/documents/{docId}/activities/download?actId={actId}
    documentDownload: function (applicationId, docId, actId, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/documents/" + docId + "/activities/download?actId=" + actId + '&accessToken=' + accessToken,
            method: 'post',
            responseType: 'blob',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //PDF导出
    ///runtime/{applicationId}/forms/{formId}/documents/{docId}/activities/exportPdf
    PDFExport: function (applicationId, formId, docId, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/forms/" + formId + "/documents/" + docId + "/activities/exportPdf?accessToken=" + accessToken,
            method: 'post',
            responseType: 'blob',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //获取常用意见
    ///runtime/users/{userId}/commonOpinions
    getCommonOpinions: function (userId, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/users/" + userId + "/commonOpinions?accessToken=" + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //添加常用意见
    addCommonOpinions: function (userId, opinion, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/users/" + userId + "/commonOpinions?opinion=" + opinion + "&accessToken=" + accessToken,
            method: 'post',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },


    //修改意见
    ///runtime/users/{userId}/commonOpinions/{opId}?opinion={opinion}
    updateOpinion: function (userId, opId, opinion, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/users/" + userId + "/commonOpinions/" + opId + "?opinion=" + opinion + "&accessToken=" + accessToken,
            method: 'put',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //删除常用意见
    ///runtime/users/{userId}/commonOpinions/{opId}
    deleteComments: function (userId, opId, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/users/" + userId + "/commonOpinions/" + opId + "?accessToken=" + accessToken,
            method: 'DELETE',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //获取常用菜单
    //http://localhost:8082/obpm/runtime/HdPeBqYwJyFyjHkhZu3/flowcenters/startmenus?isUsual=true
    getCommonMenu: function (appId, isUsual, { onSucess, onError }) {
        axios.get(contextPath + '/runtime/' + (appId ? appId : '') + '/flowcenters/startmenus?isUsual=' + (isUsual ? isUsual : '') + '&isMobile=true' + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },


    //微信js-sdk接口
    getWeixinApi: function (_url, { onSucess, onError }) {
        axios({
            url: contextPath + "/portal/weixin/jsapi/getJsapiConfig.action?_url=" + _url + '&accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //PDF导出
    ///runtime/file/{fileId}/pdf?path={path}
    //http://192.168.10.142:8085/obpm/uploads/doc/201909/swf/e2fce7e9-b831-45f1-a443-29b4a96e7d3d.pdf?t=5
    readPDF: function (fileId, path, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/file/" + fileId + "/pdf?path=" + path + '&accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //获取流程指定审批人用户选择框列表
    ///runtime/{applicationId}/documents/{docId}/workflows/{flowId}/selectApprovers
    selectApprovers: function (appId, docId, flowId, nodeId, type, selectId, pageNum, pageSize, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + appId + "/documents/" + docId + "/workflows/" + flowId + "/selectApprovers?nodeId=" + nodeId + "&type=" + type + "&selectId=" + selectId + "&pageNum=" + pageNum + "&pageSize=" + pageSize + "&accessToken=" + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //更新常用发起菜单(使用次数)
    //runtime/{applicationId}/flowcenters/startMenus/{id}/usual
    updateUsedMenus: function (appId, id, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + appId + "/flowcenters/startMenus/" + id + "/usual?isMobile=true" + "&accessToken=" + accessToken,
            method: 'put',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },


    //获取发起菜单
    ///runtime/{applicationId}/flowcenters/startmenus?isUsual={isUsual}
    getLaunchMenu: function (appId, isUsual, isUsualList, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + appId + "/flowcenters/startmenus?isUsual=" + isUsual + "&isMobile=true" + "&isUsualList=" + isUsualList + '&accessToken=' + accessToken,
            method: 'GET',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //获取企业域列表    
    enterpriseDomainList: function ({ onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/domains?accessToken=" + accessToken,
            method: 'GET',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //获取企业域信息
    getEnterpriseDomain: function (domainId, { onSucess, onError }) {
        axios({
            url: contextPath + "/portal/domains/" + domainId + "?accessToken=" + accessToken,
            method: 'GET',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //获取自由流程可回退用户
    //runtime/{applicationId}/workflows/{instanceId}/hisActorsFreeFlow
    getHisActorsFreeFlow: function (appId, instanceId, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + appId + "/workflows/" + instanceId + "/hisActorsFreeFlow?accessToken=" + accessToken,
            method: 'GET',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },
    getWidgetsIscript: function (id, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/widgets/" + id + "?accessToken=" + accessToken,
            method: 'GET',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },
    getCustomreports: function (id, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/report/showjrxml/" + id + "?accessToken=" + accessToken,
            method: 'POST',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },
    getChart: function (id, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/chart/" + id + "?accessToken=" + accessToken,
            method: 'post',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },
    //流程处理中获取头像
    //http://localhost:8081/obpm/contacts/contacts/getAvatar.action?id=GShxHeYbLQQ3d4Vy58b
    getAvatar: function (id, { onSucess, onError }) { //H5的接口
        axios({
            url: contextPath + "/contacts/contacts/getAvatar.action?id=" + id + '&accessToken=' + accessToken,
            method: 'put',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },
    uploadWeixinRecord: function (serverId, { onSucess, onError }) {
        axios.get(contextPath + "/portal/weixin/jsapi/upload.action?serverId=" + serverId + '&folder=voice' + '&fileType=amr' + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    uploadWeixinPhoto: function (serverId, { onSucess, onError }) {
        axios.get(contextPath + "/portal/weixin/jsapi/upload.action?serverId=" + serverId + '&folder=photo' + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    //contextPath+"/attendance/attendance/convertGps2Baidu.action",{"from":"0","x":longitude,"y":latitude
    getExactCoordinates: function (data, { onSucess, onError }) {
        axios({
            url: contextPath + "/attendance/attendance/convertGps2Baidu.action?accessToken=" + accessToken,
            method: 'POST',
            data: JSON.stringify(data),
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },
    //二维码执行回调脚本
    getQrcodeResult: function (path, { onSucess, onError }) {
        let newPath = path + '&accessToken=' + accessToken
        axios.get(newPath).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    //表单控件校验
    ///runtime/{applicationId}/documents/validate
    formValidation: function (appId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/validate?accessToken=' + accessToken,
            method: 'post',
            data: docJson,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    //消息管理-工作事项-流程
    //http://localhost:8081/obpm/message/notice?readStatus=&type=0&_=1588744575393
    getNotice: function (data, { onSucess, onError }) {
        axios({
            url: contextPath + "/message/notice?accessToken=" + accessToken,
            method: "get",
            params: data,
        })
            .then(function (response) {
                if (onSucess) onSucess(response);
            }).catch(function (error) {
                if (onError) onError(error);
            })
    },

    //http://localhost:8081/obpm/runtime/sOZu9kthmxyP8qQfq0e/flowcenters/carboncopy?title=&flowId=&initiatorId=&isRead=true&isMyWorkFlow=false&appId=sOZu9kthmxyP8qQfq0e&_=1594187825052
    getCarboncopyList: function (appId, jsonData, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + appId + "/flowcenters/carboncopy?accessToken=" + accessToken,
            method: 'get',
            params: jsonData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //http://localhost:8081/obpm/runtime/sOZu9kthmxyP8qQfq0e/documents/__Z0PpxFvbKPAbqaFytJ0/htmlsignature
    saveHTMLsignature: function (appId, docId, jsonData, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/htmlsignature?accessToken=' + accessToken,
            method: 'post',
            data: jsonData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    //http://localhost:8081/obpm/runtime/sOZu9kthmxyP8qQfq0e/documents/__7HJy8rmhSNErVJGc50I/htmlsignature
    getHTMLsignature: function (appId, docId, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/htmlsignature?accessToken=' + accessToken,
            method: 'get',
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    getPDFsignature: function (appId, docId, jsonData, { onSucess, onError }) {
        axios({
            url: contextPath + '/runtime/' + appId + '/documents/' + docId + '/htmlsignature',
            method: 'put',
            data: jsonData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },
    getAxecuteAddress: function (appId, actId, jsonData, ids, docId, data, { onSucess, onError }) {
        if (!data) {
            data = { "document": {} };
        }
        let exparamsStr = "";
        if (jsonData) {
            for (let key in jsonData) {
                exparamsStr += "&" + key + "=" + jsonData[key];
            }
        }
        exparamsStr = encodeURI(exparamsStr);
        axios({
            url: contextPath + "/runtime/" + appId + "/activities/" + actId + "/executeAddress?docId=" + (docId ? docId : "") + (ids ? ("&" + ids) : "") + exparamsStr,
            method: 'put',
            // params: jsonData,
            data: JSON.stringify(data),
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //http://localhost:8081/obpm/runtime/sOZu9kthmxyP8qQfq0e/documents/__opoTZwulSeXZWLZLS8x/workflows/__ysKqfrVSG6an4sFCsFL/selectCirculators?nodeId=1584946784147&type=0&selectId=&pageNum=1&pageSize=10&newTime=1608607058813&_=1608607058320
    selectCirculators: function (appId, docId, flowId, nodeId, jsonData, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + appId + "/documents/" + docId + "/workflows/" + flowId + "/selectCirculators?nodeId=" + nodeId + '&accessToken=' + accessToken,
            method: 'GET',
            params: jsonData,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    getProcessedListWithWidget: function (pageNo, linesPerPage, workflowOrder, { onSucess, onError }) {
        var _pageNo = pageNo ? pageNo : 1;
        var _linesPerPage = linesPerPage ? linesPerPage : 2147483646;
        axios.get(contextPath + '/runtime/widget/myProcessing?pageNo=' + _pageNo + '&linesPerPage=' + _linesPerPage + '&workflowOrder=' + workflowOrder + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    getPendingListWithWidget: function (pageNo, linesPerPage, workflowOrder, { onSucess, onError }) {
        var _pageNo = pageNo ? pageNo : 1;
        var _linesPerPage = linesPerPage ? linesPerPage : 2147483646;
        axios.get(contextPath + '/runtime/widget/myPending?pageNo=' + _pageNo + '&linesPerPage=' + _linesPerPage + '&workflowOrder=' + workflowOrder + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    previewWaterMark: function (jsonData, { onSucess, onError }) {
        axios({
            headers: { 'Content-type': 'application/x-www-form-urlencoded' },
            url: "/obpm/portal/dynaform/document/previewWaterMark?waterMarkSetting=" + encodeURI(JSON.stringify(jsonData)), //+ decodeURI(JSON.stringify(jsonData)),
            method: 'get',
            // params:  decodeURIComponent(jsonData),
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(function (error) {
            if (onError) onError(error);
        })
    },

    //流程提交时获取指定显示的用户
    //http://localhost:8081/obpm/runtime/sOZu9kthmxyP8qQfq0e/documents/__xKeJfciUqTLp7o96vVY/workflows/fW1801qkQ6PsAcfxuI2/selectApprovers?nodeId=1566350840526&type=2&selectId=fBUXdkAlWTdGXqOq4cI
    getSelectApprovers: function (appId, docId, flowId, nodeId, type, selectId, pageNum, pageSize, { onSucess, onError }) {
        axios.get(contextPath + "/runtime/" + appId + "/documents/" + docId + "/workflows/" + flowId + "/selectApprovers?nodeId=" + nodeId + "&type=" + type + "&selectId=" + selectId + "&pageNum=" + pageNum + "&pageSize=" + pageSize + '&accessToken=' + accessToken).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },
    getKmsFiles: function (jsonData, { onSucess, onError }) {
        let url = "";
        if (statiContextPath) {
            url = "kms/api/kms/files/data";
        } else {
            url = kmsPath + "kms/kms/files/data";
        }
        axios.get(url, { params: jsonData }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    getPanelsInitiate: function (applicationId, docId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/documents/" + docId + "/panels/initiate?accessToken=" + accessToken,
            method: 'post',
            data: docJson,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    /**
     * 发起流程
     */
    InitiateWorkFlow: function (applicationId, docId, docJson, { onSucess, onError }) {
        axios({
            url: contextPath + "/runtime/" + applicationId + "/documents/" + docId + "/workflows/initiate",//?accessToken=" + accessToken,
            method: 'post',
            data: docJson,
        }).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },

    downloadWaterMarkFile: function (waterMarkSetting, name, path, { onSucess, onError }) {
        let url;
        if (statiContextPath) {
            url = kmsPath + "kms/api/portal/dynaform/document/previewWaterMark?waterMarkSetting=" + encodeURI(waterMarkSetting);
        } else {
            url = contextPath + "/portal/dynaform/document/previewWaterMark?waterMarkSetting=" + encodeURI(waterMarkSetting)
        }

        axios.get(url).then(function (response) {
            if (onSucess) onSucess(response);
        }).catch(
            function (error) {
                if (onError) onError(error);
            }
        );
    },


};

