Message.Service = {
	/**
	 * 发布动态
	 */
	saveMessage : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/messages",
    		async: false,
    		cache:false,
    		type:"POST",
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 发布公告
	 */
	saveAnnouncement : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/messages/announcement",
    		async: false,
    		cache:false,
    		type:"POST",
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 获取列表
	 */
	getMessageList : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/messages/list",
    		type:"GET",
    		async: false,
    		cache:false,
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 获取公告列表
	 */
	getAnnouncementList : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/messages/announcement",
    		type:"GET",
    		async: false,
    		cache:false,
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 获取单条消息内容
	 * messageId
	 */
	getMessage : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/messages",
    		type:"GET",
    		async: false,
    		cache:false,
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 获取附件地址
	 */
	getAttachementUrl : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/messages/attachement/preview",
    		type:"GET",
    		async: false,
    		cache:false,
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 获取评论列表
	 */
	getCommentList : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/comment",
    		async: false,
    		cache:false,
    		type:"GET",
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},	
	/**
	 * 发布评论
	 */
	saveComment : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/comment",
    		async: false,
    		cache:false,
    		type:"POST",
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 删除消息
	 */
	delectMessage : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/messages?messageId="+params.messageId,
    		async: false,
    		cache:false,
    		type:"DELETE",
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 删除评论
	 */
	delectComment : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/comment?commentId="+params.commentId+"&messageId="+params.messageId,
    		async: false,
    		cache:false,
    		type:"DELETE",
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 获取事项列表
	 */
	getRemindList : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/notice",
    		async: false,
    		cache:false,
    		type:"GET",
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 获取事项未读数量
	 */
	getNotificationCount : function(callback){
		$.ajax({
    		url: messageContextPath + "/api/message/notification/count",
    		cache:false,
    		type:"GET",
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	
	
	/**
	 * 获取我回复的列表
	 */
	getIReplyList : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/comment/my/reply",
    		async: false,
    		cache:false,
    		type:"GET",
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 获取回复我的列表
	 */
	getIReceiveList : function(params,callback){
		$.ajax({
			url: messageContextPath + "/api/message/comment/my/receive",
    		async: false,
    		cache:false,
    		type:"GET",
			data:params,
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 设置已读
	 * id
	 */
	setRead : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/notice/read?noticeId="+params.ids,
    		type:"PUT",
			success: function(result){
    			if(1==result.status){
    				if(callback && typeof callback == "function"){
						callback();
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 设置所有消息为已读
	 * id
	 */
	markAllAsRead : function(callback){
		$.ajax({
    		url: messageContextPath + "/api/message/notice/allRead",
    		type:"PUT",
			success: function(result){
    			if(1==result.status){
    				if(callback && typeof callback == "function"){
						callback();
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	},
	/**
	 * 删除事项列表
	 */
	deleteRemindItem : function(params,callback){
		$.ajax({
    		url: messageContextPath + "/api/message/notice?noticeId="+params.noticeId,
    		async: false,
    		cache:false,
    		type:"DELETE",
			success: function(result){
    			if(1==result.status){
					if(callback && typeof callback == "function"){
						callback(result.data);
					}
				}else{
					OBPM.message.showError(result.message);
				}
    		}
    	})
	}
}