import Login from './components/Login/Login.vue'
import ChangePassword from './components/ChangePassword/ChangePassword.vue'
import MemberList from './components/MemberList/MemberList.vue'
import MemberRecharge from './components/MemberRecharge/MemberRecharge.vue'
import MemberRechargeHistory from './components/MemberRechargeHistory/MemberRechargeHistory.vue'

import Vue from 'vue'
import Router from 'vue-router'
import Main from './views/Main.vue'
import Home from './views/Home.vue'
//import printView from './components/print_view.vue'
// import Personal from './components/Personal.vue'
import {getCookie} from './utils'

Vue.use(Router)
const routes = [
  {
    path: '/login',
    name: 'login',
    component: Login
  },
  {
    path: '/',
    component: Home,
    name: '',
    leaf: true, //只有一个节点
    iconCls: 'el-icon-menu', //图标样式class
    children: [{
        path: '/changePassword',
        component: ChangePassword,
        name: '修改密码'
      },
      {
        path: '/memberList',
        component: MemberList,
        name: '会员列表'
      },
      {
        path: '/memberRecharge',
        component: MemberRecharge,
        name: '会员充值'
      },
      {
        path: '/memberRechargeHistory',
        component: MemberRechargeHistory,
        name: '会员充值历史'
      },

    ]
  },
  {
    path: '/main',
    name: 'main',
    component: Main
  },
  {
    path: '/about',
    name: 'about',
    component: () => import( /* webpackChunkName: "about" */ './views/About.vue')
  },
]
const router = new Router({
  mode: "hash",
  base: process.env.BASE_URL,
  routes,
});
// 路由拦截
// router.beforeEach((to, from, next) => {
//   // 如果用户访问的登录页，直接放行
//   if (to.path === "/login") return next();
//   // 如果用户访问的后台管理页面，需要先判断是否有token
//   const tokenStr = getCookie("accessToken");
//   if (!tokenStr) return next("/login");
//   next();
// });
export default router;