import Login from './components/Login/Login.vue'
import MsgHistory from './components/MsgHistory/MsgHistory.vue'
import MsgSend from './components/MsgSend/MsgSend.vue'
import MyProfile from './components/MyProfile/MyProfile.vue'
import MyRechargeHistory from './components/MyRechargeHistory/MyRechargeHistory.vue'

import Vue from 'vue'
import Router from 'vue-router'
import Home from './views/Home.vue'

Vue.use(Router)
const routes = [
  {
    path: '/login',
    name: 'login',
    component: Login
  },
  {
    path: '/',
    component: Home,
    name: '',
    leaf: true, //只有一个节点
    iconCls: 'el-icon-menu', //图标样式class
    children: [{
        path: '/MsgHistory',
        component: MsgHistory,
        name: '短信发送历史'
      },
      {
        path: '/MsgSend',
        component: MsgSend,
        name: '短信发送'
      },
      {
        path: '/MyProfile',
        component: MyProfile,
        name: '我的资料'
      },
      {
        path: '/MyRechargeHistory',
        component: MyRechargeHistory,
        name: '我的充值历史'
      },
    ]
  },
]
const router = new Router({
  mode: "hash",
  base: process.env.BASE_URL,
  routes,
});
// 路由拦截
// router.beforeEach((to, from, next) => {
//   // 如果用户访问的登录页，直接放行
//   if (to.path === "/login") return next();
//   // 如果用户访问的后台管理页面，需要先判断是否有token
//   const tokenStr = getCookie("accessToken");
//   if (!tokenStr) return next("/login");
//   next();
// });
export default router;