import Vue from 'vue'
import Vuex from 'vuex'
import API from "@/api.js"

Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    domainId:'',
    userId:'',
    myProfile:'',
  },

  getters: {

  },

  mutations: {
    landingUser(state, data){
      state.domainId = data.doId;
      state.userId = data.userId;
      state.myProfile = data.profile;
    },
  },

  actions: {
    //当前登陆的用户
    landingUser(context) {
      API.getMyProfile(
        {
          onSucess: response => {
            let doId = response.data.data.domainId;
            let userId = response.data.data.id;
            let profile = response.data.data;
            context.commit('landingUser', {doId, userId, profile});
          } 
        }
      )
    },
  }
})
