package com.teemlink.run;

import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@SpringBootApplication
@ComponentScan(basePackages = { "cn.myapps.common.util","com.teemlink.conf", "com.teemlink.km.**.controller",
		"cn.myapps.authtime.**.controller","cn.myapps.authtime.common.dao","cn.myapps.runtime.**.dao",
		"com.teemlink.km.**.service", "com.teemlink.km.search.engine","com.teemlink.km.monitorconver.**","com.teemlink.km.**.dao", "cn.myapps.common.dao","com.teemlink.login" })
@EnableJpaRepositories("com.teemlink.login.dao")
@EntityScan("com.teemlink.login.model")
@EnableFeignClients(basePackages = {"com.teemlink.conf","com.teemlink.km.common.service"})
//@EnableRedisHttpSession
public class KmsAppWithNacos {

	public static void main(String[] args) {
		new SpringApplicationBuilder(KmsAppWithNacos.class).run(args);
	}

}
