import axios from "axios";
import Constant from "@/Constant.js";
// import { get } from 'core-js/fn/dict';
const contextPath = Constant.contextPath;
const obpmPath = Constant.obpmPath;

export default {
  /**
   * 登录
   */
  login: (jsonData, { onSucess, onError }) => {
    axios({
      url: contextPath + "/email/userLogin",
      method: "post",
      data: jsonData,
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 获取邮箱文件夹列表
   */
  getFolderList: ({ onSucess, onError }) => {
    axios({
      url: contextPath + "/email/getFolderList",
      method: "get",
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 获取邮件列表
   */
  getFolderEmails: (data, { onSucess, onError }) => {
    axios({
      url: contextPath + "/email/getFolderEmails",
      method: "get",
      params: data,
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 删除邮件
   */
  removeEmails: (folderId, emailsId, { onSucess, onError }) => {
    axios({
      url: contextPath + "/email/removeEmail?folderId=" + folderId,
      method: "delete",
      data: emailsId,
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 彻底删除邮件
   */
  deleteEmails: (folderId, emailsId, { onSucess, onError }) => {
    axios({
      url: contextPath + `/email/deleteEmail?folderId=${folderId}`,
      method: "delete",
      data: emailsId,
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 标记邮件(已读、未读)
   */
  markEmail: (folderId, markType, jsonData, { onSucess, onError }) => {
    axios({
      url: contextPath + "/email/markEmail?folderId=" + folderId + "&mark=" + markType,
      method: "post",
      data: jsonData,
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 获取邮件详情
   */
  getEmailDetail: (folderId, emailId, { onSucess, onError }) => {
    axios({
      url: contextPath + `/email/getEmail?folderId=${folderId}&emailId=${emailId}`,
      method: "get",
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 下载邮件附件
   */
  downloadFile: (folderId, emailId, fileName, { onSucess, onError }) => {
    axios({
      url: contextPath + `/email/downloadAttachment?folderId=${folderId}&emailId=${emailId}&fileName=${fileName}`,
      method: "post",
      responseType: "blob",
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 删除邮件附件
   */
  deleteFile: (id, { onSucess, onError }) => {
    axios({
      url: contextPath + `/email/removeAttachment?id=${id}`,
      method: "delete",
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 获取邮箱后缀
   */
  getEmailSuffix: ({ onSucess, onError }) => {
    axios({
      url: contextPath + "/email/getEmailSuffix",
      method: "get",
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 发送邮件
   */
  sendEmail: (folderId, data, { onSucess, onError }) => {
    axios({
      url: contextPath + `/email/sendEmail?folderId=${folderId}`,
      method: "post",
      data: data,
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 获取以部门为树形结构的用户集合
   *
   */
  getDeptUser: (applicationId, deptId, pageNum = 1, pageSize = 10, { onSucess, onError }) => {
    axios({
      url: obpmPath + `/runtime/${applicationId}/departments/selectbox/user?isFromMail=true&deptId=${deptId}&pageSize=${pageSize}&pageNum=${pageNum}`,
      method: "get",
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },
  /**
   * 获取以角色为树形结构的用户集合
   */
  getRoleUser: (applicationId, params, { onSucess, onError }) => {
    //sOZu9kthmxyP8qQfq0e
    axios({
      url: obpmPath + `/runtime/${applicationId}/users/selectbox/role?roleId=${params.roleId}&pageSize=${params.pageSize}&pageNum=${params.pageNum}&type=${params.type}`,
      method: "get",
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },

  /**
   * 获取通讯录用户集
   */
  getContactUser: (contactsId, params, { onSucess, onError }) => {
    axios({
      url: obpmPath + `/obpm/users/selectbox/contacts?isFromMail=true&contactsId=${contactsId}&pageSize=${params.pageSize}&pageNum=${params.pageNum}`,
      method: "get",
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },
  /**
   * 模糊查询用户
   */
  searchUser: (keyWord, params, { onSucess, onError }) => {
    axios({
      url: obpmPath + `/runtime/users/selectbox/search?isFromMail=true&keyWord=${keyWord}&pageNum=${params.pageNum}&pageSize=${params.pageSize}`,
      method: "get",
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },
  /**
   * 根据父级获取部门集合
   */
  getDepartmentsByParentId: function(params, { onSucess, onError }) {
    axios({
      url: obpmPath + `/runtime/${params.applicationId}/departments/selectbox/childs?parentId=${params.parentId}`,
      method: "get",
    })
      .then((response) => {
        if (onSucess) onSucess(response);
      })
      .catch((error) => {
        if (onError) onError(error);
      });
  },
};
