package cn.myapps.macro.controller;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;

@RestController
public class MacroController2 {

    @Autowired
    private HttpServletRequest request;


    @GetMapping("/api/macro/runtime/war/debug/url")
    public Map getServiceRuntimeUrl(){

        String path = PropertyUtil.getPath();
        Map<String,String> maps = new HashMap<>();
        String realPath = request.getSession().getServletContext().getRealPath("/");

        File designerFile = new File(realPath);
        File webappFile = designerFile.getParentFile();
        File[] oneFiles = webappFile.listFiles();
        String runtimeContext = "";
        outterLoop :for(File oneFile:oneFiles){
            //判断里面的一级目录
            File[] twoFiles = oneFile.listFiles();
            if(oneFile.isDirectory()){
                for(File twoFile:twoFiles){
                    String fileName = twoFile.getName();
                    if(fileName.equals("portal")){
                        runtimeContext = oneFile.getName();
                        break outterLoop;
                    }
                }
            }
        }

        String url = runtimeContext+"/macro/debug.html";
        if(StringUtil.isBlank(runtimeContext)){
            url="";
        }
        maps.put("status","ok");
        maps.put("url",url);
        return maps;
    }

}
