/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util.cache;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.ICacheProvider;
import cn.myapps.common.util.cache.IMyCache;
import cn.myapps.common.util.cache.IMyElement;
import cn.myapps.common.util.cache.MyCacheManager;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MemoryCacheUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryCacheUtil.class);

    public static void clearPrivateSpace(IUser user) {
        if (user != null && !StringUtil.isBlank(user.getId())) {
            MemoryCacheUtil.clearPrivateSpace(user.getId());
        }
    }

    public static void clearPrivateSpace(String userId) {
        if (StringUtils.hasLength((String)userId)) {
            try {
                ICacheProvider provider = MyCacheManager.getProviderInstance("cn.myapps.util.cache.RedisProvider");
                String cacheName = "USERSPACE$" + userId;
                IMyCache cache = provider.getCache(cacheName);
                if (cache != null) {
                    cache.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void putToPrivateSpace(Object key, Object o, IUser user) {
        if (user != null && !StringUtil.isBlank(user.getSessionid())) {
            try {
                ICacheProvider provider = MyCacheManager.getProviderInstance("cn.myapps.util.cache.RedisProvider");
                String cacheName = "USERSPACE$" + user.getId();
                IMyCache cache = provider.getCache(cacheName);
                if (cache == null) {
                    cache = provider.createCache(cacheName, 50000, false, false, 43200L, 43200L);
                }
                cache.put(key, o);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.debug("putToPrivateSpace(ClassName=" + o.getClass().getSimpleName() + ",Key=" + key.toString() + ",Object=" + o.toString() + ")");
            }
        }
    }

    public static Object getFromPrivateSpace(Object key, IUser user) {
        if (user != null && !StringUtil.isBlank(user.getSessionid())) {
            try {
                IMyElement cachedElement;
                ICacheProvider provider = MyCacheManager.getProviderInstance("cn.myapps.util.cache.RedisProvider");
                String cacheName = "USERSPACE$" + user.getId();
                IMyCache cache = provider.getCache(cacheName);
                if (cache != null && (cachedElement = cache.get(key)) != null) {
                    return cachedElement.getValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.debug("getFromPrivateSpace(ClassName=" + user.getClass().getSimpleName() + ",Key=" + key.toString() + ",Object=" + user.toString() + ")");
            }
        }
        return null;
    }

    public static void removeFromPrivateSpace(Object key, IUser user) {
        if (user != null && !StringUtil.isBlank(user.getSessionid())) {
            try {
                ICacheProvider provider = MyCacheManager.getProviderInstance("cn.myapps.util.cache.RedisProvider");
                Set keys = provider.getKeys("USERSPACE$*" + key);
                for (String cName : keys) {
                    provider.remove(cName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.debug("removeFromPrivateSpace(ClassName=" + user.getClass().getSimpleName() + ",Key=" + key.toString() + ",Object=" + user.toString() + ")");
            }
        }
    }
}

