/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util.cache;

import cn.myapps.common.util.cache.ICacheProvider;
import cn.myapps.common.util.cache.IMyCache;
import cn.myapps.common.util.cache.IMyElement;
import cn.myapps.common.util.cache.MethodCacheCleaner;
import java.util.HashMap;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class EhcacheProvider
implements ICacheProvider {
    CacheManager manager = CacheManager.create();
    HashMap<String, MethodCacheCleaner> clearedNames = new HashMap();

    @Override
    public IMyCache createCache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) {
        Cache ehcache = new Cache(name, maxElementsInMemory, overflowToDisk, eternal, timeToLiveSeconds, timeToIdleSeconds);
        if (!this.manager.cacheExists(ehcache.getName())) {
            this.manager.addCacheIfAbsent((Ehcache)ehcache);
        }
        MyCache mycache = new MyCache(ehcache);
        return mycache;
    }

    @Override
    public IMyCache getDefaultCache() {
        return this.getCache("DEFAULT_CACHE");
    }

    @Override
    public IMyCache getCache(String name) {
        Cache c = this.manager.getCache(name);
        if (c != null) {
            MyCache mycache = new MyCache(c);
            return mycache;
        }
        return null;
    }

    @Override
    public void remove(String key) {
        Cache cache = this.manager.getCache(key);
        if (cache != null) {
            try {
                cache.removeAll();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (CacheException e) {
                e.printStackTrace();
            }
        }
    }

    public void destory() {
        if (this.manager != null) {
            this.manager.shutdown();
            this.manager = null;
        }
    }

    @Override
    public void clearCache(String name) {
        Cache cache = this.manager.getCache(name);
        if (cache != null) {
            try {
                cache.removeAll();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (CacheException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String[] getCacheNames() {
        return this.manager.getCacheNames();
    }

    @Override
    public String[] getClearedNames() {
        return this.clearedNames.keySet().toArray(new String[this.clearedNames.keySet().size()]);
    }

    @Override
    public Set getKeys(String cacheName) {
        return null;
    }

    public void clearAll() {
        String[] cacheNames = this.getCacheNames();
        for (int i = 0; i < cacheNames.length; ++i) {
            String name = cacheNames[i];
            this.clearCache(cacheNames[i]);
        }
    }

    @Override
    public boolean clearByCacheName(String cacheName) {
        MethodCacheCleaner cleaner = this.clearedNames.get(cacheName);
        if (cleaner != null && cleaner.isClearAll()) {
            this.clearAll();
            return true;
        }
        return false;
    }

    @Override
    public void setClearedNames(HashMap<String, MethodCacheCleaner> clearedNames) {
        this.clearedNames = clearedNames;
    }

    static class MyElement
    implements IMyElement {
        Element element;

        MyElement(Element element) {
            this.element = element;
        }

        MyElement(Object key, Object value) {
            this.element = new Element(key, value);
        }

        public Element getElement() {
            return this.element;
        }

        @Override
        public Object getValue() {
            return this.element.getObjectValue();
        }

        @Override
        public Object getKey() {
            return this.element.getObjectKey();
        }
    }

    static class MyCache
    implements IMyCache {
        Cache cache;

        MyCache(Cache cache) {
            this.cache = cache;
        }

        @Override
        public IMyElement get(Object key) {
            if (key == null) {
                return null;
            }
            Element element = this.cache.get(key);
            if (element == null) {
                return null;
            }
            return new MyElement(element);
        }

        @Override
        public void put(IMyElement element) {
            Element em = ((MyElement)element).getElement();
            this.cache.put(em);
        }

        @Override
        public void put(Object key, Object value) {
            MyElement element = new MyElement(key, value);
            this.put(element);
        }

        @Override
        public void remove(Object key) {
            this.cache.remove(key);
        }

        @Override
        public void clear() {
            this.cache.removeAll();
        }
    }
}

