/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util.cache;

import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.cache.MethodCacheCleaner;
import cn.myapps.common.util.cache.MethodCacheConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class CacheConfig {
    public static CacheConfig _application;
    private String providerClassName;
    private HashMap<String, MethodCacheConfig> methodCacheConfigs = new HashMap();
    private HashMap<String, MethodCacheCleaner> methodCleaners = new HashMap();

    public static CacheConfig getInstance() throws IOException {
        if (_application == null) {
            _application = CacheConfig.createCacheConfig();
        }
        return _application;
    }

    public static void main(String[] args) {
        try {
            CacheConfig.createCacheConfig();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CacheConfig createCacheConfig() throws IOException {
        String key;
        CacheConfig cconf = new CacheConfig();
        Properties prop = new Properties();
        Properties clearProp = new Properties();
        prop = PropertyUtil.getProp("myapps-cache");
        clearProp = PropertyUtil.getProp("myapps-cache-clear");
        cconf.setProviderClassName(prop.getProperty("providerClassName"));
        Enumeration<Object> enum1s = prop.keys();
        while (enum1s.hasMoreElements()) {
            key = (String)enum1s.nextElement();
            if (key.equals("providerClassName")) continue;
            MethodCacheConfig methodcache = new MethodCacheConfig();
            methodcache.signature = key;
            String[] tmp = prop.getProperty(key).split(",");
            methodcache.maxElementsInMemory = Integer.parseInt(tmp[0]);
            methodcache.timeToLiveSeconds = Integer.parseInt(tmp[1]);
            methodcache.timeToIdleSeconds = Integer.parseInt(tmp[2]);
            cconf.getMethodCacheConfigs().put(key, methodcache);
        }
        enum1s = clearProp.keys();
        while (enum1s.hasMoreElements()) {
            key = (String)enum1s.nextElement();
            MethodCacheCleaner cleaner = new MethodCacheCleaner();
            String value = (String)clearProp.get(key);
            if (value.equalsIgnoreCase("All")) {
                cleaner.setClearAll(true);
            }
            cconf.getMethodCleaners().put(key, cleaner);
        }
        return cconf;
    }

    private CacheConfig() {
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public void setProviderClassName(String providerClassName) {
        this.providerClassName = providerClassName;
    }

    public HashMap<String, MethodCacheConfig> getMethodCacheConfigs() {
        return this.methodCacheConfigs;
    }

    public void setMethodCacheConfigs(HashMap<String, MethodCacheConfig> methodNames) {
        this.methodCacheConfigs = methodNames;
    }

    public HashMap<String, MethodCacheCleaner> getMethodCleaners() {
        return this.methodCleaners;
    }

    public void setMethodCleaners(HashMap<String, MethodCacheCleaner> methodCleaners) {
        this.methodCleaners = methodCleaners;
    }
}

