/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class SiteIdGenerator {
    public static synchronized String getMACAddress() {
        try {
            StringBuffer sb = new StringBuffer();
            byte[] mac = SiteIdGenerator.getHardwareAddress(false, false);
            if (mac.length <= 1) {
                mac = SiteIdGenerator.getHardwareAddress(false, true);
            }
            if (mac.length <= 1) {
                mac = SiteIdGenerator.getHardwareAddress(true, false);
            }
            if (mac.length <= 1) {
                mac = SiteIdGenerator.getHardwareAddress(true, true);
            }
            for (int i = 0; i < mac.length; ++i) {
                int n = mac[i] & 0xFF00 | mac[i++] & 0xFF;
                String s = Integer.toString(n, 35);
                sb.append(s);
            }
            return "Z" + sb.toString().toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] getHardwareAddress(boolean includeSoftEther, boolean abs) throws Exception {
        byte[] mac = new byte[]{0};
        InetAddress ia = null;
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> nii = ni.getInetAddresses();
            while (nii.hasMoreElements()) {
                byte[] tempMac;
                ia = nii.nextElement();
                NetworkInterface nf = NetworkInterface.getByInetAddress(ia);
                if (nf == null || nf.getDisplayName() == null || !includeSoftEther && (nf.getDisplayName().indexOf("VMware") != -1 || nf.getDisplayName().indexOf("Microsoft") != -1) || nf.isVirtual() || nf.isLoopback() || nf.isPointToPoint() || (tempMac = nf.getHardwareAddress()) == null) continue;
                if (abs) {
                    if (new BigInteger(tempMac).abs().compareTo(new BigInteger(mac).abs()) < 0) continue;
                    mac = tempMac;
                    continue;
                }
                if (new BigInteger(tempMac).compareTo(new BigInteger(mac)) < 0) continue;
                mac = tempMac;
            }
        }
        return mac;
    }
}

