/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util;

import cn.myapps.common.util.DefaultProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertyUtil {
    private static Map<String, Properties> settings = new HashMap<String, Properties>();
    private static Boolean _isNetworkEnvironment = null;

    public static String getPath() {
        String path = DefaultProperty.getProperty("myapps.storage.root");
        return path;
    }

    private static synchronized void load(String name) {
        if (!PropertyUtil.isLoaded(name)) {
            Properties props = new Properties();
            URL propsUrl = null;
            try {
                String path = PropertyUtil.getPath();
                propsUrl = new URL("file", null, path + "/" + name + ".properties");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (propsUrl == null) {
                throw new IllegalStateException(name + ".properties missing");
            }
            try (InputStream stream = propsUrl.openStream();){
                props.load(new InputStreamReader(stream, "UTF-8"));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load " + name + ".properties:" + e);
            }
            settings.put(name, props);
        }
    }

    public static void init() {
        if (settings == null || settings.isEmpty()) {
            PropertyUtil.load("notification");
            PropertyUtil.load("security");
            PropertyUtil.load("sso");
            PropertyUtil.load("email");
            PropertyUtil.load("myapp");
            PropertyUtil.load("ftp");
            PropertyUtil.load("skin");
        }
    }

    public static String get(String key) {
        return PropertyUtil.get(key, null);
    }

    public static boolean getBoolean(String key) {
        String rtn = PropertyUtil.get(key, null);
        if (rtn != null) {
            return Boolean.getBoolean(rtn);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getProp(String name) {
        URL propsUrl = null;
        try {
            String path = PropertyUtil.getPath();
            propsUrl = new URL("file", null, path + "/" + name + ".properties");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (propsUrl == null) {
            throw new IllegalStateException(name + ".properties missing");
        }
        try (InputStream stream = propsUrl.openStream();){
            Properties props = new Properties();
            props.load(new InputStreamReader(stream, "UTF-8"));
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + name + ".properties:" + e);
        }
    }

    public static String get(String key, String defaultValue) {
        if (settings == null || settings.isEmpty()) {
            PropertyUtil.init();
        }
        if (settings != null) {
            for (String propName : settings.keySet()) {
                Properties props = settings.get(propName);
                String value = props.getProperty(key, defaultValue);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public static String getByPropName(String propName, String key) {
        if (settings == null || settings.isEmpty()) {
            PropertyUtil.init();
        }
        if (settings != null && settings.get(propName) != null) {
            return settings.get(propName).getProperty(key);
        }
        return null;
    }

    public static void clear() {
        settings.clear();
    }

    public static void reload() {
        HashSet<String> tempNames = new HashSet<String>();
        tempNames.addAll(settings.keySet());
        settings.clear();
        for (String name : tempNames) {
            PropertyUtil.load(name);
        }
    }

    public static void reload(String propKey) {
        PropertyUtil.load(propKey);
    }

    public static Map<String, String> toMap() {
        HashMap<String, String> rtn = new HashMap<String, String>();
        Iterator<String> iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            Properties properties = settings.get(iterator.next());
            for (String string : properties.keySet()) {
                String value = properties.getProperty(string);
                rtn.put(string, value);
            }
        }
        return rtn;
    }

    private static boolean isLoaded(String name) {
        return settings.keySet().contains(name);
    }

    public static boolean IsNetworkEnvironment() {
        if (_isNetworkEnvironment == null) {
            _isNetworkEnvironment = "network".equalsIgnoreCase(PropertyUtil.get("myapps.environment"));
        }
        return _isNetworkEnvironment;
    }
}

