/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util;

import cn.myapps.common.model.table.Column;
import cn.myapps.common.model.table.Table;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DbUtil {
    public static final String DBTYPE_ORACLE = "ORACLE";
    public static final String DBTYPE_MSSQL = "MSSQL";
    public static final String DBTYPE_MYSQL = "MYSQL";
    public static final String DBTYPE_HSQLDB = "HSQLDB";
    public static final String DBTYPE_DB2 = "DB2";
    public static final String DBTYPE_POSTGRESQL = "POSTGRESQL";
    public static final String DBTYPE_DM = "DM";
    public static final String DBTYPE_KINGBASE = "KINGBASE";
    public static HashMap<String, String> _dbTypes = new HashMap();

    public static String getDBType(Connection conn) throws SQLException {
        String productName = conn.getMetaData().getDatabaseProductName().toUpperCase();
        if (productName.indexOf(DBTYPE_MYSQL) != -1) {
            return DBTYPE_MYSQL;
        }
        if (productName.indexOf("SQL SERVER") != -1) {
            return DBTYPE_MSSQL;
        }
        if (productName.indexOf(DBTYPE_ORACLE) != -1) {
            return DBTYPE_ORACLE;
        }
        if (productName.indexOf(DBTYPE_DB2) != -1) {
            return DBTYPE_DB2;
        }
        if (productName.indexOf(DBTYPE_POSTGRESQL) != -1) {
            return DBTYPE_POSTGRESQL;
        }
        if (productName.indexOf(DBTYPE_DM) != -1) {
            return DBTYPE_DM;
        }
        if (productName.indexOf("KINGBASEES") != -1) {
            return DBTYPE_KINGBASE;
        }
        return "-1";
    }

    public static String getSchema(Connection conn, String dbType) {
        if (dbType.equals(DBTYPE_ORACLE) || dbType.equals(DBTYPE_DB2) || dbType.equals(DBTYPE_DM)) {
            try {
                return conn.getMetaData().getUserName().trim().toUpperCase();
            }
            catch (SQLException sqle) {
                return "";
            }
        }
        if (dbType.equals(DBTYPE_MYSQL)) {
            try {
                return conn.getCatalog();
            }
            catch (SQLException sqle) {
                return "";
            }
        }
        if (dbType.equals(DBTYPE_MSSQL)) {
            return "dbo";
        }
        if (dbType.equals(DBTYPE_HSQLDB)) {
            return "public".toUpperCase();
        }
        if (dbType.equals(DBTYPE_POSTGRESQL)) {
            try {
                String schema = conn.getMetaData().getURL().trim().toUpperCase();
                if (schema.indexOf("CURRENTSCHEMA") > 0) {
                    schema = schema.substring(schema.lastIndexOf("CURRENTSCHEMA") + "CURRENTSCHEMA=".length());
                    schema = schema.toLowerCase();
                    schema = conn.getCatalog() + "." + schema.toLowerCase();
                    return schema;
                }
                schema = conn.getCatalog() + ".public";
                return schema;
            }
            catch (SQLException sqle) {
                return "";
            }
        }
        if (dbType.equals(DBTYPE_KINGBASE)) {
            try {
                return "PUBLIC";
            }
            catch (Exception sqle) {
                return "";
            }
        }
        return "";
    }

    public static Table getTable(String tableName, String dbType, Connection conn) {
        Collection<Table> tables = DbUtil.getTables(tableName, dbType, conn);
        if (tables != null && !tables.isEmpty()) {
            return tables.iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Table> getTables(String tableName, String dbType, Connection conn) {
        ArrayList<Table> rtn = new ArrayList<Table>();
        ResultSet tableSet = null;
        try {
            String catalog = null;
            String schemaPattern = null;
            String schema = DbUtil.getSchema(conn, dbType);
            if (dbType.equals(DBTYPE_ORACLE) || dbType.equals(DBTYPE_DM)) {
                schemaPattern = schema;
            } else if (dbType.equals(DBTYPE_MSSQL)) {
                schemaPattern = "DBO";
                int databaseVersion = conn.getMetaData().getDatabaseMajorVersion();
                if (9 <= databaseVersion) {
                    conn.setTransactionIsolation(1);
                }
            } else if (dbType.equals(DBTYPE_MYSQL)) {
                catalog = schema;
            } else if (dbType.equals(DBTYPE_HSQLDB)) {
                schemaPattern = schema;
            } else if (dbType.equals(DBTYPE_DB2)) {
                schemaPattern = schema;
            } else if (dbType.equals(DBTYPE_POSTGRESQL)) {
                catalog = schema.split("\\.")[0];
                schemaPattern = schema.split("\\.")[1];
            } else if (dbType.equals(DBTYPE_KINGBASE)) {
                catalog = schema;
            }
            DatabaseMetaData metaData = conn.getMetaData();
            tableSet = dbType.equals(DBTYPE_POSTGRESQL) ? metaData.getTables(catalog, schemaPattern, null, new String[]{"TABLE"}) : metaData.getTables(catalog, schemaPattern, tableName, new String[]{"TABLE"});
            boolean isTableNameNotNull = true;
            if (tableName == null) {
                isTableNameNotNull = false;
            }
            while (tableSet.next()) {
                String dbTableName = tableSet.getString(3);
                if (dbType.equals(DBTYPE_POSTGRESQL)) {
                    if (isTableNameNotNull && tableName != null && !tableName.trim().toUpperCase().equals(dbTableName.trim().toUpperCase())) continue;
                    tableName = dbTableName;
                } else {
                    tableName = dbTableName;
                }
                Table table = new Table(tableName.toUpperCase());
                try (ResultSet columnSet = null;){
                    columnSet = metaData.getColumns(catalog, schemaPattern, tableName, null);
                    while (columnSet.next()) {
                        String name = columnSet.getString(4);
                        int typeCode = columnSet.getInt(5);
                        String remarks = columnSet.getString("REMARKS");
                        Column column = new Column("", name.toUpperCase(), typeCode, remarks, null);
                        table.getColumns().add(column);
                    }
                }
                rtn.add(table);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                tableSet.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rtn;
    }

    public static String getValidationQuery(String driveClassName) {
        if (driveClassName.contains("mysql")) {
            return "select 1";
        }
        if ((driveClassName = driveClassName.toLowerCase()).contains("oracle")) {
            return "select 1 from dual";
        }
        if (driveClassName.contains("db2")) {
            return "select 1 from sysibm.sysdummy1";
        }
        if (driveClassName.contains("postgresql")) {
            return "select version()";
        }
        return "select 1";
    }
}

