/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;

public class DmDialect
extends Dialect {
    public DmDialect() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "bit");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(7, "real");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-2, "binary($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(-4, "image");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-1, "text");
        this.registerColumnType(2005, "clob");
        this.registerKeyword("last");
        this.registerKeyword("size");
        this.registerHibernateType(5, new ShortType().getName());
        this.registerFunction("substring", (SQLFunction)new SQLFunctionTemplate((Type)new StringType(), "substring(?1, ?2, ?3)"));
        this.registerFunction("locate", (SQLFunction)new SQLFunctionTemplate((Type)new IntegerType(), "locate(?1, ?2, ?3)"));
        this.registerFunction("trim", (SQLFunction)new SQLFunctionTemplate((Type)new StringType(), "trim(?1 ?2 ?3 ?4)"));
        this.registerFunction("length", (SQLFunction)new StandardSQLFunction("length", (Type)new IntegerType()));
        this.registerFunction("bit_length", (SQLFunction)new StandardSQLFunction("bit_length", (Type)new IntegerType()));
        this.registerFunction("coalesce", (SQLFunction)new StandardSQLFunction("coalesce"));
        this.registerFunction("nullif", (SQLFunction)new StandardSQLFunction("nullif"));
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction("mod", (Type)new LongType()));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)new DoubleType()));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper"));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower"));
        this.registerFunction("cast", (SQLFunction)new CastFunction());
        this.registerFunction("extract", (SQLFunction)new SQLFunctionTemplate((Type)new IntegerType(), "extract(?1 ?2 ?3)"));
        this.registerFunction("second", (SQLFunction)new StandardSQLFunction("second", (Type)new IntegerType()));
        this.registerFunction("minute", (SQLFunction)new StandardSQLFunction("minute", (Type)new IntegerType()));
        this.registerFunction("hour", (SQLFunction)new StandardSQLFunction("hour", (Type)new IntegerType()));
        this.registerFunction("day", (SQLFunction)new StandardSQLFunction("day", (Type)new IntegerType()));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)new IntegerType()));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)new IntegerType()));
        this.registerFunction("str", (SQLFunction)new StandardSQLFunction("to_char", (Type)new StringType()));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)new DoubleType()));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)new DoubleType()));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)new DoubleType()));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)new DoubleType()));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction("ceil", (Type)new IntegerType()));
        this.registerFunction("ceiling", (SQLFunction)new StandardSQLFunction("ceiling", (Type)new IntegerType()));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)new DoubleType()));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)new DoubleType()));
        this.registerFunction("cosh", (SQLFunction)new StandardSQLFunction("cosh", (Type)new DoubleType()));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees"));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)new DoubleType()));
        this.registerFunction("GREATEST", (SQLFunction)new StandardSQLFunction("GREATEST", (Type)new DoubleType()));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor", (Type)new IntegerType()));
        this.registerFunction("ln", (SQLFunction)new StandardSQLFunction("ln", (Type)new DoubleType()));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)new DoubleType()));
        this.registerFunction("log10", (SQLFunction)new StandardSQLFunction("log10", (Type)new DoubleType()));
        this.registerFunction("pi", (SQLFunction)new NoArgSQLFunction("pi", (Type)new DoubleType()));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)new DoubleType()));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians"));
        this.registerFunction("rand", (SQLFunction)new NoArgSQLFunction("rand", (Type)new DoubleType()));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)new IntegerType()));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)new DoubleType()));
        this.registerFunction("sinh", (SQLFunction)new StandardSQLFunction("sinh", (Type)new DoubleType()));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)new DoubleType()));
        this.registerFunction("tanh", (SQLFunction)new StandardSQLFunction("tanh", (Type)new DoubleType()));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction("trunc"));
        this.registerFunction("truncate", (SQLFunction)new StandardSQLFunction("truncate"));
        this.registerFunction("stddev", (SQLFunction)new StandardSQLFunction("stddev", (Type)new DoubleType()));
        this.registerFunction("variance", (SQLFunction)new StandardSQLFunction("variance", (Type)new DoubleType()));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)new StringType(), "", "||", ""));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)new IntegerType()));
        this.registerFunction("char", (SQLFunction)new StandardSQLFunction("char", (Type)new CharacterType()));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("difference", (Type)new IntegerType()));
        this.registerFunction("char_length", (SQLFunction)new StandardSQLFunction("char_length", (Type)new LongType()));
        this.registerFunction("character_length", (SQLFunction)new StandardSQLFunction("character_length", (Type)new LongType()));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)new CharacterType()));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap", (Type)new StringType()));
        this.registerFunction("insert", (SQLFunction)new StandardSQLFunction("insert", (Type)new StringType()));
        this.registerFunction("insstr", (SQLFunction)new StandardSQLFunction("insstr", (Type)new StringType()));
        this.registerFunction("instr", (SQLFunction)new StandardSQLFunction("instr", (Type)new LongType()));
        this.registerFunction("instrb", (SQLFunction)new StandardSQLFunction("instrb", (Type)new LongType()));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction("lcase", (Type)new StringType()));
        this.registerFunction("left", (SQLFunction)new StandardSQLFunction("left", (Type)new StringType()));
        this.registerFunction("leftstr", (SQLFunction)new StandardSQLFunction("leftstr", (Type)new StringType()));
        this.registerFunction("len", (SQLFunction)new StandardSQLFunction("len", (Type)new IntegerType()));
        this.registerFunction("LENGTHB", (SQLFunction)new StandardSQLFunction("LENGTHB", (Type)new IntegerType()));
        this.registerFunction("octet_length", (SQLFunction)new StandardSQLFunction("octet_length", (Type)new LongType()));
        this.registerFunction("lpad", (SQLFunction)new StandardSQLFunction("lpad", (Type)new StringType()));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim", (Type)new StringType()));
        this.registerFunction("position", (SQLFunction)new StandardSQLFunction("position", (Type)new IntegerType()));
        this.registerFunction("INS", (SQLFunction)new StandardSQLFunction("INS", (Type)new StringType()));
        this.registerFunction("repeat", (SQLFunction)new StandardSQLFunction("repeat", (Type)new StringType()));
        this.registerFunction("REPLICATE", (SQLFunction)new StandardSQLFunction("REPLICATE", (Type)new StringType()));
        this.registerFunction("STUFF", (SQLFunction)new StandardSQLFunction("STUFF", (Type)new StringType()));
        this.registerFunction("repeatstr", (SQLFunction)new StandardSQLFunction("repeatstr", (Type)new StringType()));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)new StringType()));
        this.registerFunction("reverse", (SQLFunction)new StandardSQLFunction("reverse", (Type)new StringType()));
        this.registerFunction("right", (SQLFunction)new StandardSQLFunction("right", (Type)new StringType()));
        this.registerFunction("rightstr", (SQLFunction)new StandardSQLFunction("rightstr", (Type)new StringType()));
        this.registerFunction("rpad", (SQLFunction)new StandardSQLFunction("rpad", (Type)new StringType()));
        this.registerFunction("TO_NUMBER", (SQLFunction)new StandardSQLFunction("TO_NUMBER"));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim", (Type)new StringType()));
        this.registerFunction("soundex", (SQLFunction)new StandardSQLFunction("soundex", (Type)new StringType()));
        this.registerFunction("space", (SQLFunction)new StandardSQLFunction("space", (Type)new StringType()));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction("substr", (Type)new StringType()));
        this.registerFunction("substrb", (SQLFunction)new StandardSQLFunction("substrb", (Type)new StringType()));
        this.registerFunction("to_char", (SQLFunction)new StandardSQLFunction("to_char", (Type)new StringType()));
        this.registerFunction("STRPOSDEC", (SQLFunction)new StandardSQLFunction("STRPOSDEC", (Type)new StringType()));
        this.registerFunction("STRPOSINC", (SQLFunction)new StandardSQLFunction("STRPOSINC", (Type)new StringType()));
        this.registerFunction("VSIZE", (SQLFunction)new StandardSQLFunction("VSIZE", (Type)new IntegerType()));
        this.registerFunction("translate", (SQLFunction)new StandardSQLFunction("translate", (Type)new StringType()));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction("ucase", (Type)new StringType()));
        this.registerFunction("OVERLAPS", (SQLFunction)new StandardSQLFunction("OVERLAPS"));
        this.registerFunction("DATEPART", (SQLFunction)new StandardSQLFunction("DATEPART"));
        this.registerFunction("DATE_PART", (SQLFunction)new StandardSQLFunction("DATE_PART"));
        this.registerFunction("add_days", (SQLFunction)new StandardSQLFunction("add_days"));
        this.registerFunction("add_months", (SQLFunction)new StandardSQLFunction("add_months"));
        this.registerFunction("add_weeks", (SQLFunction)new StandardSQLFunction("add_weeks"));
        this.registerFunction("curdate", (SQLFunction)new NoArgSQLFunction("curdate", (Type)new DateType()));
        this.registerFunction("curtime", (SQLFunction)new NoArgSQLFunction("curtime", (Type)new TimeType()));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("current_date", (Type)new DateType()));
        this.registerFunction("current_time", (SQLFunction)new NoArgSQLFunction("current_time", (Type)new TimeType()));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current_timestamp", (Type)new TimestampType()));
        this.registerFunction("dateadd", (SQLFunction)new StandardSQLFunction("dateadd", (Type)new TimestampType()));
        this.registerFunction("CUR_TICK_TIME", (SQLFunction)new StandardSQLFunction("CUR_TICK_TIME"));
        this.registerFunction("datediff", (SQLFunction)new StandardSQLFunction("datediff", (Type)new IntegerType()));
        this.registerFunction("datepart", (SQLFunction)new StandardSQLFunction("datepart", (Type)new IntegerType()));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction("dayname", (Type)new StringType()));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction("dayofmonth", (Type)new IntegerType()));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction("dayofweek", (Type)new IntegerType()));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction("dayofyear", (Type)new IntegerType()));
        this.registerFunction("days_between", (SQLFunction)new StandardSQLFunction("days_between", (Type)new IntegerType()));
        this.registerFunction("getdate", (SQLFunction)new StandardSQLFunction("getdate", (Type)new TimestampType()));
        this.registerFunction("LOCALTIMESTAMP", (SQLFunction)new StandardSQLFunction("LOCALTIMESTAMP"));
        this.registerFunction("NOW", (SQLFunction)new StandardSQLFunction("NOW"));
        this.registerFunction("last_day", (SQLFunction)new StandardSQLFunction("last_day"));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)new IntegerType()));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction("monthname", (Type)new StringType()));
        this.registerFunction("months_between", (SQLFunction)new StandardSQLFunction("months_between"));
        this.registerFunction("GREATEST", (SQLFunction)new StandardSQLFunction("GREATEST", (Type)new DateType()));
        this.registerFunction("TO_DATETIME", (SQLFunction)new StandardSQLFunction("TO_DATETIME"));
        this.registerFunction("next_day", (SQLFunction)new StandardSQLFunction("next_day"));
        this.registerFunction("quarter", (SQLFunction)new StandardSQLFunction("quarter", (Type)new IntegerType()));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("timestampadd", (SQLFunction)new StandardSQLFunction("timestampadd", (Type)new TimestampType()));
        this.registerFunction("timestampdiff", (SQLFunction)new StandardSQLFunction("timestampdiff", (Type)new IntegerType()));
        this.registerFunction("BIGDATEDIFF", (SQLFunction)new StandardSQLFunction("BIGDATEDIFF", (Type)new BigIntegerType()));
        this.registerFunction("sysdate", (SQLFunction)new StandardSQLFunction("sysdate", (Type)new TimeType()));
        this.registerFunction("LEAST", (SQLFunction)new StandardSQLFunction("LEAST"));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction("trunc"));
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction("week", (Type)new IntegerType()));
        this.registerFunction("weekday", (SQLFunction)new StandardSQLFunction("weekday", (Type)new IntegerType()));
        this.registerFunction("weeks_between", (SQLFunction)new StandardSQLFunction("weeks_between", (Type)new IntegerType()));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)new IntegerType()));
        this.registerFunction("years_between", (SQLFunction)new StandardSQLFunction("years_between", (Type)new IntegerType()));
        this.registerFunction("to_date", (SQLFunction)new StandardSQLFunction("to_date", (Type)new TimestampType()));
        this.registerFunction("systimestamp", (SQLFunction)new NoArgSQLFunction("systimestamp", (Type)new TimestampType()));
        this.registerFunction("ifnull", (SQLFunction)new StandardSQLFunction("ifnull"));
        this.registerFunction("isnull", (SQLFunction)new StandardSQLFunction("isnull"));
        this.registerFunction("nvl", (SQLFunction)new StandardSQLFunction("nvl"));
        this.registerFunction("decode", (SQLFunction)new StandardSQLFunction("decode"));
        this.registerFunction("cur_database", (SQLFunction)new StandardSQLFunction("cur_database", (Type)new StringType()));
        this.registerFunction("page", (SQLFunction)new StandardSQLFunction("page", (Type)new IntegerType()));
        this.registerFunction("sessid", (SQLFunction)new StandardSQLFunction("sessid", (Type)new LongType()));
        this.registerFunction("uid", (SQLFunction)new StandardSQLFunction("uid", (Type)new LongType()));
        this.registerFunction("user", (SQLFunction)new StandardSQLFunction("user", (Type)new StringType()));
        this.registerFunction("vsize", (SQLFunction)new StandardSQLFunction("vsize", (Type)new IntegerType()));
        this.registerFunction("tabledef", (SQLFunction)new StandardSQLFunction("tabledef", (Type)new StringType()));
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public boolean supportsInsertSelectIdentity() {
        return false;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public String getIdentitySelectString() throws MappingException {
        return "select scope_identity()";
    }

    public String appendIdentitySelectToInsert(String insertString) {
        return insertString + " select scope_identity()";
    }

    protected String getIdentityColumnString() throws MappingException {
        return "identity not null";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) throws MappingException {
        return "select " + sequenceName + ".nextval";
    }

    protected String getCreateSequenceString(String sequenceName) throws MappingException {
        return "create sequence " + sequenceName;
    }

    protected String getDropSequenceString(String sequenceName) throws MappingException {
        return "drop sequence " + sequenceName;
    }

    public String getSelectGUIDString() {
        return "select GUID()";
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public String getLimitString(String query, int offset, int limit) {
        return this.getLimitString(query, offset > 0);
    }

    public String getLimitString(String query, boolean hasOffset) {
        query = query.trim();
        while (query.endsWith(";")) {
            query = query.substring(0, query.length() - 1);
        }
        boolean isForUpdate = false;
        if (query.toLowerCase().endsWith(" for update")) {
            query = query.substring(0, query.length() - 11);
            isForUpdate = true;
        }
        String pagingSelect = "";
        if (hasOffset) {
            pagingSelect = pagingSelect + query;
            pagingSelect = pagingSelect + " limit ? offset ? ";
        } else {
            pagingSelect = pagingSelect + query;
            pagingSelect = pagingSelect + " limit ? ";
        }
        if (isForUpdate) {
            pagingSelect = pagingSelect + " for update ";
        }
        return pagingSelect.toString();
    }

    public String getForUpdateString() {
        return " for update";
    }

    public boolean forUpdateOfColumns() {
        return true;
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString() + " nowait";
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString() + " of " + aliases + " nowait";
    }

    public String appendLockHint(LockMode mode, String tableName) {
        return tableName;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String generateTemporaryTableName(String baseTableName) {
        return "##" + baseTableName;
    }

    public boolean dropTemporaryTableAfterUse() {
        return false;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : "0";
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        String res = "";
        res = res + " add constraint ";
        res = res + constraintName;
        res = res + " foreign key (";
        res = res + StringHelper.join((String)", ", (String[])foreignKey);
        res = res + ") references ";
        res = res + referencedTable;
        if (!referencesPrimaryKey) {
            res = res + " (" + StringHelper.join((String)", ", (String[])primaryKey) + ')';
        }
        return res.toString();
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsNotNullUnique() {
        return true;
    }
}

