/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.data;

import cn.myapps.common.util.SimpleDateUtil;
import cn.myapps.common.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.DynaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerMapping;

public class ParamsTable
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ParamsTable.class);
    private static final long serialVersionUID = -3970066605460641346L;
    public static final String DEBUG_COOKIE_NAME = "DEBUG";
    private HashMap<String, Object> params = new HashMap();
    private String siteHttp;
    private String contextPath;
    private String sessionid;
    private String docId;
    private transient HttpServletRequest httpRequest;
    private transient PortletRequest portletRequest = null;

    public ParamsTable() {
    }

    public ParamsTable(ParamsTable params) {
        this.setHttpRequest(params.getHttpRequest());
        this.setSessionid(params.getSessionid());
        this.setContextPath(params.getContextPath());
        this.params.putAll(params.getParams());
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public Object getRequest() {
        if (this.httpRequest != null) {
            return this.httpRequest;
        }
        return this.portletRequest;
    }

    public void addAllParameter(Map<String, Object> valueMap) {
        this.params.putAll(valueMap);
    }

    public void setParameter(String name, Object value) {
        if (StringUtil.isBlank(name)) {
            return;
        }
        name = name.toLowerCase();
        if (value instanceof String) {
            if (value != null) {
                this.params.put(name, String.valueOf(value).replace("../", ""));
            } else {
                this.params.put(name, value);
            }
        } else {
            this.params.put(name, value);
        }
        if (name != null && name.equalsIgnoreCase("docid")) {
            this.setDocId(String.valueOf(value));
        }
    }

    public Object getParameter(String name) {
        Object value = this.params.get(name);
        if (value == null) {
            value = this.params.get(name.toLowerCase());
        }
        return value;
    }

    public String getParameterAsString(String name) {
        Object obj = this.getParameter(name);
        if (obj instanceof String) {
            String value = StringUtil.dencodeHTML((String)obj);
            return value;
        }
        if (obj instanceof String[]) {
            return StringUtil.unite((String[])obj);
        }
        if (obj instanceof Object[]) {
            return StringUtil.unite((Object[])obj);
        }
        return obj != null ? StringUtil.dencodeHTML(obj.toString()) : null;
    }

    public String[] getParameterAsArray(String name) {
        Object obj = this.getParameter(name);
        if (obj != null) {
            if (obj instanceof String[]) {
                return (String[])obj;
            }
            return new String[]{(String)obj};
        }
        return new String[0];
    }

    public String getParameterAsText(String name) {
        return this.getParameterAsText(name, ";");
    }

    public String getParameterAsText(String name, String split) {
        Object obj = this.getParameter(name);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof String[]) {
            return StringUtil.unite((String[])obj, split);
        }
        return obj != null ? obj.toString() : null;
    }

    public Double getParameterAsDouble(String name) {
        Object obj = this.getParameter(name);
        if (obj instanceof String) {
            String value = (String)obj;
            try {
                return new Double(value);
            }
            catch (Exception e) {
                return new Double(0.0);
            }
        }
        return null;
    }

    public Integer getParameterAsInteger(String name) {
        Object obj = this.getParameter(name);
        if (obj instanceof String) {
            String value = (String)obj;
            try {
                return new Integer(value);
            }
            catch (Exception e) {
                return new Integer(0);
            }
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return null;
    }

    public boolean getParameterAsBoolean(String name) {
        Object obj = this.getParameter(name);
        if (obj instanceof String) {
            String value = (String)obj;
            if (!StringUtil.isBlank(value) && value.equals("true")) {
                return true;
            }
        } else if (obj instanceof Boolean) {
            return Boolean.parseBoolean(obj.toString());
        }
        return false;
    }

    public Long getParameterAsLong(String name) {
        Object obj = this.getParameter(name);
        if (obj instanceof String) {
            String value = (String)obj;
            try {
                return Long.valueOf(value);
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return null;
    }

    public Date getParameterAsDate(String name) {
        Object obj = this.getParameter(name);
        if (obj instanceof String) {
            try {
                String value = (String)obj;
                if (value != null && SimpleDateUtil.isDate(value)) {
                    return new Date(SimpleDateUtil.parseDate(value).getTime());
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public Iterator<String> getParameterNames() {
        return this.params.keySet().iterator();
    }

    public static ParamsTable convertHTTP(PortletRequest request) {
        ParamsTable params = new ParamsTable();
        params.siteHttp = request.getServerName();
        params.contextPath = request.getContextPath();
        Map m = request.getParameterMap();
        for (Map.Entry entry : m.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                if (value instanceof String[]) {
                    if (((String[])value).length > 1) {
                        params.setParameter(name, value);
                        continue;
                    }
                    params.setParameter(name, ((String[])value)[0]);
                    continue;
                }
                params.setParameter(name, value);
            }
            catch (Exception e) {
                LOG.warn("{}", (Object)("Set parameter: " + name + " failed, the value is: " + value));
            }
        }
        params.sessionid = request.getPortletSession().getId();
        params.setPortletRequest(request);
        return params;
    }

    public static ParamsTable convertHTTP(HttpServletRequest request) {
        ParamsTable params = new ParamsTable();
        params.siteHttp = request.getServerName();
        params.contextPath = request.getContextPath();
        params.sessionid = request.getSession().getId();
        if (request.getAttribute("BODY_KEY") != null && request.getAttribute("BODY_KEY") instanceof String) {
            try {
                String body = (String)request.getAttribute("BODY_KEY");
                JSONObject jsonpObject = JSON.parseObject((String)body);
                if (jsonpObject != null) {
                    for (String key : jsonpObject.keySet()) {
                        params.setParameter(key, jsonpObject.get((Object)key));
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("convertHTTP-Body\u89e3\u6790\u5f02\u5e38:{};\u5f02\u5e38:{}", request.getAttribute("BODY_KEY"), (Object)ex.toString());
            }
        }
        params.setParameter("realPath", request.getSession().getServletContext().getRealPath("/"));
        params.setHttpRequest(request);
        Object urlTemplateVariables = request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (urlTemplateVariables instanceof Map) {
            Map urlTemplateVariableMaps = (Map)urlTemplateVariables;
            for (String key : urlTemplateVariableMaps.keySet()) {
                if ("id".equalsIgnoreCase(key) && request.getRequestURI() != null && request.getRequestURI().contains("/documents/")) {
                    String id = (String)urlTemplateVariableMaps.get(key);
                    params.setParameter("docid", id);
                    params.setDocId(id);
                }
                params.setParameter(key, urlTemplateVariableMaps.get(key));
            }
        }
        Map m = request.getParameterMap();
        for (Map.Entry entry : m.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                if (value instanceof String[]) {
                    if (((String[])value).length > 1) {
                        params.setParameter(name, value);
                        continue;
                    }
                    params.setParameter(name, ((String[])value)[0]);
                    continue;
                }
                params.setParameter(name, value);
            }
            catch (Exception e) {
                LOG.warn("{}", (Object)("Set parameter: " + name + " failed, the value is: " + value));
            }
        }
        return params;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public Object getParameter(String name, int index) {
        Object obj = this.getParameter(name);
        if (obj != null && obj instanceof String[]) {
            String[] col = (String[])obj;
            return col[index];
        }
        return null;
    }

    public void setParameter(String name, int index, Object value) {
        Object obj = this.getParameter(name);
        if (obj != null && obj instanceof String[]) {
            String[] col = (String[])obj;
            col[index] = (String)value;
        }
    }

    public DynaProperty[] getDynaProperties() {
        DynaProperty[] dynaProps = new DynaProperty[this.params.size()];
        Iterator<String> iter = this.params.keySet().iterator();
        int count = 0;
        while (iter.hasNext()) {
            DynaProperty prop;
            String paramName = iter.next();
            dynaProps[count] = prop = new DynaProperty(paramName, this.getParameter(paramName).getClass());
            ++count;
        }
        return dynaProps;
    }

    public DynaProperty getDynaProperty(String name) {
        DynaProperty prop = null;
        prop = this.getParameter(name) != null ? new DynaProperty(name, this.getParameter(name).getClass()) : new DynaProperty(name, String.class);
        return prop;
    }

    public void removeParameter(String name) {
        this.params.remove(name);
    }

    public String getSiteHttp() {
        return this.siteHttp;
    }

    public String getContextPath() {
        if (this.contextPath != null) {
            return this.contextPath;
        }
        return "/";
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void putAll(Map<String, ?> map) {
        this.params.putAll(map);
    }

    public Map<String, ?> getParams() {
        return this.params;
    }

    public boolean containsKey(Object key) {
        return this.params.containsKey(key);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ParamsTable) {
            ParamsTable pt = (ParamsTable)obj;
            return this.params.equals(pt.params);
        }
        return false;
    }

    public int hashCode() {
        return this.params.hashCode();
    }

    public String getSessionid() {
        return this.sessionid;
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public PortletRequest getPortletRequest() {
        return this.portletRequest;
    }

    public void setPortletRequest(PortletRequest portletRequest) {
        this.portletRequest = portletRequest;
    }

    public String toString() {
        return this.params.toString();
    }

    public boolean isAllowedExecuteFieldValueScript() {
        if (this.getHttpRequest() == null) {
            return true;
        }
        Collection allowedAction = Stream.of("/refresh", "/importExcel").collect(Collectors.toList());
        return "GET".equalsIgnoreCase(this.getHttpRequest().getMethod()) || this.getHttpRequest().getRequestURI() != null && allowedAction.stream().anyMatch(ii -> this.getHttpRequest().getRequestURI().contains((CharSequence)ii));
    }

    public ParamsTable copyContextParams() {
        ParamsTable newParams = new ParamsTable();
        newParams.setHttpRequest(this.getHttpRequest());
        newParams.setSessionid(this.getSessionid());
        newParams.setContextPath(this.getContextPath());
        return newParams;
    }

    public Map<String, ?> getContextParams() {
        HashMap<String, Object> pms = new HashMap<String, Object>();
        if (this.getParams() != null) {
            for (String key : this.getParams().keySet()) {
                pms.put(key, this.getParams().get(key));
            }
        }
        pms.put("contextPath", this.getContextPath());
        pms.put("docId", this.getDocId());
        pms.put("sessionId", this.getSessionid());
        pms.put("siteHttp", this.getSiteHttp());
        if (this.getHttpRequest() != null) {
            pms.put("request.requestURI", this.getHttpRequest().getRequestURI());
            pms.put("request.method", this.getHttpRequest().getMethod());
            Enumeration headerNames = this.getHttpRequest().getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String h = (String)headerNames.nextElement();
                    pms.put(String.format("request.head.%s", h), this.getHttpRequest().getHeader(h));
                }
            }
        }
        return pms;
    }
}

