/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.controller;

import cn.myapps.common.controller.ErrorMessage;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Resource
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Resource.class);
    private static final long serialVersionUID = 2315158311944949185L;
    private int errcode;
    private String errmsg;
    private Object data;
    public String trackId;
    private String actionStep;
    private Collection<ErrorMessage> errors;

    public Resource() {
    }

    public Resource(int errcode, String errmsg, Object data, Collection<ErrorMessage> errors) {
        this(errcode, errmsg, data);
        this.errors = errors;
    }

    public Resource(int errcode, String errmsg, Object data) {
        this(errcode, errmsg);
        this.data = data;
        this.errors = null;
    }

    public Resource(int errcode, String errmsg) {
        this.errcode = errcode;
        this.errmsg = errmsg;
        this.data = null;
        this.errors = null;
        if (errcode > 0) {
            this.errmsg = "\u7cfb\u7edf\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
            logger.error("\u7cfb\u7edf\u5f02\u5e38:{}", (Object)errmsg);
        }
    }

    public int getErrcode() {
        return this.errcode;
    }

    public void setErrcode(int errcode) {
        this.errcode = errcode;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Collection<ErrorMessage> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<ErrorMessage> errors) {
        this.errors = errors;
    }

    public String getTrackId() {
        return this.trackId;
    }

    public void setTrackId(String trackId) {
        this.trackId = trackId;
    }

    public String getActionStep() {
        return this.actionStep;
    }

    public void setActionStep(String actionStep) {
        this.actionStep = actionStep;
    }

    public static Resource ok(Object data) {
        return new Resource(0, "ok", data, null);
    }

    public static Resource ok(Object data, String actionStep) {
        Resource resource = new Resource(0, "ok", data, null);
        resource.setActionStep(actionStep);
        return resource;
    }

    public static Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
        return new Resource(errcode, errmsg, null, errors);
    }

    public static Resource error(int errcode, String actionStep, String errmsg, Collection<ErrorMessage> errors) {
        Resource resource = new Resource(errcode, errmsg, null, errors);
        resource.setActionStep(actionStep);
        return resource;
    }
}

