/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.adapters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DateAdapter
extends XmlAdapter<String, Date> {
    private static final Logger logger = LoggerFactory.getLogger(DateAdapter.class);
    private static final String CUSTOM_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    public String marshal(Date v) {
        return new SimpleDateFormat(CUSTOM_FORMAT_STRING).format(v);
    }

    public Date unmarshal(String v) throws ParseException {
        if (!StringUtils.hasLength((String)v)) {
            return null;
        }
        try {
            return new SimpleDateFormat(CUSTOM_FORMAT_STRING).parse(v);
        }
        catch (Exception ex) {
            logger.error("failed to unmarshal date={}", (Object)v, (Object)ex);
            throw ex;
        }
    }
}

