/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common;

import cn.myapps.common.CommonDAO;
import cn.myapps.common.DesignTimeSerializable;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.util.SequenceGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDesignTimeService<T extends DesignTimeSerializable> {
    protected abstract CommonDAO<T> getDao();

    public List<T> deepQueryAll(String parentId, String fileSuffix) throws Exception {
        return this.getDao().deepQueryAll(parentId, fileSuffix);
    }

    public T findByUri(String uri) throws Exception {
        return (T)((DesignTimeSerializable)this.getDao().findByUri(uri));
    }

    public T findById(String id) throws Exception {
        return (T)((DesignTimeSerializable)this.getDao().findById(id));
    }

    public void save(T object) throws Exception {
        if (StringUtils.isBlank((String)object.getId())) {
            object.setId(SequenceGenerator.getDesignTimeSequence());
        }
        this.getDao().save(object);
    }

    public void saveOrUpdate(T object) throws Exception {
        if (StringUtils.isBlank((String)object.getId())) {
            object.setId(SequenceGenerator.getDesignTimeSequence());
            this.save(object);
        } else {
            this.update(object);
        }
    }

    public void update(T object) throws Exception {
        this.getDao().save(object);
    }

    public void delete(String id) throws Exception {
        this.getDao().delete(id);
    }

    public void delete(String[] ids) throws Exception {
        for (String id : ids) {
            this.getDao().delete(id);
        }
    }

    public DataPackage<T> query(String parentId, String name, int page, int lines) throws Exception {
        DataPackage<T> dp = new DataPackage<T>();
        try {
            List<T> list = this.getDao().queryByName(parentId, this.getPathSuffix(), this.getFileSuffix(), name);
            if ((int)Math.ceil((double)list.size() / (double)lines) < page) {
                page = 1;
            }
            dp.setRowCount(list.size());
            dp.setPageNo(page);
            dp.setLinesPerPage(lines);
            dp.setDatas(this.listPage(list, page, lines));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return dp;
    }

    public DataPackage<T> queryByNameOrDescript(String parentId, String searchword, int page, int lines) throws Exception {
        DataPackage<T> dp = new DataPackage<T>();
        List<T> list = this.getDao().queryByNameOrDescript(parentId, this.getPathSuffix(), this.getFileSuffix(), searchword);
        if ((int)Math.ceil((double)list.size() / (double)lines) < page) {
            page = 1;
        }
        dp.setRowCount(list.size());
        dp.setPageNo(page);
        dp.setLinesPerPage(lines);
        dp.setDatas(this.listPage(list, page, lines));
        return dp;
    }

    public List<T> queryAccurateByName(String parentId, String name) throws Exception {
        return this.getDao().queryAccurateByName(parentId, this.getPathSuffix(), this.getFileSuffix(), name);
    }

    private List<T> listPage(List<T> data, int page, int lines) {
        int totalCount = data.size();
        int totalPage = (totalCount + lines - 1) / lines;
        int lastPage = page - 1 > 1 ? page - 1 : 1;
        int nextPage = page >= totalPage ? totalPage : page + 1;
        int fromIndex = (page - 1) * lines;
        if (fromIndex >= data.size()) {
            return Collections.emptyList();
        }
        if (fromIndex < 0) {
            return Collections.emptyList();
        }
        int toIndex = page * lines;
        if (toIndex >= data.size()) {
            toIndex = data.size();
        }
        ArrayList<T> newList = new ArrayList<T>(data.subList(fromIndex, toIndex));
        return newList;
    }

    public List<T> list(String parentId, String name) throws Exception {
        return this.getDao().queryByName(parentId, this.getPathSuffix(), this.getFileSuffix(), name);
    }

    public List<T> list(String parentId, String pathSuffix, String fileSuffix, String name) throws Exception {
        return this.getDao().queryByName(parentId, pathSuffix, fileSuffix, name);
    }

    public List<T> getSubordinate(String id, String name) throws Exception {
        return this.getDao().querySubordinate(id, name);
    }

    public List<T> getSubordinateChildren(String id, String name) throws Exception {
        return this.getDao().querySubordinate(id, this.getPathSuffix(), this.getFileSuffix(), name);
    }

    public List<T> getChildsByParentId(String id, String pathSuffix, String fileSuffix, String name) throws Exception {
        return this.getDao().queryByParentId(id, pathSuffix, fileSuffix, name);
    }

    public List<T> getChildsByParentId(String id, String name) throws Exception {
        return this.getDao().queryByParentId(id, this.getPathSuffix(), this.getFileSuffix(), name);
    }

    protected abstract String getPathSuffix();

    protected abstract String getFileSuffix();
}

