/*
 * Copyright 2012 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package cn.myapps.proxy.client;

import static io.netty.handler.codec.http.HttpResponseStatus.CONTINUE;
import static io.netty.handler.codec.http.HttpVersion.HTTP_1_1;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import cn.myapps.common.util.SiteIdGenerator;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;

/**
 * Handler implementation for the echo client. It initiates the ping-pong
 * traffic between the echo client and server by sending the first message to
 * the server.
 */
public class EClientHandler extends ChannelHandlerAdapter {
	private static ChannelHandlerContext context;
	public static final String REG_WEIOA_SITE_ID = "WEIOA_SITE_ID";
	public final static String HTTP_CHANNEL_ID = "HTTP_CHANNEL_ID";
	public static String siteId;
	private final int MAX_BEATTIMEOUT_TIMES = 5;
	
	
	public static void init(){
		try {
			siteId = SiteIdGenerator.getMACAddress();
			String path = new File("").getAbsolutePath();
			System.out.println("path1--->"+path);
			path += File.separator+"apache-tomcat-7.0.57"+ File.separator+"webapps"+ File.separator+"obpm";
			System.out.println("path2--->"+path);
			File file = new File(path);
			if(file.exists()){
				file.renameTo(new File(path.replace("obpm", siteId)));
			}
			System.out.println("Agent Client Started...With SITEID:" + siteId);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void init2(){
		BufferedWriter writer = null;
		try {
			
			siteId = SiteIdGenerator.getMACAddress();
			File batch = new File("weioa_start.bat");
			if (!batch.exists())
				batch.createNewFile();

			writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(batch)));
			writer.append("@echo off");
			writer.newLine();
			writer.append("setlocal");
			writer.newLine();
			writer.append("set CURRENT_DIR=%cd%");
			writer.newLine();
//			writer.append("cd apache-tomcat-7.0.57\\webapps");
//			writer.newLine();
			writer.append("if exist \"%CURRENT_DIR%\\apache-tomcat-7.0.57\\webapps\\"+siteId+"\" (if exist \"%CURRENT_DIR%\\apache-tomcat-7.0.57\\webapps\\obpm\" rd /q/s \"%CURRENT_DIR%\\apache-tomcat-7.0.57\\webapps\\"+siteId+"\")");
			writer.newLine();
			writer.append("RENAME \"%CURRENT_DIR%\\apache-tomcat-7.0.57\\webapps\\obpm\" "+siteId);
			writer.newLine();
//			writer.append("call \"%CURRENT_DIR%\\webstart.bat\"");
			writer.flush();
			//writer.append("start http://yun.weioa365.com/setup.jsp?siteid=" + siteId);
			System.out.println("Agent Client Started...With SITEID:" + siteId);
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				if (writer != null)
					writer.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	private HttpResponse sendHeartBeatPing() {
		DefaultFullHttpResponse response = new DefaultFullHttpResponse(HTTP_1_1, CONTINUE);
		response.headers().add(REG_WEIOA_SITE_ID, siteId);
		response.headers().add(HEARTBEAT, "PING");
		System.out.println("EClient Send    --->PING");
		return response;
	}

	public static void writeAndFlush(String httpChannelId, Object msg) {
		if (msg instanceof HttpResponse) {
			HttpResponse response = (HttpResponse) msg;

//			String location = response.headers().getAndConvert(HttpHeaderNames.LOCATION);
			response.headers().add(HTTP_CHANNEL_ID, httpChannelId);
//			if (location!=null) {
//				int pos1 = location.indexOf("://") + 3;
//				int pos2 = location.substring(pos1).indexOf("/") + pos1;
//				location = location.substring(0, pos2) + "/" + siteId + location.substring(pos2);
//				response.headers().set(HttpHeaderNames.LOCATION, location);
//			}
			System.out.println(response);
			context.writeAndFlush(response);
		}
		if(msg instanceof HttpContent){
			
		}
		
	}

	@Override
	public void channelActive(ChannelHandlerContext ctx) throws Exception {
		// System.out.println("EClientHandler.channelActive:");
		context = ctx;
		// channelPool.put(ctx.channel().id().asShortText(), ctx.channel());
		System.out.println("EClient Channel ID:" + ctx.channel().id().asShortText());
		ctx.writeAndFlush(sendHeartBeatPing());
	}

	// @Override
	// public void channelInactive(ChannelHandlerContext ctx) throws Exception {
	// channelPool.remove(ctx.channel().id().asShortText());
	// }

	public static final String HEARTBEAT = "HEARTBEAT";

	@Override
	public void channelRead(ChannelHandlerContext ctx, Object msg) {

		// System.out.println("EClientHandler.channelRead:" + msg);
		this.beatTimeOutCount = 0;
		if (msg instanceof HttpRequest) {
			HttpRequest request = (HttpRequest) msg;

			String beat = request.headers().getAndConvert(HEARTBEAT);
			if (beat == null || beat.isEmpty()) {
				sendResponse2(request);
			} else {
				System.out.println("EClient Received <---" + beat);
			}
		}
	}

	@Override
	public void channelReadComplete(ChannelHandlerContext ctx) {
		ctx.flush();
		System.out.println("EClientHandler.channelReadComplete**");
	}

	@Override
	public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
		// Close the connection when an exception is raised.
		cause.printStackTrace();
		ctx.close();
	}

	private int beatTimeOutCount = 0;

	@Override
	public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
		// TODO Auto-generated method stub
		if (IdleStateEvent.class.isAssignableFrom(evt.getClass())) {
			IdleStateEvent event = (IdleStateEvent) evt;
			if (event.state() == IdleState.ALL_IDLE) {
				ctx.channel().writeAndFlush(sendHeartBeatPing());
				beatTimeOutCount++;
				if (beatTimeOutCount >= MAX_BEATTIMEOUT_TIMES) {
					throw new Exception("Network ERROR...restart EClient!");
				}
			}
		}
	}

	private static volatile EventLoopGroup group = new NioEventLoopGroup();;

	private void sendResponse2(HttpRequest req) {
		//// ���ͽ����ȥ
		try {
			String host = "localhost";
			int port = 8080;

			// Configure the client.
			String httpChannelId = req.headers().getAndConvert(HTTP_CHANNEL_ID);

			Bootstrap b = new Bootstrap();
			b.group(group).channel(NioSocketChannel.class).handler(new HttpClientInitializer(httpChannelId));

			// Make the connection attempt.
			Channel outboundChannel = b.connect(host, port).sync().channel();
			System.err.print("request uri:" + req.uri() + "  channelid:" + httpChannelId);

			outboundChannel.writeAndFlush(req);

			// Send the HTTP request.
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	
}
