package com.bcxin.ferry.dtos;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bcxin.ferry.common.emus.FileTypeEnum;
import lombok.Data;

import java.util.Map;

@Data
public class FerryFileDto extends FerryDto {

    private static final long serialVersionUID = 1L;

    //任务文件id
    private String fileId;
    //文件类型，1-任务文件，2-sql文件，3-普通文件，4-子文件（拆分），5-txt文件，6-特殊字符名称文件
    private Integer fileType;
    //是否推送到政务外网
    private Integer isPushZw;

    public void putFileContent(String data){
        //文件类型不是普通文件
        Map<String, Object> fileMap = JSONObject.parseObject(data, new TypeReference<Map<String, Object>>(){});
        if (fileMap.get("paramContentSize") != null) {
            int paramContentSize = Integer.parseInt(fileMap.get("paramContentSize").toString());
            StringBuffer img_base64 = new StringBuffer(1000*paramContentSize);
            for (int i = 0; i < paramContentSize; i++) {
                img_base64.append(fileMap.get("paramContent_" + i).toString());
            }
            this.setImg_base64(img_base64.toString());
        }
    }
}
