/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.document.domains.documents.RdCompanyDocument;
import com.bcxin.tenant.open.document.domains.repositories.RdCompanyDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdProjectDocumentRepository;
import com.bcxin.tenant.open.domains.entities.RdCompanyEntity;
import com.bcxin.tenant.open.domains.readers.RdCompositedReader;
import com.bcxin.tenant.open.domains.repositories.RdCompanyRepository;
import com.bcxin.tenant.open.domains.services.RdCompanyService;
import com.bcxin.tenant.open.domains.services.commands.CreateSyncCompanyCommand;
import com.bcxin.tenant.open.domains.utils.RdCompanyEntityUtils;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.CompanyStatus;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.redis.om.spring.search.stream.EntityStream;
import org.springframework.stereotype.Service;

@Service
public class RdCompanyServiceImpl
implements RdCompanyService {
    private final JsonProvider jsonProvider;
    private final UnitWork unitWork;
    private final RdCompanyDocumentRepository companyDocumentRepository;
    private final RdCompanyRepository companyRepository;
    private final RdProjectDocumentRepository projectDocumentRepository;
    private final RdCompositedReader compositedReader;
    private final EntityStream entityStream;

    public RdCompanyServiceImpl(JsonProvider jsonProvider, UnitWork unitWork, RdCompanyDocumentRepository companyDocumentRepository, RdCompanyRepository companyRepository, RdProjectDocumentRepository projectDocumentRepository, RdCompositedReader compositedReader, EntityStream entityStream) {
        this.jsonProvider = jsonProvider;
        this.unitWork = unitWork;
        this.companyDocumentRepository = companyDocumentRepository;
        this.companyRepository = companyRepository;
        this.projectDocumentRepository = projectDocumentRepository;
        this.compositedReader = compositedReader;
        this.entityStream = entityStream;
    }

    @Override
    public void dispatch(CreateSyncCompanyCommand command) {
        String tranId = this.unitWork.beginTransaction();
        try {
            RdCompanyEntity companyEntity = (RdCompanyEntity)((Object)this.jsonProvider.toObject(RdCompanyEntity.class, command.getContent()));
            if (companyEntity == null) {
                throw new BadTenantException(String.format("\u65e0\u6548\u6570\u636e\u683c\u5f0f:%s", command.getContent()));
            }
            if (companyEntity.getStatus() == null) {
                companyEntity.setStatus(CompanyStatus.Normal);
            }
            RdCompanyDocument companyDocument = RdCompanyEntityUtils.toDocument(companyEntity, this.companyDocumentRepository, this.compositedReader, this.entityStream);
            this.companyDocumentRepository.save((Object)companyDocument);
            if (this.companyRepository.getByNoPkId(companyEntity.getId()) != null) {
                this.companyRepository.update(companyEntity);
            } else {
                this.companyRepository.insert(companyEntity);
            }
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }
}

