/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util;

import com.bcxin.signature.util.common.StringUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil
extends DateUtils {
    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);
    public static final long MS = 1L;
    public static final long SECOND_MS = 1000L;
    public static final long MINUTE_MS = 60000L;
    public static final long HOUR_MS = 3600000L;
    public static final long DAY_MS = 86400000L;
    public static final long MONTH_MS = 2592000000L;
    public static final long YEAR_MS = 31104000000L;
    public static final String FORMAT1 = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT2 = "yyyy-MM-dd";

    public static String now() {
        return DateUtil.formatDateTime((Date)new Date());
    }

    public static String formatDateTime(Date date) {
        SimpleDateFormat NORM_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static String getCurrentDateTime() {
        return DateUtil.getCurrentDateTime((String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrentDate() {
        return DateUtil.getCurrentDateTime((String)"yyyy-MM-dd");
    }

    public static String getCurrentDateTime(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new Date());
    }

    public static String today() {
        return DateUtil.formatDate((Date)new Date());
    }

    public static String getDate(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern);
    }

    public static long pastDays(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 86400000L;
    }

    public static String format(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String formatHttpDate(Date date) {
        SimpleDateFormat HTTP_DATETIME_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        return HTTP_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat NORM_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        return NORM_DATE_FORMAT.format(date);
    }

    public static Date parse(String dateString, String format) {
        if (StringUtil.isBlank((CharSequence)dateString)) {
            SimpleDateFormat NORM_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateString = NORM_DATETIME_FORMAT.format(new Date());
        }
        try {
            return new SimpleDateFormat(format).parse(dateString);
        }
        catch (ParseException e) {
            logger.error("Parse " + dateString + " with format " + format + " error!", (Throwable)e);
            return null;
        }
    }

    public static Date parseDateTime(String dateString) {
        SimpleDateFormat NORM_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return NORM_DATETIME_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            logger.error("Parse " + dateString + " with format " + NORM_DATETIME_FORMAT.toPattern() + " error!", (Throwable)e);
            return null;
        }
    }

    public static Date matchFormatByLength(String dateString) {
        SimpleDateFormat NORM_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            int num = dateString.length();
            if (num == 16) {
                SimpleDateFormat NORM_DATETIME_FORMAT1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                return NORM_DATETIME_FORMAT1.parse(dateString);
            }
            if (num == 19) {
                return NORM_DATETIME_FORMAT.parse(dateString);
            }
            SimpleDateFormat NORM_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
            return NORM_DATE_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            logger.error("Parse " + dateString + " with format " + NORM_DATETIME_FORMAT.toPattern() + " error!", (Throwable)e);
            return null;
        }
    }

    public static Date parseDate(String dateString) {
        SimpleDateFormat NORM_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return NORM_DATE_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            logger.error("Parse " + dateString + " with format " + NORM_DATE_FORMAT.toPattern() + " error!", (Throwable)e);
            return null;
        }
    }

    public static Date getOffsiteDate(Date date, int calendarField, int offsite) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(calendarField, offsite);
        return cal.getTime();
    }

    public static String dateDiff(Date subtrahend, Date minuend) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(subtrahend);
        long diff = minuend.getTime() - subtrahend.getTime();
        if (diff <= 3600000L) {
            return diff / 60000L + "\u5206\u949f\u524d";
        }
        if (diff <= 86400000L) {
            return diff / 3600000L + "\u5c0f\u65f6" + diff % 3600000L / 60000L + "\u5206\u949f\u524d";
        }
        if (diff <= 172800000L) {
            return "\u6628\u5929" + calendar.get(11) + "\u70b9" + calendar.get(12) + "\u5206";
        }
        if (diff <= 259200000L) {
            return "\u524d\u5929" + calendar.get(11) + "\u70b9" + calendar.get(12) + "\u5206";
        }
        if (diff <= 2592000000L) {
            return diff / 86400000L + "\u5929\u524d" + calendar.get(11) + "\u70b9" + calendar.get(12) + "\u5206";
        }
        if (diff <= 31104000000L) {
            return diff / 2592000000L + "\u4e2a\u6708" + diff % 2592000000L / 86400000L + "\u5929\u524d" + calendar.get(11) + "\u70b9" + calendar.get(12) + "\u5206";
        }
        return diff / 31104000000L + "\u5e74\u524d" + (calendar.get(2) + 1) + "\u6708" + calendar.get(5) + "\u65e5";
    }

    public static String fromDeadline(Date date) {
        long now;
        long deadline = date.getTime();
        long remain = deadline - (now = System.currentTimeMillis());
        if (remain <= 3600000L) {
            return "\u53ea\u5269\u4e0b" + remain / 60000L + "\u5206\u949f";
        }
        if (remain <= 86400000L) {
            return "\u53ea\u5269\u4e0b" + remain / 3600000L + "\u5c0f\u65f6" + remain % 3600000L / 60000L + "\u5206\u949f";
        }
        long day = remain / 86400000L;
        long hour = remain % 86400000L / 3600000L;
        long minute = remain % 86400000L % 3600000L / 60000L;
        return "\u53ea\u5269\u4e0b" + day + "\u5929" + hour + "\u5c0f\u65f6" + minute + "\u5206\u949f";
    }

    public static long pastMinutes(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 60000L;
    }

    public static Timestamp getTimestamp() {
        Date date = new Date();
        Timestamp nousedate = new Timestamp(date.getTime());
        return nousedate;
    }

    public static int getSecondTimestamp(Date date) {
        if (null == date) {
            return 0;
        }
        String timestamp = String.valueOf(date.getTime() / 1000L);
        return Integer.valueOf(timestamp);
    }

    public static Date convertString2Date(String time) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = sdf.parse(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static long calculateTwoDateDvalue(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long date1value = cal.getTimeInMillis();
        cal.setTime(date2);
        long date2value = cal.getTimeInMillis();
        return date1value - date2value;
    }

    public static Date getDayStart(Date currentDate) {
        Date result = null;
        Calendar current = Calendar.getInstance();
        current.setTime(currentDate);
        current.set(11, 0);
        current.clear(14);
        current.clear(12);
        current.clear(13);
        result = current.getTime();
        return result;
    }
}

