package com.bcxin.backend.scheduling;

import com.bcxin.backend.service.BgScreeningService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * description: 背筛定时任务
 * author: linchunpeng
 * date:  2023-07-12 18:07
 */
@Slf4j
@Component
public class BgScreeningTask {

    @Autowired
    private BgScreeningService bgScreeningService;

    /**
     * description: 新入职员工背筛定时任务
     * author: linchunpeng
     * date:  2023-07-12 18:09
     */
    @Scheduled(cron = "${myapps.screening.scheduled.induction}")
    public void induction() {
        log.info("===================================新入职员工背筛定时任务===================================");
        bgScreeningService.runNewRecruit();
        log.info("===================================新入职员工背筛任务结束===================================");
    }

    /**
     * description: 定期背筛定时任务
     * author: linchunpeng
     * date:  2023-07-12 18:09
     */
    @Scheduled(cron = "${myapps.screening.scheduled.timing}")
    public void timing() {
        log.info("===================================定期背筛定时任务===================================");
        bgScreeningService.runIntervals();
        log.info("===================================定期背筛定时任务结束===================================");
    }

}
