/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.CoordinateProvider;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;

public class GeoFencing
extends HttpBase {
    public GeoFencing(String security) {
        super(security);
    }

    public GeoFencing(String security, Region region) {
        super(security, region);
    }

    public String createGeoFencingGroup(String packageName, String groupName, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_name", URLEncoder.encode(groupName, "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to create feo fencing group!");
            }
            boolean bl = tryAgain = (result = this.createGeoFencingGroupNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String createGeoFencingGroupNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_GEO_FENCING_GROUP_CREATE, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while create geo fencing group: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String deleteGeoGroup(String packageName, String groupId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_id", URLEncoder.encode(groupId, "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to delete feo fencing group!");
            }
            boolean bl = tryAgain = (result = this.deleteGeoFencingGroupNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String deleteGeoFencingGroupNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_GEO_FENCING_GROUP_DELETE, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while delete geo fencing group: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String renameGeoGroup(String packageName, String groupId, String groupName, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_id", URLEncoder.encode(groupId, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_name", URLEncoder.encode(groupName, "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to rename feo fencing group!");
            }
            boolean bl = tryAgain = (result = this.renameGeoFencingGroupNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String renameGeoFencingGroupNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_GEO_FENCING_GROUP_RENAME, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while rename geo fencing group: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String registerGeoFencingGroup(String packageName, String groupId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_id", URLEncoder.encode(groupId, "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to register feo fencing group!");
            }
            boolean bl = tryAgain = (result = this.registerGeoFencingGroupNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String registerGeoFencingGroupNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_GEO_FENCING_GROUP_REGISTER, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while register geo fencing group: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String addGeoFencingToGroup(String packageName, String groupId, String circles, String coordinateProvider, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_id", URLEncoder.encode(groupId, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_fencings_circles", URLEncoder.encode(circles, "UTF-8"));
        GeoFencing.addParameter(body, "geo_loc_provider", URLEncoder.encode(coordinateProvider, "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to add feo fencing to group!");
            }
            boolean bl = tryAgain = (result = this.addGeoFencingToGroupNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String addGeoFencingToGroupNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_GEO_FENCING_GROUP_FENCING_ADD, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while add geo fencing to group: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String removeGeoFencingFromGroup(String packageName, String groupId, String geoId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_id", URLEncoder.encode(groupId, "UTF-8"));
        GeoFencing.addParameter(body, "geo_id", URLEncoder.encode(geoId, "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to remove feo fencing from group!");
            }
            boolean bl = tryAgain = (result = this.removeGeoFencingFromGroupNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String removeGeoFencingFromGroupNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_GEO_FENCING_GROUP_FENCING_REMOVE, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while remove geo fencing from group: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String queryAllGeoFencingInGroup(String packageName, String groupId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_id", URLEncoder.encode(groupId, "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get all feo fencings from group!");
            }
            boolean bl = tryAgain = (result = this.queryAllGeoFencingInGroupNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String queryAllGeoFencingInGroupNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_GEO_FENCING_GROUP_FENCING_ALL, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while get all geo fencings from group: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String queryAllGeoFencingGroupByAppId(String packageName, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get all geo fencing groups by appId!");
            }
            boolean bl = tryAgain = (result = this.queryAllGeoFencingGroupByAppIdNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String queryAllGeoFencingGroupByAppIdNoRetry(String parameterBody) throws InvalidRequestException {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_APP_GEO_FENCING_GROUP_ALL, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while get all geo fencing groups by appid: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String createGeoFencing(String packageName, String groupId, double longitude, double latitude, double radius, String name, CoordinateProvider coordinateProvider, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_id", URLEncoder.encode(groupId, "UTF-8"));
        GeoFencing.addParameter(body, "longitude", URLEncoder.encode(Double.toString(longitude), "UTF-8"));
        GeoFencing.addParameter(body, "latitude", URLEncoder.encode(Double.toString(latitude), "UTF-8"));
        GeoFencing.addParameter(body, "radius", URLEncoder.encode(Double.toString(radius), "UTF-8"));
        GeoFencing.addParameter(body, "geo_name", URLEncoder.encode(name, "UTF-8"));
        GeoFencing.addParameter(body, "coordinate_provider", URLEncoder.encode(coordinateProvider.name(), "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to create feo fencing!");
            }
            boolean bl = tryAgain = (result = this.createGeoFencingNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String createGeoFencingNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_CREATE_GEO_FENCING, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while create geo fencing: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String deleteGeoFencing(String packageName, String groupId, String geoId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_id", URLEncoder.encode(groupId, "UTF-8"));
        GeoFencing.addParameter(body, "geo_id", URLEncoder.encode(geoId, "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to delete geo fencing!");
            }
            boolean bl = tryAgain = (result = this.deleteGeoFencingNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String deleteGeoFencingNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_DELETE_GEO_FENCING, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while delete geo fencing: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String registerGeoFencing(String packageName, String groupId, String geoId, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_id", URLEncoder.encode(groupId, "UTF-8"));
        GeoFencing.addParameter(body, "geo_id", URLEncoder.encode(geoId, "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to register geo fencing!");
            }
            boolean bl = tryAgain = (result = this.registerGeoFencingNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String registerGeoFencing(String packageName, String groupId, double longitude, double latitude, double radius, String name, CoordinateProvider coordinateProvider, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "geo_group_id", URLEncoder.encode(groupId, "UTF-8"));
        GeoFencing.addParameter(body, "longitude", URLEncoder.encode(Double.toString(longitude), "UTF-8"));
        GeoFencing.addParameter(body, "latitude", URLEncoder.encode(Double.toString(latitude), "UTF-8"));
        GeoFencing.addParameter(body, "radius", URLEncoder.encode(Double.toString(radius), "UTF-8"));
        GeoFencing.addParameter(body, "geo_name", URLEncoder.encode(name, "UTF-8"));
        GeoFencing.addParameter(body, "coordinate_provider", URLEncoder.encode(coordinateProvider.name(), "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to register geo fencing!");
            }
            boolean bl = tryAgain = (result = this.registerGeoFencingNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String registerGeoFencingNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_REGISTER_GEO_FENCING, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while register geo fencing: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }

    public String queryGeoFencing(String packageName, boolean registeredOnly, int retries) throws IOException {
        String result;
        boolean tryAgain;
        StringBuilder body = GeoFencing.newBody("restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
        GeoFencing.addParameter(body, "registered_only", URLEncoder.encode(Boolean.toString(registeredOnly), "UTF-8"));
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to query geo fencing!");
            }
            boolean bl = tryAgain = (result = this.queryGeoFencingNoRetry(body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = (backoff >> 1) + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff <<= 1;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    private String queryGeoFencingNoRetry(String parameterBody) {
        try {
            HttpURLConnection conn = this.doPost(Constants.XmPushRequestPath.V1_QUERY_REGISTERED_GEO_FENCING, parameterBody);
            return this.getResponseBody(conn);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while query geo fencing: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
    }
}

