/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.android.xiaomi;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.Utility;
import cn.wildfirechat.push.android.xiaomi.XiaomiConfig;
import com.google.gson.Gson;
import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.Sender;
import java.io.IOException;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XiaomiPush {
    private static final Logger LOG = LoggerFactory.getLogger(XiaomiPush.class);
    @Autowired
    private XiaomiConfig mConfig;

    public void push(PushMessage pushMessage) {
        Message message;
        Constants.useOfficial();
        Sender sender = new Sender(this.mConfig.getAppSecret());
        if (pushMessage.pushMessageType == 7) {
            pushMessage.pushContent = "\u60a8\u6536\u5230\u4e00\u6761\u5bc6\u804a\u6d88\u606f";
        }
        String token = pushMessage.getDeviceToken();
        pushMessage.deviceToken = null;
        if (pushMessage.pushMessageType == 1 || pushMessage.pushMessageType == 2 || pushMessage.pushMessageType == 4) {
            long timeToLive = 60000L;
            message = new Message.Builder().payload(new Gson().toJson((Object)pushMessage)).restrictedPackageName(pushMessage.getPackageName()).passThrough(1).timeToLive(timeToLive).enableFlowControl(false).extra("channel_id", this.mConfig.getChannelId()).build();
        } else {
            String[] arr = Utility.getPushTitleAndContent((PushMessage)pushMessage);
            String title = arr[0];
            String body = arr[1];
            long timeToLive = 600000L;
            message = new Message.Builder().payload(new Gson().toJson((Object)pushMessage)).title(title).description(body).notifyType(Integer.valueOf(-1)).restrictedPackageName(pushMessage.getPackageName()).passThrough(0).timeToLive(timeToLive).enableFlowControl(true).extra("channel_id", this.mConfig.getChannelId()).build();
        }
        Result result = null;
        try {
            result = sender.send(message, token, 3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        LOG.info("Server response: MessageId: " + result.getMessageId() + " ErrorCode: " + result.getErrorCode().toString() + " Reason: " + result.getReason());
    }
}

