/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.android.hms;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.android.hms.HMSConfig;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HMSPush {
    private static final Logger LOG = LoggerFactory.getLogger(HMSPush.class);
    private static final String tokenUrl = "https://login.vmall.com/oauth2/token";
    private static final String apiUrl = "https://api.push.hicloud.com/pushsend.do";
    private String accessToken;
    private long tokenExpiredTime;
    @Autowired
    private HMSConfig mConfig;

    private void refreshToken() throws IOException {
        LOG.info("hms refresh token");
        String msgBody = MessageFormat.format("grant_type=client_credentials&client_secret={0}&client_id={1}", URLEncoder.encode(this.mConfig.getAppSecret(), "UTF-8"), this.mConfig.getAppId());
        String response = this.httpPost(tokenUrl, msgBody, 5000, 5000);
        JSONObject obj = JSONObject.parseObject((String)response);
        this.accessToken = obj.getString("access_token");
        this.tokenExpiredTime = System.currentTimeMillis() + obj.getLong("expires_in") - 300000L;
        LOG.info("hms refresh token with result {}", (Object)response);
    }

    public void push(PushMessage pushMessage) {
        if (this.tokenExpiredTime <= System.currentTimeMillis()) {
            try {
                this.refreshToken();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        JSONArray deviceTokens = new JSONArray();
        deviceTokens.add((Object)pushMessage.getDeviceToken());
        JSONObject msg = new JSONObject();
        msg.put("type", (Object)1);
        String token = pushMessage.getDeviceToken();
        pushMessage.deviceToken = null;
        msg.put("body", (Object)new Gson().toJson((Object)pushMessage));
        JSONObject hps = new JSONObject();
        hps.put("msg", (Object)msg);
        JSONObject payload = new JSONObject();
        payload.put("hps", (Object)hps);
        LOG.info("send push to HMS {}", (Object)payload);
        try {
            String postBody = MessageFormat.format("access_token={0}&nsp_svc={1}&nsp_ts={2}&device_token_list={3}&payload={4}", URLEncoder.encode(this.accessToken, "UTF-8"), URLEncoder.encode("openpush.message.api.send", "UTF-8"), URLEncoder.encode(String.valueOf(System.currentTimeMillis() / 1000L), "UTF-8"), URLEncoder.encode(deviceTokens.toString(), "UTF-8"), URLEncoder.encode(payload.toString(), "UTF-8"));
            String postUrl = "https://api.push.hicloud.com/pushsend.do?nsp_ctx=" + URLEncoder.encode("{\"ver\":\"1\", \"appId\":\"" + this.mConfig.getAppId() + "\"}", "UTF-8");
            String response = this.httpPost(postUrl, postBody, 5000, 5000);
            LOG.info("Push to {} response {}", (Object)token, (Object)response);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.info("Push to {} with exception", (Object)token, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpPost(String httpUrl, String data, int connectTimeout, int readTimeout) throws IOException {
        String string;
        OutputStream outPut = null;
        HttpURLConnection urlConnection = null;
        InputStream in = null;
        try {
            URL url = new URL(httpUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            urlConnection.setConnectTimeout(connectTimeout);
            urlConnection.setReadTimeout(readTimeout);
            urlConnection.connect();
            outPut = urlConnection.getOutputStream();
            outPut.write(data.getBytes("UTF-8"));
            outPut.flush();
            in = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            List lines = IOUtils.readLines((InputStream)in, (String)urlConnection.getContentEncoding());
            StringBuffer strBuf = new StringBuffer();
            for (String line : lines) {
                strBuf.append(line);
            }
            LOG.info(strBuf.toString());
            string = strBuf.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outPut);
            IOUtils.closeQuietly(in);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outPut);
        IOUtils.closeQuietly((InputStream)in);
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return string;
    }
}

