package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.PoliceUserDao;
import com.bcxin.risk.user.domain.PoliceUser;
import com.bcxin.risk.user.dto.search.PoliceUserSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("policeUserDao")
@SuppressWarnings("unchecked")
public class PoliceUserDaoImpl extends DaoImpl<PoliceUser> implements PoliceUserDao {

    public PoliceUser findPoliceUserByName(String name) {
        return selectOne(CriterionWrapper.instance().eq("userName", name));
    }

    public PoliceUser findPoliceUserByOid(Long oid) {
        return selectById(oid);
    }

    @Override
    public List<PoliceUser> findPoliceUserList(PoliceUserSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (searchDto.getOrg() != null) {
            criterionList.add(Restrictions.eq("org", searchDto.getOrg()));
        }
        if (page == null) {
            return selectList(criterionList);
        }
        return selectPage(criterionList, page);
    }
}
