package com.bcxin.risk.survey;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.SurveyTask;
import com.bcxin.risk.survey.domain.Task;
import com.bcxin.risk.survey.domain.dto.serach.SurveyTaskSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("surveyTaskDao")
@SuppressWarnings("unchecked")
public class SurveyTaskDaoImpl extends DaoImpl<SurveyTask> implements SurveyTaskDao {
    public SurveyTask findSurveyTaskByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<SurveyTask> findSurveyTaskList(SurveyTaskSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getActivity()!= null ) {
            criterionList.add(Restrictions.eq("activity", searchDto.getActivity()));
        }
        if (StringUtil.isNotEmpty(searchDto.getName()) ) {
            criterionList.add(Restrictions.eq("name", searchDto.getName()));
        }
        if (StringUtil.isNotEmpty(searchDto.getTaskCode()) ) {
            criterionList.add(Restrictions.eq("taskCode", searchDto.getTaskCode()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }

    @Autowired
    private BaseDao baseDao;

    @Override
    public SurveyTask findSurveyTaskByTask(Task task){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("task", task));
        List<SurveyTask> list = baseDao.findByCriterion(SurveyTask.class, criterionList);
        if(CollectionUtil.isNotEmpty(list) ) {
            return list.get(0);
        }
        return null;
    }

}
