package com.bcxin.risk.survey;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.SurveyReform;
import com.bcxin.risk.survey.domain.dto.serach.SurveyRedormSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("surveyReformDao")
@SuppressWarnings("unchecked")
public class SurveyReformDaoImpl extends DaoImpl<SurveyReform> implements SurveyReformDao {

    @Override
    public SurveyReform findSurveyReformByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<SurveyReform> findSurveyReformList(SurveyRedormSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(searchDto.getResult()) ) {
            criterionList.add(Restrictions.eq("result", searchDto.getResult()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
}
