package com.bcxin.risk.survey;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.common.util.ObjectUtil;
import com.bcxin.risk.compose.dto.data.ComposeTaskDataDto;
import com.bcxin.risk.constant.Const;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.SurveyPlan;
import com.bcxin.risk.survey.domain.dto.serach.SurveyPlanSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.NullPrecedence;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@Repository("surveyPlanDao")
@SuppressWarnings("unchecked")
public class SurveyPlanDaoImpl extends DaoImpl<SurveyPlan> implements SurveyPlanDao {
    public SurveyPlan findSurveyPlanByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<SurveyPlan> findSurveyPlanList(SurveyPlanSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getSurveyStep() != null ) {
            criterionList.add(Restrictions.eq("survey", searchDto.getSurveyStep()));
        }
        if ( searchDto.getUser() != null ) {
            criterionList.add(Restrictions.eq("user", searchDto.getUser()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }


    public ComposeTaskDataDto findSign(Long activity_id){
        String sql = "select signImgPath as assgin_sign,userId as assgin_id from risk_surveyplan where taskId in (select oid from risk_surveytask where activityId = "+activity_id+" ) and time =1";
        List<Map<String, Object>> list = queryMaps(sql);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        for (Map<String, Object> map : list) {
            return new ComposeTaskDataDto(map);
        }
        return null;
    }

    /**
     * 根据任务id获取踏勘计划
     * @param taskId
     * @return
     */
    @Override
    public List<SurveyPlan> findSurveyPlanListBySurveyTaskId(Long taskId){
        List<Criterion> criterionList = new ArrayList<Criterion>();
        criterionList.add(Restrictions.eq("surveyTask.oid", taskId));
        Order[] orderList =new Order[]{Order.asc("beginTime").nulls(NullPrecedence.LAST),Order.asc("time")};
        return this.selectList(criterionList,orderList);
    }

    /**
     * 获取踏勘计划列表(taskId+阶段+场馆)
     * @param taskId 任务id
     * @param step 阶段
     * @param venueId 场馆id
     * @return
     */
    @Override
    public List<SurveyPlan> findSurveyPlan(Long taskId,String step,Long venueId){
        Wrapper wrapper=SelectWrapper.instance();
        wrapper.eq("venueId",venueId);
        wrapper.eq("taskId",taskId);
        wrapper.eq("surveyStep",step);
        return this.selectList(wrapper);
    }
}
