package com.bcxin.risk.report.material;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.material.dao.MaterialFormClassDao;
import com.bcxin.risk.report.material.domain.MaterialFormClass;
import com.bcxin.risk.report.material.dto.MaterialFormClassSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class MaterialFormClassDaoImpl extends DaoImpl<MaterialFormClass> implements MaterialFormClassDao {

	@Override
	public MaterialFormClass findMaterialFormClassByOid(Long oid){
		return selectById(oid);
	}

	@Override
	public List<MaterialFormClass> findMaterialFormClassList(MaterialFormClassSearchDto searchDto, Page page) {
		List<Criterion> criterionList = Lists.newArrayList();
		if ( searchDto.getMenus() != null ) {
			criterionList.add(Restrictions.eq("menus", searchDto.getMenus()));
		}
		if (StringUtil.isNotEmpty(searchDto.getClassCode()) ) {
			criterionList.add(Restrictions.eq("classCode", searchDto.getClassCode()));
		}
		if (StringUtil.isNotEmpty(searchDto.getClassName()) ) {
			criterionList.add(Restrictions.eq("className", searchDto.getClassName()));
		}
		if ( page == null ) {
			return selectList(criterionList);
		}
		return selectPage(criterionList,page);
	}


	@Override
	public List<MaterialFormClass> findAll() {
		Order order = Order.asc("seq");
		List list  =  selectList(order);
		if(list.size()>0){
			return list ;
		}
		return null ;

	}

	@Override
	public List<Map<String, Object>> getFormClassProgress(Long activityId){
		SelectWrapper wrapper = SelectWrapper.instance();
		String sql="SELECT A.oid as classId,A.className,\n" +
				" count(B.oid) as totalMenuNum,\n" +
				" sum(case when B.completed=1 then 1 else 0 end) completedNum,\n" +
				" CAST(sum(case when B.completed=1 then 1 else 0 end) * 100 /count(B.oid) AS signed ) as progress\n" +
				" from RISK_MaterialFormClass A\n" +
				" inner join RISK_MaterialFormMenu B on A.oid=B.class_id\n" +
				" where B.activity_id=" +activityId+
				" group by A.oid,A.className";
		return this.queryMaps(sql,wrapper);
	}

}
