package com.bcxin.risk.policy;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.PlanSpec;
import com.bcxin.risk.policy.dto.search.PlanSpecSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("planSpecDao")
@SuppressWarnings("unchecked")

public class PlanSpecDaoImpl extends DaoImpl<PlanSpec> implements PlanSpecDao {

    public  PlanSpec findPlanSpecByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List< PlanSpec> findPlanSpecList(PlanSpecSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(searchDto.getExternalReference()) ) {
            criterionList.add(Restrictions.eq("externalReference", searchDto.getExternalReference()));
        }
        if (StringUtil.isNotEmpty(searchDto.getName()) ) {
            criterionList.add(Restrictions.eq("name", searchDto.getName()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
}
