package com.bcxin.risk.policy;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.DutySpec;
import com.bcxin.risk.policy.dto.search.DutySpecSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("dutySpecDao")
@SuppressWarnings("unchecked")

public class DutySpecDaoImpl extends DaoImpl<DutySpec> implements DutySpecDao {

    @SuppressWarnings("unchecked")
    public List<DutySpec> dutySpecList() {
        List<Criterion> criterionList = Lists.newArrayList();
        return selectList(criterionList);
//        return  selectList(SelectWrapper.instance());

    }
    @Override
    public DutySpec findDutySpecByExter(String external) {
        return selectOne(CriterionWrapper.instance().eq("externalReference", external));
    }
    public DutySpec findDutySpecByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<DutySpec> findDutySpecList(DutySpecSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getInsuranceCompany() != null ) {
            criterionList.add(Restrictions.eq("insuranceCompany", searchDto.getInsuranceCompany()));
        }
        if (StringUtil.isNotEmpty(searchDto.getDescription()) ) {
            criterionList.add(Restrictions.eq("description", searchDto.getDescription()));
        }
        if (StringUtil.isNotEmpty(searchDto.getName()) ) {
            criterionList.add(Restrictions.eq("name", searchDto.getName()));}
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
}
