package com.bcxin.risk.org;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.ServiceOrgAuth;
import com.bcxin.risk.org.domain.ServiceOrgAuthDao;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public class ServiceOrgAuthDaoImpl extends DaoImpl<ServiceOrgAuth> implements ServiceOrgAuthDao {

    @Override
    public void deleteServiceOrgAuth(long orgId){
        DeleteWrapper wrapper = DeleteWrapper.instance();
        wrapper.eq("org_id",orgId);
        delete(wrapper);
    }

    @Override
    public List<ServiceOrgAuth> selectList(long orgId){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("org_id",orgId);
        return selectList(wrapper);
    }

    @Override
    public ServiceOrgAuth selectByType(long orgId,String authType){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("org_id",orgId);
        wrapper.eq("authType",authType);
        List<Object> list = selectList(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            return (ServiceOrgAuth)list.get(0);
        }
        return null;
    }

}
