package com.bcxin.risk.org;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.PoliceOrg;
import com.bcxin.risk.org.domain.PoliceOrgDao;
import com.bcxin.risk.org.dto.PolicerOrgSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("policeOrgDao")
@SuppressWarnings("unchecked")

public class PoliceOrgDaoImpl extends DaoImpl<PoliceOrg> implements PoliceOrgDao {
    @Override
    public PoliceOrg findPoliceOrgByOid(Long oid) {
        return selectById(oid);
    }


    @Override
    public List<PoliceOrg> findPoliceOrgList(PolicerOrgSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(searchDto.getDescription()) ) {
            criterionList.add(Restrictions.eq("description", searchDto.getDescription()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }


}
