package com.bcxin.risk.org;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.org.domain.OrgDao;
import com.bcxin.risk.org.dto.OrgDTO;
import com.bcxin.risk.report.enums.ApprovalStatus;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("orgDao")
@SuppressWarnings("unchecked")

public class OrgDaoImpl extends DaoImpl<Org> implements OrgDao {


    @Override
    public Org findOrgByOid(Long oid) {  return selectById(oid);
    }
    @Override
    public List<Org> findOrgList(OrgDTO orgDTO, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (orgDTO != null) {
            if (StringUtil.isNotEmpty(orgDTO.getUserName())) {
                criterionList.add(Restrictions.eq("userName", orgDTO.getUserName()));
            }
            if (StringUtil.isNotEmpty(orgDTO.getName())) {
                criterionList.add(Restrictions.eq("name", orgDTO.getName()));
            }
            if (StringUtil.isNotEmpty(orgDTO.getOrgType())) {
                criterionList.add(Restrictions.eq("orgType", orgDTO.getOrgType()));
            }
            if (StringUtil.isNotEmpty(orgDTO.getApprovalStatus())) {
                criterionList.add(Restrictions.eq("approvalStatus",ApprovalStatus.convert(orgDTO.getApprovalStatus())));
            }
        }
        return selectPage(criterionList,page);
    }


    // 更新用户
    @Override
    public int updateOrg(Org org){
        String sql = "Update risk_org " +
                       " SET code = '" + org.getCode() +"' , "+
                             " address = '"+ org.getAddress() +"' , "+
                              "province_id = '"+ org.getProvince_id() +"' , "+
                              "city_id = '"+ org.getCity_id() +"' , "+
                              "area_id = '"+ org.getArea_id() +"' , "+
                              "esignId = '"+ org.getEsignId() +"' , "+
                " updateOn = SYSDATE() "+
                     " WHERE oid = "+org.getOid()  ;
        return executeSqlUpdate(sql);
    }

    @Override
    public List<Org>  findOrgListByDto(OrgDTO dto) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.or(Restrictions.eq("isSync", DictConst.N),Restrictions.isNull("isSync")));
        if (StringUtil.isNotEmpty(dto.getOid())) {
            criterionList.add(Restrictions.eq("oid", dto.getOid()));
        }
        Order order = Order.desc("oid");
        return selectList(criterionList,order);

    }



}
