package com.bcxin.risk.order;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository
@SuppressWarnings("unchecked")
public class TransactionOnlineDaoImpl extends DaoImpl<TransactionOnline> implements TransactionOnlineDao {

    @Override
    public TransactionOnline findTransactionByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public TransactionOnline findTransactionByOrderNo(String orderNo) {
        CriterionWrapper wrapper = CriterionWrapper.instance();
        List list = selectList(wrapper.eq("orderNo", orderNo));
        if (CollectionUtil.isNotEmpty(list)) {
            return (TransactionOnline)list.get(0);
        }
        return null;
    }

    @Override
    public TransactionOnline findTransactionByOrder(OrderForm orderForm) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (orderForm != null ) {
            criterionList.add(Restrictions.eq("orderForm", orderForm));
        }
        return selectOne(criterionList);
    }

}
