package com.bcxin.risk.expert;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.enums.ExpertTaskStatusEnum;
import com.bcxin.risk.expert.domain.ExpertOrderPublic;
import com.bcxin.risk.expert.dto.ExpertOrderPublicDto;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.surveytk.domain.dto.SurveyTaskDataDto;
import com.bcxin.risk.user.domain.ExpertUser;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 共享专家订单DAO层
 */
@Repository("expertOrderPublicDao")
public class ExpertOrderPublicDaoImpl extends DaoImpl<ExpertOrderPublic> implements ExpertOrderPublicDao {

    @Override
    public List<ExpertOrderPublicDto> findOrderList(ExpertOrderPublicDto searchDto, Page page){
        List<Map<String, Object>> list = Lists.newArrayList();
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT" +
                " DATE_FORMAT(A.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                " A.oid," +
                " A.activityId," +
                " A.reportId," +
                " A.taskId," +
                " B.`name` as activityName," +
                " A.expertSource," +
                " A.orderNo," +
                " A.orgId," +
                " A.taskQuote," +
                " A.taskStatus," +
                " A.taskType," +
                " A.userId," +
                " C.realName" +
                " FROM" +
                " risk_expertorderform_public A" +
                " INNER JOIN risk_activity B ON A.activityId = B.oid" +
                " INNER JOIN risk_se_user C ON A.userId = C.oid" +
                " INNER JOIN risk_expertuser D on C.oid = D.oid" +
                " WHERE 1=1 "
                );

        if(searchDto.getOrgId()!=null){
            sql.append(" and A.orgId="+searchDto.getOrgId()+" ");
        }
        if(StringUtil.isNotEmpty(searchDto.getTaskStatus())){
            sql.append(" and A.taskStatus='"+searchDto.getTaskStatus()+"' ");
        }
        if(StringUtil.isNotEmpty(searchDto.getTaskType())){
            sql.append(" and A.taskType='"+searchDto.getTaskType()+"' ");
        }
        wrapper.orderBy("A.createOn", false);

        if ( page == null ){
            list = queryMaps(sql.toString(), wrapper);
        }else{
            Page<Map<String, Object>> pageList = queryMapsPage(sql.toString(), wrapper, page);
            list = pageList.getRecords();
        }

        List<ExpertOrderPublicDto> dtoList = new ArrayList<>();
        list.forEach(result ->{
            ExpertOrderPublicDto dto = new ExpertOrderPublicDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public ExpertOrderPublic findExpertByIdWithActivity(Long activityId,Long expertId,String taskType){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("activityId", activityId));
        criterionList.add(Restrictions.eq("userId", expertId));
        criterionList.add(Restrictions.eq("taskType", taskType));
        List list = selectList(criterionList);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (ExpertOrderPublic)list.get(0);
    }

    /**
     * 根据活动+类型更新状态，只更新未接单和拒绝的状态
     * @param activityId
     * @param taskType
     * @param taskStatus
     */
    @Override
    public void updateStatusToCancel(Long activityId,String taskType,String taskStatus){
        String sql="update risk_expertorderform_public set taskStatus='"+taskStatus+"' ";
        sql+=" where activityId="+activityId+" and taskType='"+taskType+"'";
        sql+=" and taskStatus in ('"+ExpertTaskStatusEnum.UN_ACCEPT.getKey()+"','"+ExpertTaskStatusEnum.REFUSE.getKey()+"')";
        this.executeSqlUpdate(sql);
    }

    @Override
    public void updateStatus(Long activityId,Long expertId,String taskType,String taskStatus){
        String sql="update risk_expertorderform_public set taskStatus='"+taskStatus+"' ";
        sql+=" where activityId="+activityId+" and taskType='"+taskType+"'";
        sql+=" and userId="+expertId;
        int num=this.executeSqlUpdate(sql);
    }

    @Override
    public int selectOrderCountByExpertId(Long userId,String taskType,String taskStatus){
        List<Criterion> criterionList = Lists.newArrayList();
        List<String> listStatus=new ArrayList<>();
        listStatus.add(ExpertTaskStatusEnum.ACCEPT.getKey());
        listStatus.add(ExpertTaskStatusEnum.FINISH.getKey());
        criterionList.add(Restrictions.in("taskStatus",listStatus));
        if(StringUtil.isNotEmpty(taskStatus)) {
            criterionList.add(Restrictions.eq("taskStatus", taskStatus));
        }
        criterionList.add(Restrictions.eq("userId", userId));
        criterionList.add(Restrictions.eq("taskType", taskType));
        List list = selectList(criterionList);
        if (CollectionUtil.isEmpty(list)) {
            return 0;
        }
        return list.size();

    }
}
