package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.data.QuotationDTO;
import com.bcxin.risk.activity.dto.search.QuotationSearchDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public class QuotationDaoImpl extends DaoImpl<Quotation> implements QuotationDao {

    @Override
    public Quotation findQuotationByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<Quotation> findQuotationList(QuotationSearchDTO searchDTO) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDTO.getOrg() != null ) {
            criterionList.add(Restrictions.eq("org", searchDTO.getOrg()));
        }
        if (StringUtil.isNotEmpty(searchDTO.getActive())) {
            criterionList.add(Restrictions.eq("active", searchDTO.getActive()));
        }
        return selectList(criterionList);
    }

    @Override
    public List<QuotationDTO> findQuotationList(QuotationSearchDTO searchDTO, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDTO.getOrg() != null ) {
            criterionList.add(Restrictions.eq("org", searchDTO.getOrg()));
        }
        if (StringUtil.isNotEmpty(searchDTO.getActive())) {
            criterionList.add(Restrictions.eq("active", searchDTO.getActive()));
        }
        if (StringUtil.isNotEmpty(searchDTO.getKeyName())) {
            criterionList.add(Restrictions.like("name", "%"+searchDTO.getKeyName()+"%"));
        }
        List<QuotationDTO> dtoList = Lists.newArrayList();
        List<Quotation> list = Lists.newArrayList();
        if ( page == null ) {
            list = selectList(criterionList);
        } else {
            list = selectPage(criterionList, page);
        }
        for (Quotation q: list) {
            QuotationDTO dto = new QuotationDTO(q);
            dto.setPage(page);
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    public Quotation getQuotationByName(String name,String orgId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("name",name);
        wrapper.eq("org_id",orgId);
        wrapper.eq("active","1");
        List<Quotation> list = selectList(wrapper);
        if(list.size()>0){
            return list.get(0);
        }
        return null;
    }

}
